/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.custom.impl;

import com.aelitis.azureus.core.custom.Customization;
import com.aelitis.azureus.core.custom.CustomizationException;
import com.aelitis.azureus.core.custom.impl.CustomizationManagerImpl;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.gudy.azureus2.core3.util.Debug;

public class CustomizationImpl
implements Customization {
    private CustomizationManagerImpl manager;
    private String name;
    private String version;
    private File contents;

    protected CustomizationImpl(CustomizationManagerImpl _manager, String _name, String _version, File _contents) throws CustomizationException {
        this.manager = _manager;
        this.name = _name;
        this.version = _version;
        this.contents = _contents;
        if (!this.contents.exists()) {
            throw new CustomizationException("Content file '" + this.contents + " not found");
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    protected File getContents() {
        return this.contents;
    }

    @Override
    public Object getProperty(String name) {
        return null;
    }

    @Override
    public boolean isActive() {
        return true;
    }

    @Override
    public void setActive(boolean active) {
    }

    @Override
    public InputStream getResource(String resource_name) {
        return null;
    }

    @Override
    public InputStream[] getResources(String resource_name) {
        ArrayList<ByteArrayInputStream> result;
        block16: {
            result = new ArrayList<ByteArrayInputStream>();
            ZipInputStream zis = null;
            try {
                try {
                    ZipEntry entry;
                    zis = new ZipInputStream(new BufferedInputStream(new FileInputStream(this.contents)));
                    while ((entry = zis.getNextEntry()) != null) {
                        int len;
                        String name = entry.getName();
                        int pos = name.indexOf(String.valueOf(resource_name) + "/");
                        if (pos == -1 || !name.endsWith(".vuze")) continue;
                        ByteArrayOutputStream baos = new ByteArrayOutputStream(16384);
                        byte[] buffer = new byte[16384];
                        while ((len = zis.read(buffer)) > 0) {
                            baos.write(buffer, 0, len);
                        }
                        result.add(new ByteArrayInputStream(baos.toByteArray()));
                    }
                }
                catch (Throwable e) {
                    Debug.out(e);
                    if (zis != null) {
                        try {
                            zis.close();
                        }
                        catch (Throwable throwable) {}
                    }
                    break block16;
                }
            }
            catch (Throwable throwable) {
                if (zis != null) {
                    try {
                        zis.close();
                    }
                    catch (Throwable throwable2) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            if (zis != null) {
                try {
                    zis.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        return result.toArray(new InputStream[result.size()]);
    }

    @Override
    public void exportToVuzeFile(File file) throws CustomizationException {
        this.manager.exportCustomization(this, file);
    }
}

