/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.clientmessageservice.impl;

import com.aelitis.azureus.core.clientmessageservice.impl.ClientConnection;
import com.aelitis.azureus.core.clientmessageservice.impl.ClientMessage;
import com.aelitis.azureus.core.networkmanager.VirtualChannelSelector;
import com.aelitis.azureus.core.peermanager.messaging.Message;
import com.aelitis.azureus.core.peermanager.messaging.azureus.AZGenericMapPayload;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Debug;

public class NonBlockingReadWriteService {
    private final VirtualChannelSelector read_selector;
    private final VirtualChannelSelector write_selector;
    private final ArrayList connections = new ArrayList();
    private final AEMonitor connections_mon = new AEMonitor("connections");
    private final ServiceListener listener;
    private final String service_name;
    private volatile boolean destroyed;
    private long last_timeout_check_time = 0L;
    private static final int TIMEOUT_CHECK_INTERVAL_MS = 10000;
    private final int activity_timeout_period_ms;
    private final int close_delay_period_ms;

    public NonBlockingReadWriteService(String _service_name, int timeout, ServiceListener _listener) {
        this(_service_name, timeout, 0, _listener);
    }

    public NonBlockingReadWriteService(String _service_name, int timeout, int close_delay, ServiceListener _listener) {
        this.service_name = _service_name;
        this.listener = _listener;
        this.read_selector = new VirtualChannelSelector(this.service_name, 1, false);
        this.write_selector = new VirtualChannelSelector(this.service_name, 4, true);
        if (timeout < 10) {
            timeout = 10;
        }
        this.activity_timeout_period_ms = timeout * 1000;
        this.close_delay_period_ms = close_delay * 1000;
        new AEThread2("[" + this.service_name + "] Service Select", true){

            @Override
            public void run() {
                while (true) {
                    boolean stop_after_select;
                    if (stop_after_select = NonBlockingReadWriteService.this.destroyed) {
                        NonBlockingReadWriteService.this.read_selector.destroy();
                        NonBlockingReadWriteService.this.write_selector.destroy();
                    }
                    try {
                        NonBlockingReadWriteService.this.read_selector.select(50L);
                        NonBlockingReadWriteService.this.write_selector.select(50L);
                    }
                    catch (Throwable t) {
                        Debug.out("[" + NonBlockingReadWriteService.this.service_name + "] SelectorLoop() EXCEPTION: ", t);
                    }
                    if (stop_after_select) break;
                    NonBlockingReadWriteService.this.doConnectionTimeoutChecks();
                }
            }
        }.start();
    }

    public void destroy() {
        try {
            this.connections_mon.enter();
            this.connections.clear();
            this.destroyed = true;
        }
        finally {
            this.connections_mon.exit();
        }
    }

    public void addClientConnection(ClientConnection connection) {
        try {
            this.connections_mon.enter();
            if (this.destroyed) {
                Debug.out("connection added after destroy");
            }
            this.connections.add(connection);
        }
        finally {
            this.connections_mon.exit();
        }
        this.registerForSelection(connection);
    }

    public void removeClientConnection(ClientConnection connection) {
        this.read_selector.cancel(connection.getSocketChannel());
        this.write_selector.cancel(connection.getSocketChannel());
        try {
            this.connections_mon.enter();
            this.connections.remove(connection);
        }
        finally {
            this.connections_mon.exit();
        }
    }

    private void registerForSelection(final ClientConnection client) {
        VirtualChannelSelector.VirtualSelectorListener read_listener = new VirtualChannelSelector.VirtualSelectorListener(){

            @Override
            public boolean selectSuccess(VirtualChannelSelector selector, SocketChannel sc, Object attachment) {
                try {
                    Message[] messages = client.readMessages();
                    if (messages != null) {
                        int i = 0;
                        while (i < messages.length) {
                            AZGenericMapPayload msg = (AZGenericMapPayload)messages[i];
                            ClientMessage client_msg = new ClientMessage(msg.getID(), client, msg.getMapPayload(), null);
                            NonBlockingReadWriteService.this.listener.messageReceived(client_msg);
                            ++i;
                        }
                    }
                    return client.getLastReadMadeProgress();
                }
                catch (Throwable t) {
                    client.isClosePending();
                    NonBlockingReadWriteService.this.listener.connectionError(client, t);
                    return false;
                }
            }

            @Override
            public void selectFailure(VirtualChannelSelector selector, SocketChannel sc, Object attachment, Throwable msg) {
                if (!NonBlockingReadWriteService.this.destroyed) {
                    msg.printStackTrace();
                }
                NonBlockingReadWriteService.this.listener.connectionError(client, msg);
            }
        };
        VirtualChannelSelector.VirtualSelectorListener write_listener = new VirtualChannelSelector.VirtualSelectorListener(){

            @Override
            public boolean selectSuccess(VirtualChannelSelector selector, SocketChannel sc, Object attachment) {
                try {
                    boolean more_writes_needed = client.writeMessages();
                    if (more_writes_needed) {
                        NonBlockingReadWriteService.this.write_selector.resumeSelects(client.getSocketChannel());
                    }
                    return client.getLastWriteMadeProgress();
                }
                catch (Throwable t) {
                    NonBlockingReadWriteService.this.listener.connectionError(client, t);
                    return false;
                }
            }

            @Override
            public void selectFailure(VirtualChannelSelector selector, SocketChannel sc, Object attachment, Throwable msg) {
                if (!NonBlockingReadWriteService.this.destroyed) {
                    msg.printStackTrace();
                }
                NonBlockingReadWriteService.this.listener.connectionError(client, msg);
            }
        };
        this.write_selector.register(client.getSocketChannel(), write_listener, null);
        this.write_selector.pauseSelects(client.getSocketChannel());
        this.read_selector.register(client.getSocketChannel(), read_listener, null);
    }

    private void doConnectionTimeoutChecks() {
        long time = System.currentTimeMillis();
        if (time < this.last_timeout_check_time || time - this.last_timeout_check_time > 10000L) {
            ArrayList<ClientConnection> timed_out = new ArrayList<ClientConnection>();
            try {
                this.connections_mon.enter();
                long current_time = System.currentTimeMillis();
                int i = 0;
                while (i < this.connections.size()) {
                    ClientConnection vconn = (ClientConnection)this.connections.get(i);
                    if (current_time < vconn.getLastActivityTime()) {
                        vconn.resetLastActivityTime();
                    } else if (current_time - vconn.getLastActivityTime() > (long)this.activity_timeout_period_ms || this.close_delay_period_ms > 0 && current_time - vconn.getLastActivityTime() > (long)this.close_delay_period_ms) {
                        timed_out.add(vconn);
                    }
                    ++i;
                }
            }
            finally {
                this.connections_mon.exit();
            }
            int i = 0;
            while (i < timed_out.size()) {
                ClientConnection vconn = (ClientConnection)timed_out.get(i);
                this.listener.connectionError(vconn, new Exception("Timeout"));
                ++i;
            }
            this.last_timeout_check_time = System.currentTimeMillis();
        }
    }

    public void sendMessage(ClientMessage message) {
        boolean still_connected;
        ClientConnection vconn = message.getClient();
        try {
            this.connections_mon.enter();
            still_connected = this.connections.contains(vconn);
        }
        finally {
            this.connections_mon.exit();
        }
        if (!still_connected) {
            message.reportFailed(new Exception("No longer connected"));
            return;
        }
        AZGenericMapPayload reply = new AZGenericMapPayload(message.getMessageID(), message.getPayload(), 1);
        vconn.sendMessage(message, reply);
        this.write_selector.resumeSelects(vconn.getSocketChannel());
    }

    public static interface ServiceListener {
        public void messageReceived(ClientMessage var1);

        public void connectionError(ClientConnection var1, Throwable var2);
    }
}

