/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.activities;

import com.aelitis.azureus.activities.VuzeActivitiesEntry;
import com.aelitis.azureus.activities.VuzeActivitiesListener;
import com.aelitis.azureus.activities.VuzeActivitiesLoadedListener;
import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreLifecycleAdapter;
import com.aelitis.azureus.core.cnetwork.ContentNetwork;
import com.aelitis.azureus.core.cnetwork.ContentNetworkListener;
import com.aelitis.azureus.core.cnetwork.ContentNetworkManager;
import com.aelitis.azureus.core.cnetwork.ContentNetworkManagerFactory;
import com.aelitis.azureus.core.cnetwork.ContentNetworkPropertyChangeListener;
import com.aelitis.azureus.core.messenger.config.PlatformVuzeActivitiesMessenger;
import com.aelitis.azureus.util.ConstantsVuze;
import com.aelitis.azureus.util.MapUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.AEDiagnosticsLogger;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;

public class VuzeActivitiesManager {
    public static final long MAX_LIFE_MS = 63072000000L;
    private static final long DEFAULT_PLATFORM_REFRESH = 86400000L;
    private static final String SAVE_FILENAME = "VuzeActivities.config";
    private static ArrayList<VuzeActivitiesListener> listeners = new ArrayList();
    private static ArrayList<VuzeActivitiesLoadedListener> listenersLoaded = new ArrayList();
    private static final Object listenersLoadedLock = new Object();
    private static ArrayList<VuzeActivitiesEntry> allEntries = new ArrayList();
    private static AEMonitor allEntries_mon = new AEMonitor("VuzeActivityMan");
    private static List<VuzeActivitiesEntry> removedEntries = new ArrayList<VuzeActivitiesEntry>();
    private static PlatformVuzeActivitiesMessenger.GetEntriesReplyListener replyListener;
    private static AEDiagnosticsLogger diag_logger;
    private static Map<String, Long> lastNewsAt;
    private static boolean skipAutoSave;
    private static AEMonitor config_mon;
    private static boolean saveEventsOnClose;

    static {
        lastNewsAt = new HashMap<String, Long>();
        skipAutoSave = true;
        config_mon = new AEMonitor("ConfigMon");
        saveEventsOnClose = false;
        if (System.getProperty("debug.vuzenews", "0").equals("1")) {
            diag_logger = AEDiagnostics.getLogger("v3.vuzenews");
            diag_logger.log("\n\nVuze News Logging Starts");
        } else {
            diag_logger = null;
        }
    }

    public static void initialize(final AzureusCore core) {
        new AEThread2("lazy init", true){

            @Override
            public void run() {
                VuzeActivitiesManager._initialize(core);
            }
        }.start();
    }

    private static void _initialize(AzureusCore core) {
        if (diag_logger != null) {
            diag_logger.log("Initialize Called");
        }
        core.addLifecycleListener(new AzureusCoreLifecycleAdapter(){

            @Override
            public void stopping(AzureusCore core) {
                if (saveEventsOnClose) {
                    VuzeActivitiesManager.saveEventsNow();
                }
            }
        });
        VuzeActivitiesManager.loadEvents();
        ContentNetworkManager cnm = ContentNetworkManagerFactory.getSingleton();
        if (cnm != null) {
            ContentNetwork[] contentNetworks = cnm.getContentNetworks();
            cnm.addListener(new ContentNetworkListener(){

                @Override
                public void networkRemoved(ContentNetwork network) {
                }

                @Override
                public void networkChanged(ContentNetwork network) {
                }

                @Override
                public void networkAdded(ContentNetwork cn) {
                    VuzeActivitiesManager.setupContentNetwork(cn);
                }

                @Override
                public void networkAddFailed(long network_id, Throwable error) {
                }
            });
            ContentNetwork[] contentNetworkArray = contentNetworks;
            int n = contentNetworks.length;
            int n2 = 0;
            while (n2 < n) {
                ContentNetwork cn = contentNetworkArray[n2];
                VuzeActivitiesManager.setupContentNetwork(cn);
                ++n2;
            }
        }
        replyListener = new PlatformVuzeActivitiesMessenger.GetEntriesReplyListener(){

            @Override
            public void gotVuzeNewsEntries(VuzeActivitiesEntry[] entries, long refreshInMS) {
                if (diag_logger != null) {
                    diag_logger.log("Received Reply from platform with " + entries.length + " entries.  Refresh in " + refreshInMS);
                }
                VuzeActivitiesManager.addEntries(entries);
                if (refreshInMS <= 0L) {
                    refreshInMS = 86400000L;
                }
                SimpleTimer.addEvent("GetVuzeNews", SystemTime.getOffsetTime(refreshInMS), new TimerEventPerformer(){

                    @Override
                    public void perform(TimerEvent event2) {
                        VuzeActivitiesManager.pullActivitiesNow(5000L, "timer", false);
                    }
                });
            }
        };
        VuzeActivitiesManager.pullActivitiesNow(5000L, "initial", false);
    }

    private static void setupContentNetwork(final ContentNetwork cn) {
        cn.addPersistentPropertyChangeListener(new ContentNetworkPropertyChangeListener(){

            @Override
            public void propertyChanged(String name) {
                boolean isActive;
                if (!"active".equals(name)) {
                    return;
                }
                Object oIsActive = cn.getPersistentProperty("active");
                boolean bl = isActive = oIsActive instanceof Boolean ? (Boolean)oIsActive : false;
                if (isActive) {
                    VuzeActivitiesManager.pullActivitiesNow(2000L, "CN:PropChange", false);
                }
            }
        });
    }

    public static void pullActivitiesNow(long delay, String reason, boolean alwaysPull) {
        ContentNetwork cn = ConstantsVuze.getDefaultContentNetwork();
        if (cn == null) {
            return;
        }
        String id = "" + cn.getID();
        Long oLastPullTime = lastNewsAt.get(id);
        long lastPullTime = oLastPullTime != null ? oLastPullTime : 0L;
        long now = SystemTime.getCurrentTime();
        long diff = now - lastPullTime;
        if (!alwaysPull && diff < 5000L) {
            return;
        }
        if (diff > 63072000000L) {
            diff = 63072000000L;
        }
        PlatformVuzeActivitiesMessenger.getEntries(diff, delay, reason, replyListener);
    }

    public static void clearLastPullTimes() {
        lastNewsAt = new HashMap<String, Long>();
    }

    public static void resetRemovedEntries() {
        removedEntries.clear();
        VuzeActivitiesManager.saveEvents();
    }

    private static void saveEvents() {
        saveEventsOnClose = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadEvents() {
        block42: {
            Object value2;
            long cutoffTime;
            block41: {
                List newRemovedEntries;
                long lastVuzeNewsAt;
                Map map;
                block40: {
                    skipAutoSave = true;
                    map = FileUtil.readResilientConfigFile(SAVE_FILENAME);
                    if (map == null || map.size() <= 0 || MapUtils.getMapLong(map, "version", 0L) >= 2L) break block40;
                    VuzeActivitiesManager.clearLastPullTimes();
                    skipAutoSave = false;
                    VuzeActivitiesManager.saveEventsNow();
                    skipAutoSave = false;
                    Object object = listenersLoadedLock;
                    synchronized (object) {
                        if (listenersLoaded != null) {
                            for (VuzeActivitiesLoadedListener l : listenersLoaded) {
                                try {
                                    l.vuzeActivitiesLoaded();
                                }
                                catch (Exception e) {
                                    Debug.out(e);
                                }
                            }
                            listenersLoaded = null;
                        }
                    }
                    return;
                }
                cutoffTime = VuzeActivitiesManager.getCutoffTime();
                try {
                    lastNewsAt = MapUtils.getMapMap(map, "LastChecks", new HashMap());
                }
                catch (Exception e) {
                    Debug.out(e);
                }
                if (lastNewsAt.size() == 0 && (lastVuzeNewsAt = MapUtils.getMapLong(map, "LastCheck", 0L)) > 0L) {
                    if (lastVuzeNewsAt < cutoffTime) {
                        lastVuzeNewsAt = cutoffTime;
                    }
                    lastNewsAt.put("1", new Long(lastVuzeNewsAt));
                }
                if ((newRemovedEntries = (List)MapUtils.getMapObject(map, "removed-entries", null, List.class)) != null) {
                    for (Object value2 : newRemovedEntries) {
                        VuzeActivitiesEntry entry;
                        if (!(value2 instanceof Map) || (entry = VuzeActivitiesManager.createEntryFromMap((Map)value2, true)) == null || entry.getTimestamp() <= cutoffTime) continue;
                        removedEntries.add(entry);
                    }
                }
                if ((value2 = map.get("entries")) instanceof List) break block41;
                skipAutoSave = false;
                Object object = listenersLoadedLock;
                synchronized (object) {
                    if (listenersLoaded != null) {
                        for (VuzeActivitiesLoadedListener l : listenersLoaded) {
                            try {
                                l.vuzeActivitiesLoaded();
                            }
                            catch (Exception e) {
                                Debug.out(e);
                            }
                        }
                        listenersLoaded = null;
                    }
                }
                return;
            }
            try {
                List entries = (List)value2;
                ArrayList<VuzeActivitiesEntry> entriesToAdd = new ArrayList<VuzeActivitiesEntry>(entries.size());
                for (Object value2 : entries) {
                    VuzeActivitiesEntry entry;
                    if (!(value2 instanceof Map) || (entry = VuzeActivitiesManager.createEntryFromMap((Map)value2, true)) == null || entry.getTimestamp() <= cutoffTime) continue;
                    entriesToAdd.add(entry);
                }
                int num = entriesToAdd.size();
                if (num > 0) {
                    VuzeActivitiesManager.addEntries(entriesToAdd.toArray(new VuzeActivitiesEntry[num]));
                }
                break block42;
            }
            catch (Throwable throwable) {
                skipAutoSave = false;
                Object object = listenersLoadedLock;
                synchronized (object) {
                    if (listenersLoaded != null) {
                        for (VuzeActivitiesLoadedListener l : listenersLoaded) {
                            try {
                                l.vuzeActivitiesLoaded();
                            }
                            catch (Exception e) {
                                Debug.out(e);
                            }
                        }
                        listenersLoaded = null;
                    }
                }
            }
            throw throwable;
        }
        skipAutoSave = false;
        Object object = listenersLoadedLock;
        synchronized (object) {
            if (listenersLoaded != null) {
                for (VuzeActivitiesLoadedListener l : listenersLoaded) {
                    try {
                        l.vuzeActivitiesLoaded();
                    }
                    catch (Exception e) {
                        Debug.out(e);
                    }
                }
                listenersLoaded = null;
            }
        }
    }

    private static void saveEventsNow() {
        if (skipAutoSave) {
            return;
        }
        try {
            try {
                config_mon.enter();
                HashMap<String, Object> mapSave = new HashMap<String, Object>();
                mapSave.put("LastChecks", lastNewsAt);
                mapSave.put("version", new Long(2L));
                ArrayList<Map<String, Object>> entriesList = new ArrayList<Map<String, Object>>();
                VuzeActivitiesEntry[] allEntriesArray = VuzeActivitiesManager.getAllEntries();
                int i = 0;
                while (i < allEntriesArray.length) {
                    boolean isHeader;
                    VuzeActivitiesEntry entry = allEntriesArray[i];
                    if (entry != null && !(isHeader = "Header".equals(entry.getTypeID()))) {
                        entriesList.add(entry.toMap());
                    }
                    ++i;
                }
                mapSave.put("entries", entriesList);
                ArrayList<Map<String, Object>> removedEntriesList = new ArrayList<Map<String, Object>>();
                for (VuzeActivitiesEntry entry : removedEntries) {
                    removedEntriesList.add(entry.toDeletedMap());
                }
                mapSave.put("removed-entries", removedEntriesList);
                FileUtil.writeResilientConfigFile(SAVE_FILENAME, mapSave);
            }
            catch (Throwable t) {
                Debug.out(t);
                config_mon.exit();
            }
        }
        finally {
            config_mon.exit();
        }
    }

    public static long getCutoffTime() {
        return SystemTime.getOffsetTime(-63072000000L);
    }

    public static void addListener(VuzeActivitiesListener l) {
        listeners.add(l);
    }

    public static void removeListener(VuzeActivitiesListener l) {
        listeners.remove(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addListener(VuzeActivitiesLoadedListener l) {
        Object object = listenersLoadedLock;
        synchronized (object) {
            if (listenersLoaded != null) {
                listenersLoaded.add(l);
            } else {
                try {
                    l.vuzeActivitiesLoaded();
                }
                catch (Exception e) {
                    Debug.out(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeListener(VuzeActivitiesLoadedListener l) {
        Object object = listenersLoadedLock;
        synchronized (object) {
            if (listenersLoaded != null) {
                listenersLoaded.remove(l);
            }
        }
    }

    public static VuzeActivitiesEntry[] addEntries(VuzeActivitiesEntry[] entries) {
        long cutoffTime = VuzeActivitiesManager.getCutoffTime();
        ArrayList<VuzeActivitiesEntry> newEntries = new ArrayList<VuzeActivitiesEntry>(entries.length);
        ArrayList<VuzeActivitiesEntry> existingEntries = new ArrayList<VuzeActivitiesEntry>(0);
        try {
            allEntries_mon.enter();
            int i = 0;
            while (i < entries.length) {
                VuzeActivitiesEntry entry = entries[i];
                boolean isHeader = "Header".equals(entry.getTypeID());
                if ((entry.getTimestamp() >= cutoffTime || isHeader) && !removedEntries.contains(entry)) {
                    if (allEntries.contains(entry)) {
                        existingEntries.add(entry);
                    } else {
                        newEntries.add(entry);
                        allEntries.add(entry);
                    }
                }
                ++i;
            }
        }
        finally {
            allEntries_mon.exit();
        }
        VuzeActivitiesEntry[] newEntriesArray = newEntries.toArray(new VuzeActivitiesEntry[newEntries.size()]);
        if (newEntriesArray.length > 0) {
            VuzeActivitiesManager.saveEventsNow();
            Object[] listenersArray = listeners.toArray();
            int i = 0;
            while (i < listenersArray.length) {
                VuzeActivitiesListener l = (VuzeActivitiesListener)listenersArray[i];
                l.vuzeNewsEntriesAdded(newEntriesArray);
                ++i;
            }
        }
        if (existingEntries.size() > 0) {
            if (newEntriesArray.length == 0) {
                VuzeActivitiesManager.saveEvents();
            }
            for (VuzeActivitiesEntry entry : existingEntries) {
                VuzeActivitiesManager.triggerEntryChanged(entry);
            }
        }
        return newEntriesArray;
    }

    public static void removeEntries(VuzeActivitiesEntry[] entries) {
        VuzeActivitiesManager.removeEntries(entries, false);
    }

    public static void removeEntries(VuzeActivitiesEntry[] entries, boolean allowReAdd) {
        long cutoffTime = VuzeActivitiesManager.getCutoffTime();
        try {
            allEntries_mon.enter();
            int i = 0;
            while (i < entries.length) {
                VuzeActivitiesEntry entry = entries[i];
                if (entry != null) {
                    allEntries.remove(entry);
                    boolean isHeader = "Header".equals(entry.getTypeID());
                    if (!allowReAdd && entry.getTimestamp() > cutoffTime && !isHeader) {
                        removedEntries.add(entry);
                    }
                }
                ++i;
            }
        }
        finally {
            allEntries_mon.exit();
        }
        Object[] listenersArray = listeners.toArray();
        int i = 0;
        while (i < listenersArray.length) {
            VuzeActivitiesListener l = (VuzeActivitiesListener)listenersArray[i];
            l.vuzeNewsEntriesRemoved(entries);
            ++i;
        }
        VuzeActivitiesManager.saveEventsNow();
    }

    public static VuzeActivitiesEntry getEntryByID(String id) {
        try {
            allEntries_mon.enter();
            for (VuzeActivitiesEntry entry : allEntries) {
                String entryID;
                if (entry == null || (entryID = entry.getID()) == null || !entryID.equals(id)) continue;
                VuzeActivitiesEntry vuzeActivitiesEntry = entry;
                return vuzeActivitiesEntry;
            }
        }
        finally {
            allEntries_mon.exit();
        }
        return null;
    }

    public static boolean isEntryIdRemoved(String id) {
        for (VuzeActivitiesEntry entry : removedEntries) {
            if (!entry.getID().equals(id)) continue;
            return true;
        }
        return false;
    }

    public static VuzeActivitiesEntry[] getAllEntries() {
        return allEntries.toArray(new VuzeActivitiesEntry[allEntries.size()]);
    }

    public static int getNumEntries() {
        return allEntries.size();
    }

    public static void log(String s) {
        if (diag_logger != null) {
            diag_logger.log(s);
        }
    }

    public static void triggerEntryChanged(VuzeActivitiesEntry entry) {
        Object[] listenersArray = listeners.toArray();
        int i = 0;
        while (i < listenersArray.length) {
            VuzeActivitiesListener l = (VuzeActivitiesListener)listenersArray[i];
            l.vuzeNewsEntryChanged(entry);
            ++i;
        }
        VuzeActivitiesManager.saveEvents();
    }

    public static VuzeActivitiesEntry createEntryFromMap(Map<?, ?> map, boolean internalMap) {
        VuzeActivitiesEntry entry = new VuzeActivitiesEntry();
        if (internalMap) {
            entry.loadFromInternalMap(map);
        } else {
            entry.loadFromExternalMap(map);
        }
        return entry;
    }
}

