/*
 * WiFiAnalyzer
 * Copyright (C) 2015 - 2026 VREM Software Development <VREMSoftwareDevelopment@gmail.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>
 */
package com.vrem.wifianalyzer

import androidx.test.espresso.Espresso.pressBack
import androidx.test.ext.junit.rules.ActivityScenarioRule
import androidx.test.ext.junit.rules.activityScenarioRule
import androidx.test.ext.junit.runners.AndroidJUnit4
import androidx.test.filters.LargeTest
import androidx.test.rule.GrantPermissionRule
import org.junit.After
import org.junit.Before
import org.junit.Rule
import org.junit.Test
import org.junit.runner.RunWith

@LargeTest
@RunWith(AndroidJUnit4::class)
class MainInstrumentedTest {
    @get:Rule
    val activityTestRule: ActivityScenarioRule<MainActivity> = activityScenarioRule()

    @get:Rule
    val grantPermissionRule: GrantPermissionRule =
        GrantPermissionRule.grant(
            android.Manifest.permission.ACCESS_COARSE_LOCATION,
            android.Manifest.permission.ACCESS_FINE_LOCATION,
            android.Manifest.permission.ACCESS_WIFI_STATE,
            android.Manifest.permission.CHANGE_WIFI_STATE,
        )

    @Before
    fun setUp() {
        returnToHome()
        resetFilters()
        resetScannerState()
        resetSettings()
        returnToHome()
    }

    @After
    fun tearDown() {
        try {
            pressBack()
        } catch (_: Exception) {
        }
    }

    @Test
    fun navigation() {
        NavigationInstrumentedTest().run()
    }

    @Test
    fun scanner() {
        ScannerInstrumentedTest().run()
    }

    @Test
    fun filter() {
        FilterInstrumentedTest().run()
    }

    @Test
    fun accessPoints() {
        AccessPointsInstrumentedTest().run()
    }

    @Test
    fun channelRating() {
        ChannelRatingInstrumentedTest().run()
    }

    @Test
    fun channelGraph() {
        ChannelGraphInstrumentedTest().run()
    }

    @Test
    fun timeGraph() {
        TimeGraphInstrumentedTest().run()
    }

    @Test
    fun connection() {
        ConnectionInstrumentedTest().run()
    }

    @Test
    fun vendor() {
        VendorInstrumentedTest().run()
    }

    @Test
    fun channelAvailable() {
        ChannelAvailableInstrumentedTest().run()
    }

    @Test
    fun settings() {
        SettingsInstrumentedTest().run()
    }
}
