/*
 * WiFiAnalyzer
 * Copyright (C) 2015 - 2026 VREM Software Development <VREMSoftwareDevelopment@gmail.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>
 */
package com.vrem.wifianalyzer

import androidx.test.espresso.Espresso.onView
import androidx.test.espresso.action.ViewActions.click
import androidx.test.espresso.action.ViewActions.closeSoftKeyboard
import androidx.test.espresso.action.ViewActions.scrollTo
import androidx.test.espresso.action.ViewActions.typeText
import androidx.test.espresso.assertion.ViewAssertions.doesNotExist
import androidx.test.espresso.assertion.ViewAssertions.matches
import androidx.test.espresso.matcher.ViewMatchers.isDisplayed
import androidx.test.espresso.matcher.ViewMatchers.withHint
import androidx.test.espresso.matcher.ViewMatchers.withId
import androidx.test.espresso.matcher.ViewMatchers.withText
import org.hamcrest.Matchers.allOf

internal class FilterInstrumentedTest : Runnable {
    override fun run() {
        verifyDialogAndReset()
        verifyWifiBandFilter()
        verifySsidFilter()
    }

    private fun verifyDialogAndReset() {
        onView(allOf(withId(R.id.action_filter), isDisplayed())).perform(click())
        onView(withText("Filter")).check(matches(isDisplayed()))
        onView(withText("Wi-Fi Band")).check(matches(isDisplayed()))
        onView(withText("Security")).check(matches(isDisplayed()))
        onView(allOf(withId(android.R.id.button2), isDisplayed())).perform(scrollTo(), click())
        onView(withText("Filter")).check(doesNotExist())
    }

    private fun verifyWifiBandFilter() {
        onView(allOf(withId(R.id.action_filter), isDisplayed())).perform(click())
        onView(withText("Filter")).check(matches(isDisplayed()))
        onView(withText("5 GHz")).perform(click())
        onView(allOf(withId(android.R.id.button3), isDisplayed())).perform(click())
        onView(withText("Filter")).check(doesNotExist())
    }

    private fun verifySsidFilter() {
        onView(allOf(withId(R.id.action_filter), isDisplayed())).perform(click())
        onView(withHint("ssid SSID")).perform(typeText("test"), closeSoftKeyboard())
        onView(allOf(withId(android.R.id.button3), isDisplayed())).perform(click())
        onView(withText("Filter")).check(doesNotExist())
        onView(allOf(withId(R.id.action_filter), isDisplayed())).perform(click())
        onView(allOf(withId(android.R.id.button2), isDisplayed())).perform(scrollTo(), click())
    }
}
