Thanks for sending a pull request!

See CONTRIBUTING.md for details: https://github.com/VREMSoftwareDevelopment/WiFiAnalyzer/blob/main/CONTRIBUTING.md

## Summary
- One-line summary of the change.
- Brief explanation of why this change is needed.

## What does this implement/fix?
- Describe the scope of the change (key files, classes, public API).
- Mention if the change is small and focused or broad.

## Does this close any issues?
- Closes #<issue-number> (if applicable)
- Related to #<issue-number> (if applicable)

## How was this tested?
- Devices / OS (e.g. Android 13 emulator, Pixel 6):
- Platform / Build variant (e.g. debug/release):
- Toolchain / Gradle / SDK version(s):
- Steps to reproduce / test (provide exact steps so reviewers can verify):

Example test commands:
```bash
./gradlew ktlintCheck
./gradlew lintDebug
./gradlew testDebugUnitTest
```

## Checklist (required before marking ready)
- [ ] I added or updated unit tests (see `app/src/test/`)
- [ ] I followed the project's coding style (ktlint) and formatting
- [ ] I ran lint and addressed or documented any warnings
- [ ] CI checks pass (unit tests, coverage, lint)
- [ ] No sensitive data, keys, or secrets are included

## Additional context
- Screenshots, logs, or other context that helps reviewers understand the change.
- Migration notes or compatibility considerations (if applicable).

## Reviewer notes
- Call out anything reviewers should pay special attention to (performance, API changes, backwards compatibility, security).
- Suggested reviewers or teams (optional): @maintainers

Thank you for contributing!

