var capacitorSoundEffect = (function (exports, core) {
    'use strict';

    const SoundEffect = core.registerPlugin('SoundEffect', {
        web: () => Promise.resolve().then(function () { return web; }).then(m => new m.SoundEffectWeb()),
    });

    class SoundEffectWeb extends core.WebPlugin {
        constructor() {
            super();
            this.audioMap = {};
        }
        async loadSound({ id, path }) {
            const audio = new Audio();
            audio.setAttribute('src', path);
            audio.load();
            this.audioMap[id] = audio;
        }
        async play({ id }) {
            const audio = this.audioMap[id];
            if (audio)
                audio.play();
        }
    }

    var web = /*#__PURE__*/Object.freeze({
        __proto__: null,
        SoundEffectWeb: SoundEffectWeb
    });

    exports.SoundEffect = SoundEffect;

    return exports;

})({}, capacitorExports);
//# sourceMappingURL=plugin.js.map
