import throttle from 'lodash-es/throttle'

class Scroller {
  enabled = false
  element?: HTMLElement
  marker?: HTMLElement

  init = (e: HTMLElement) => {
    this.enabled = true
    this.element = e
    this.element.addEventListener('scroll', throttle(() => {
      const el = this.element
      this.enable(!!el && el.offsetHeight + el.scrollTop > el.scrollHeight - 20)
    }, 500), { passive: true })
  }

  auto = () => {
    if (this.element && this.enabled)
      requestAnimationFrame(() => this.element && (this.element.scrollTop = 9999999))
  }

  enable = (v: boolean) => { this.enabled = v }

  setMarker = () => {
    this.marker = this.element && this.element.querySelector('mine,their') as HTMLElement
  }

  toMarker = (): boolean => {
    if (this.marker && this.to(this.marker)) {
      this.marker = undefined
      return true
    }
    return false
  }

  to = (target: HTMLElement) => {
    if (this.element) {
      const top = target.offsetTop - this.element.offsetHeight / 2 + target.offsetHeight / 2
      if (top > 0) this.element.scrollTop = top
      return top > 0
    }
    return false
  }
}

export const scroller = new Scroller
