// Autogenerated from Pigeon (v22.6.1), do not edit directly.
// See also: https://pub.dev/packages/pigeon

#ifndef PIGEON_UNIVERSAL_BLE_G_H_
#define PIGEON_UNIVERSAL_BLE_G_H_
#include <flutter/basic_message_channel.h>
#include <flutter/binary_messenger.h>
#include <flutter/encodable_value.h>
#include <flutter/standard_message_codec.h>

#include <map>
#include <optional>
#include <string>

namespace universal_ble {


// Generated class from Pigeon.

class FlutterError {
 public:
  explicit FlutterError(const std::string& code)
    : code_(code) {}
  explicit FlutterError(const std::string& code, const std::string& message)
    : code_(code), message_(message) {}
  explicit FlutterError(const std::string& code, const std::string& message, const flutter::EncodableValue& details)
    : code_(code), message_(message), details_(details) {}

  const std::string& code() const { return code_; }
  const std::string& message() const { return message_; }
  const flutter::EncodableValue& details() const { return details_; }

 private:
  std::string code_;
  std::string message_;
  flutter::EncodableValue details_;
};

template<class T> class ErrorOr {
 public:
  ErrorOr(const T& rhs) : v_(rhs) {}
  ErrorOr(const T&& rhs) : v_(std::move(rhs)) {}
  ErrorOr(const FlutterError& rhs) : v_(rhs) {}
  ErrorOr(const FlutterError&& rhs) : v_(std::move(rhs)) {}

  bool has_error() const { return std::holds_alternative<FlutterError>(v_); }
  const T& value() const { return std::get<T>(v_); };
  const FlutterError& error() const { return std::get<FlutterError>(v_); };

 private:
  friend class UniversalBlePlatformChannel;
  friend class UniversalBleCallbackChannel;
  ErrorOr() = default;
  T TakeValue() && { return std::get<T>(std::move(v_)); }

  std::variant<T, FlutterError> v_;
};



// Generated class from Pigeon that represents data sent in messages.
class UniversalBleScanResult {
 public:
  // Constructs an object setting all non-nullable fields.
  explicit UniversalBleScanResult(const std::string& device_id);

  // Constructs an object setting all fields.
  explicit UniversalBleScanResult(
    const std::string& device_id,
    const std::string* name,
    const bool* is_paired,
    const int64_t* rssi,
    const flutter::EncodableList* manufacturer_data_list,
    const flutter::EncodableList* services);

  const std::string& device_id() const;
  void set_device_id(std::string_view value_arg);

  const std::string* name() const;
  void set_name(const std::string_view* value_arg);
  void set_name(std::string_view value_arg);

  const bool* is_paired() const;
  void set_is_paired(const bool* value_arg);
  void set_is_paired(bool value_arg);

  const int64_t* rssi() const;
  void set_rssi(const int64_t* value_arg);
  void set_rssi(int64_t value_arg);

  const flutter::EncodableList* manufacturer_data_list() const;
  void set_manufacturer_data_list(const flutter::EncodableList* value_arg);
  void set_manufacturer_data_list(const flutter::EncodableList& value_arg);

  const flutter::EncodableList* services() const;
  void set_services(const flutter::EncodableList* value_arg);
  void set_services(const flutter::EncodableList& value_arg);


 private:
  static UniversalBleScanResult FromEncodableList(const flutter::EncodableList& list);
  flutter::EncodableList ToEncodableList() const;
  friend class UniversalBlePlatformChannel;
  friend class UniversalBleCallbackChannel;
  friend class PigeonInternalCodecSerializer;
  std::string device_id_;
  std::optional<std::string> name_;
  std::optional<bool> is_paired_;
  std::optional<int64_t> rssi_;
  std::optional<flutter::EncodableList> manufacturer_data_list_;
  std::optional<flutter::EncodableList> services_;

};


// Generated class from Pigeon that represents data sent in messages.
class UniversalBleService {
 public:
  // Constructs an object setting all non-nullable fields.
  explicit UniversalBleService(const std::string& uuid);

  // Constructs an object setting all fields.
  explicit UniversalBleService(
    const std::string& uuid,
    const flutter::EncodableList* characteristics);

  const std::string& uuid() const;
  void set_uuid(std::string_view value_arg);

  const flutter::EncodableList* characteristics() const;
  void set_characteristics(const flutter::EncodableList* value_arg);
  void set_characteristics(const flutter::EncodableList& value_arg);


 private:
  static UniversalBleService FromEncodableList(const flutter::EncodableList& list);
  flutter::EncodableList ToEncodableList() const;
  friend class UniversalBlePlatformChannel;
  friend class UniversalBleCallbackChannel;
  friend class PigeonInternalCodecSerializer;
  std::string uuid_;
  std::optional<flutter::EncodableList> characteristics_;

};


// Generated class from Pigeon that represents data sent in messages.
class UniversalBleCharacteristic {
 public:
  // Constructs an object setting all fields.
  explicit UniversalBleCharacteristic(
    const std::string& uuid,
    const flutter::EncodableList& properties);

  const std::string& uuid() const;
  void set_uuid(std::string_view value_arg);

  const flutter::EncodableList& properties() const;
  void set_properties(const flutter::EncodableList& value_arg);


 private:
  static UniversalBleCharacteristic FromEncodableList(const flutter::EncodableList& list);
  flutter::EncodableList ToEncodableList() const;
  friend class UniversalBlePlatformChannel;
  friend class UniversalBleCallbackChannel;
  friend class PigeonInternalCodecSerializer;
  std::string uuid_;
  flutter::EncodableList properties_;

};


// Scan Filters
//
// Generated class from Pigeon that represents data sent in messages.
class UniversalScanFilter {
 public:
  // Constructs an object setting all fields.
  explicit UniversalScanFilter(
    const flutter::EncodableList& with_services,
    const flutter::EncodableList& with_name_prefix,
    const flutter::EncodableList& with_manufacturer_data);

  const flutter::EncodableList& with_services() const;
  void set_with_services(const flutter::EncodableList& value_arg);

  const flutter::EncodableList& with_name_prefix() const;
  void set_with_name_prefix(const flutter::EncodableList& value_arg);

  const flutter::EncodableList& with_manufacturer_data() const;
  void set_with_manufacturer_data(const flutter::EncodableList& value_arg);


 private:
  static UniversalScanFilter FromEncodableList(const flutter::EncodableList& list);
  flutter::EncodableList ToEncodableList() const;
  friend class UniversalBlePlatformChannel;
  friend class UniversalBleCallbackChannel;
  friend class PigeonInternalCodecSerializer;
  flutter::EncodableList with_services_;
  flutter::EncodableList with_name_prefix_;
  flutter::EncodableList with_manufacturer_data_;

};


// Generated class from Pigeon that represents data sent in messages.
class UniversalManufacturerDataFilter {
 public:
  // Constructs an object setting all non-nullable fields.
  explicit UniversalManufacturerDataFilter(int64_t company_identifier);

  // Constructs an object setting all fields.
  explicit UniversalManufacturerDataFilter(
    int64_t company_identifier,
    const std::vector<uint8_t>* data,
    const std::vector<uint8_t>* mask);

  int64_t company_identifier() const;
  void set_company_identifier(int64_t value_arg);

  const std::vector<uint8_t>* data() const;
  void set_data(const std::vector<uint8_t>* value_arg);
  void set_data(const std::vector<uint8_t>& value_arg);

  const std::vector<uint8_t>* mask() const;
  void set_mask(const std::vector<uint8_t>* value_arg);
  void set_mask(const std::vector<uint8_t>& value_arg);


 private:
  static UniversalManufacturerDataFilter FromEncodableList(const flutter::EncodableList& list);
  flutter::EncodableList ToEncodableList() const;
  friend class UniversalBlePlatformChannel;
  friend class UniversalBleCallbackChannel;
  friend class PigeonInternalCodecSerializer;
  int64_t company_identifier_;
  std::optional<std::vector<uint8_t>> data_;
  std::optional<std::vector<uint8_t>> mask_;

};


// Generated class from Pigeon that represents data sent in messages.
class UniversalManufacturerData {
 public:
  // Constructs an object setting all fields.
  explicit UniversalManufacturerData(
    int64_t company_identifier,
    const std::vector<uint8_t>& data);

  int64_t company_identifier() const;
  void set_company_identifier(int64_t value_arg);

  const std::vector<uint8_t>& data() const;
  void set_data(const std::vector<uint8_t>& value_arg);


 private:
  static UniversalManufacturerData FromEncodableList(const flutter::EncodableList& list);
  flutter::EncodableList ToEncodableList() const;
  friend class UniversalBlePlatformChannel;
  friend class UniversalBleCallbackChannel;
  friend class PigeonInternalCodecSerializer;
  int64_t company_identifier_;
  std::vector<uint8_t> data_;

};


class PigeonInternalCodecSerializer : public flutter::StandardCodecSerializer {
 public:
  PigeonInternalCodecSerializer();
  inline static PigeonInternalCodecSerializer& GetInstance() {
    static PigeonInternalCodecSerializer sInstance;
    return sInstance;
  }

  void WriteValue(
    const flutter::EncodableValue& value,
    flutter::ByteStreamWriter* stream) const override;

 protected:
  flutter::EncodableValue ReadValueOfType(
    uint8_t type,
    flutter::ByteStreamReader* stream) const override;

};

// Flutter -> Native
//
// Generated interface from Pigeon that represents a handler of messages from Flutter.
class UniversalBlePlatformChannel {
 public:
  UniversalBlePlatformChannel(const UniversalBlePlatformChannel&) = delete;
  UniversalBlePlatformChannel& operator=(const UniversalBlePlatformChannel&) = delete;
  virtual ~UniversalBlePlatformChannel() {}
  virtual void GetBluetoothAvailabilityState(std::function<void(ErrorOr<int64_t> reply)> result) = 0;
  virtual void EnableBluetooth(std::function<void(ErrorOr<bool> reply)> result) = 0;
  virtual void DisableBluetooth(std::function<void(ErrorOr<bool> reply)> result) = 0;
  virtual std::optional<FlutterError> StartScan(const UniversalScanFilter* filter) = 0;
  virtual std::optional<FlutterError> StopScan() = 0;
  virtual std::optional<FlutterError> Connect(const std::string& device_id) = 0;
  virtual std::optional<FlutterError> Disconnect(const std::string& device_id) = 0;
  virtual void SetNotifiable(
    const std::string& device_id,
    const std::string& service,
    const std::string& characteristic,
    int64_t ble_input_property,
    std::function<void(std::optional<FlutterError> reply)> result) = 0;
  virtual void DiscoverServices(
    const std::string& device_id,
    std::function<void(ErrorOr<flutter::EncodableList> reply)> result) = 0;
  virtual void ReadValue(
    const std::string& device_id,
    const std::string& service,
    const std::string& characteristic,
    std::function<void(ErrorOr<std::vector<uint8_t>> reply)> result) = 0;
  virtual void RequestMtu(
    const std::string& device_id,
    int64_t expected_mtu,
    std::function<void(ErrorOr<int64_t> reply)> result) = 0;
  virtual void WriteValue(
    const std::string& device_id,
    const std::string& service,
    const std::string& characteristic,
    const std::vector<uint8_t>& value,
    int64_t ble_output_property,
    std::function<void(std::optional<FlutterError> reply)> result) = 0;
  virtual void IsPaired(
    const std::string& device_id,
    std::function<void(ErrorOr<bool> reply)> result) = 0;
  virtual void Pair(
    const std::string& device_id,
    std::function<void(ErrorOr<bool> reply)> result) = 0;
  virtual std::optional<FlutterError> UnPair(const std::string& device_id) = 0;
  virtual void GetSystemDevices(
    const flutter::EncodableList& with_services,
    std::function<void(ErrorOr<flutter::EncodableList> reply)> result) = 0;
  virtual ErrorOr<int64_t> GetConnectionState(const std::string& device_id) = 0;

  // The codec used by UniversalBlePlatformChannel.
  static const flutter::StandardMessageCodec& GetCodec();
  // Sets up an instance of `UniversalBlePlatformChannel` to handle messages through the `binary_messenger`.
  static void SetUp(
    flutter::BinaryMessenger* binary_messenger,
    UniversalBlePlatformChannel* api);
  static void SetUp(
    flutter::BinaryMessenger* binary_messenger,
    UniversalBlePlatformChannel* api,
    const std::string& message_channel_suffix);
  static flutter::EncodableValue WrapError(std::string_view error_message);
  static flutter::EncodableValue WrapError(const FlutterError& error);

 protected:
  UniversalBlePlatformChannel() = default;

};
// Native -> Flutter
//
// Generated class from Pigeon that represents Flutter messages that can be called from C++.
class UniversalBleCallbackChannel {
 public:
  UniversalBleCallbackChannel(flutter::BinaryMessenger* binary_messenger);
  UniversalBleCallbackChannel(
    flutter::BinaryMessenger* binary_messenger,
    const std::string& message_channel_suffix);
  static const flutter::StandardMessageCodec& GetCodec();
  void OnAvailabilityChanged(
    int64_t state,
    std::function<void(void)>&& on_success,
    std::function<void(const FlutterError&)>&& on_error);
  void OnPairStateChange(
    const std::string& device_id,
    bool is_paired,
    const std::string* error,
    std::function<void(void)>&& on_success,
    std::function<void(const FlutterError&)>&& on_error);
  void OnScanResult(
    const UniversalBleScanResult& result,
    std::function<void(void)>&& on_success,
    std::function<void(const FlutterError&)>&& on_error);
  void OnValueChanged(
    const std::string& device_id,
    const std::string& characteristic_id,
    const std::vector<uint8_t>& value,
    std::function<void(void)>&& on_success,
    std::function<void(const FlutterError&)>&& on_error);
  void OnConnectionChanged(
    const std::string& device_id,
    bool connected,
    const std::string* error,
    std::function<void(void)>&& on_success,
    std::function<void(const FlutterError&)>&& on_error);

 private:
  flutter::BinaryMessenger* binary_messenger_;
  std::string message_channel_suffix_;
};

}  // namespace universal_ble
#endif  // PIGEON_UNIVERSAL_BLE_G_H_
