// This file has been automatically generated by the script
// builder/builder.dart manufacturer-ids.
// The data is retrieved from the official repository.

// ignore: use_string_in_part_of_directives
part of flutter_web_bluetooth;

/// All the default Bluetooth low energy services are defined in this enum.
/// See: [values] for a list of all the services.
/// See: [services] for a list of all the non-deprecated services.
/// ignore: deprecated_member_use_from_same_package
/// See: [deprecatedServices] for a list of all old deprecated services.
enum BluetoothDefaultServiceUUIDS {
  /// The default service for GAP
  gap("GAP", "1800", "00001800-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.service.gap"),

  /// The default service for GATT
  gatt("GATT", "1801", "00001801-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.service.gatt"),

  /// The default service for Immediate Alert
  immediateAlert(
      "Immediate Alert",
      "1802",
      "00001802-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.service.immediate_alert"),

  /// The default service for Link Loss
  linkLoss("Link Loss", "1803", "00001803-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.service.link_loss"),

  /// The default service for Tx Power
  txPower("Tx Power", "1804", "00001804-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.service.tx_power"),

  /// The default service for Current Time
  currentTime("Current Time", "1805", "00001805-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.service.current_time"),

  /// The default service for Reference Time Update
  referenceTimeUpdate(
      "Reference Time Update",
      "1806",
      "00001806-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.service.reference_time_update"),

  /// The default service for Next DST Change
  nextDstChange(
      "Next DST Change",
      "1807",
      "00001807-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.service.next_dst_change"),

  /// The default service for Glucose
  glucose("Glucose", "1808", "00001808-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.service.glucose"),

  /// The default service for Health Thermometer
  healthThermometer(
      "Health Thermometer",
      "1809",
      "00001809-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.service.health_thermometer"),

  /// The default service for Device Information
  deviceInformation(
      "Device Information",
      "180a",
      "0000180a-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.service.device_information"),

  /// The default service for Heart Rate
  heartRate("Heart Rate", "180d", "0000180d-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.service.heart_rate"),

  /// The default service for Phone Alert Status
  phoneAlertStatus(
      "Phone Alert Status",
      "180e",
      "0000180e-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.service.phone_alert_status"),

  /// The default service for Battery
  battery("Battery", "180f", "0000180f-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.service.battery_service"),

  /// The default service for Blood Pressure
  bloodPressure(
      "Blood Pressure",
      "1810",
      "00001810-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.service.blood_pressure"),

  /// The default service for Alert Notification
  alertNotification(
      "Alert Notification",
      "1811",
      "00001811-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.service.alert_notification"),

  /// The default service for Human Interface Device
  humanInterfaceDevice(
      "Human Interface Device",
      "1812",
      "00001812-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.service.human_interface_device"),

  /// The default service for Scan Parameters
  scanParameters(
      "Scan Parameters",
      "1813",
      "00001813-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.service.scan_parameters"),

  /// The default service for Running Speed and Cadence
  runningSpeedAndCadence(
      "Running Speed and Cadence",
      "1814",
      "00001814-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.service.running_speed_and_cadence"),

  /// The default service for Automation IO
  automationIo("Automation IO", "1815", "00001815-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.service.automation_io"),

  /// The default service for Cycling Speed and Cadence
  cyclingSpeedAndCadence(
      "Cycling Speed and Cadence",
      "1816",
      "00001816-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.service.cycling_speed_and_cadence"),

  /// The default service for Cycling Power
  cyclingPower("Cycling Power", "1818", "00001818-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.service.cycling_power"),

  /// The default service for Location and Navigation
  locationAndNavigation(
      "Location and Navigation",
      "1819",
      "00001819-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.service.location_and_navigation"),

  /// The default service for Environmental Sensing
  environmentalSensing(
      "Environmental Sensing",
      "181a",
      "0000181a-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.service.environmental_sensing"),

  /// The default service for Body Composition
  bodyComposition(
      "Body Composition",
      "181b",
      "0000181b-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.service.body_composition"),

  /// The default service for User Data
  userData("User Data", "181c", "0000181c-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.service.user_data"),

  /// The default service for Weight Scale
  weightScale("Weight Scale", "181d", "0000181d-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.service.weight_scale"),

  /// The default service for Bond Management
  bondManagement(
      "Bond Management",
      "181e",
      "0000181e-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.service.bond_management"),

  /// The default service for Continuous Glucose Monitoring
  continuousGlucoseMonitoring(
      "Continuous Glucose Monitoring",
      "181f",
      "0000181f-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.service.continuous_glucose_monitoring"),

  /// The default service for Internet Protocol Support
  internetProtocolSupport(
      "Internet Protocol Support",
      "1820",
      "00001820-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.service.internet_protocol_support"),

  /// The default service for Indoor Positioning
  indoorPositioning(
      "Indoor Positioning",
      "1821",
      "00001821-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.service.indoor_positioning"),

  /// The default service for Pulse Oximeter
  pulseOximeter(
      "Pulse Oximeter",
      "1822",
      "00001822-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.service.pulse_oximeter"),

  /// The default service for HTTP Proxy
  httpProxy("HTTP Proxy", "1823", "00001823-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.service.http_proxy"),

  /// The default service for Transport Discovery
  transportDiscovery(
      "Transport Discovery",
      "1824",
      "00001824-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.service.transport_discovery"),

  /// The default service for Object Transfer
  objectTransfer(
      "Object Transfer",
      "1825",
      "00001825-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.service.object_transfer"),

  /// The default service for Fitness Machine
  fitnessMachine(
      "Fitness Machine",
      "1826",
      "00001826-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.service.fitness_machine"),

  /// The default service for Mesh Provisioning
  meshProvisioning(
      "Mesh Provisioning",
      "1827",
      "00001827-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.service.mesh_provisioning"),

  /// The default service for Mesh Proxy
  meshProxy("Mesh Proxy", "1828", "00001828-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.service.mesh_proxy"),

  /// The default service for Reconnection Configuration
  reconnectionConfiguration(
      "Reconnection Configuration",
      "1829",
      "00001829-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.service.reconnection_configuration"),

  /// The default service for Insulin Delivery
  insulinDelivery(
      "Insulin Delivery",
      "183a",
      "0000183a-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.service.insulin_delivery"),

  /// The default service for Binary Sensor
  binarySensor("Binary Sensor", "183b", "0000183b-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.service.binary_sensor"),

  /// The default service for Emergency Configuration
  emergencyConfiguration(
      "Emergency Configuration",
      "183c",
      "0000183c-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.service.emergency_configuration"),

  /// The default service for Authorization Control
  authorizationControl(
      "Authorization Control",
      "183d",
      "0000183d-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.service.authorization_control"),

  /// The default service for Physical Activity Monitor
  physicalActivityMonitor(
      "Physical Activity Monitor",
      "183e",
      "0000183e-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.service.physical_activity_monitor"),

  /// The default service for Elapsed Time
  elapsedTime("Elapsed Time", "183f", "0000183f-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.service.elapsed_time"),

  /// The default service for Generic Health Sensor
  genericHealthSensor(
      "Generic Health Sensor",
      "1840",
      "00001840-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.service.generic_health_sensor"),

  /// The default service for Audio Input Control
  audioInputControl(
      "Audio Input Control",
      "1843",
      "00001843-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.service.audio_input_control"),

  /// The default service for Volume Control
  volumeControl(
      "Volume Control",
      "1844",
      "00001844-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.service.volume_control"),

  /// The default service for Volume Offset Control
  volumeOffsetControl(
      "Volume Offset Control",
      "1845",
      "00001845-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.service.volume_offset"),

  /// The default service for Coordinated Set Identification
  coordinatedSetIdentification(
      "Coordinated Set Identification",
      "1846",
      "00001846-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.service.coordinated_set_identification"),

  /// The default service for Device Time
  deviceTime("Device Time", "1847", "00001847-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.service.device_time"),

  /// The default service for Media Control
  mediaControl("Media Control", "1848", "00001848-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.service.media_control"),

  /// The default service for Generic Media Control
  genericMediaControl(
      "Generic Media Control",
      "1849",
      "00001849-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.service.generic_media_control"),

  /// The default service for Constant Tone Extension
  constantToneExtension(
      "Constant Tone Extension",
      "184a",
      "0000184a-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.service.constant_tone_extension"),

  /// The default service for Telephone Bearer
  telephoneBearer(
      "Telephone Bearer",
      "184b",
      "0000184b-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.service.telephone_bearer"),

  /// The default service for Generic Telephone Bearer
  genericTelephoneBearer(
      "Generic Telephone Bearer",
      "184c",
      "0000184c-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.service.generic_telephone_bearer"),

  /// The default service for Microphone Control
  microphoneControl(
      "Microphone Control",
      "184d",
      "0000184d-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.service.microphone_control"),

  /// The default service for Audio Stream Control
  audioStreamControl(
      "Audio Stream Control",
      "184e",
      "0000184e-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.service.audio_stream_control"),

  /// The default service for Broadcast Audio Scan
  broadcastAudioScan(
      "Broadcast Audio Scan",
      "184f",
      "0000184f-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.service.broadcast_audio_scan"),

  /// The default service for Published Audio Capabilities
  publishedAudioCapabilities(
      "Published Audio Capabilities",
      "1850",
      "00001850-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.service.published_audio_capabilities"),

  /// The default service for Basic Audio Announcement
  basicAudioAnnouncement(
      "Basic Audio Announcement",
      "1851",
      "00001851-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.service.basic_audio_announcement"),

  /// The default service for Broadcast Audio Announcement
  broadcastAudioAnnouncement(
      "Broadcast Audio Announcement",
      "1852",
      "00001852-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.service.broadcast_audio_announcement"),

  /// The default service for Common Audio
  commonAudio("Common Audio", "1853", "00001853-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.service.common_audio"),

  /// The default service for Hearing Access
  hearingAccess(
      "Hearing Access",
      "1854",
      "00001854-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.service.hearing_access"),

  /// The default service for Telephony and Media Audio
  telephonyAndMediaAudio(
      "Telephony and Media Audio",
      "1855",
      "00001855-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.service.telephony_and_media_audio"),

  /// The default service for Public Broadcast Announcement
  publicBroadcastAnnouncement(
      "Public Broadcast Announcement",
      "1856",
      "00001856-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.service.public_broadcast_announcement"),

  /// The default service for Electronic Shelf Label
  electronicShelfLabel(
      "Electronic Shelf Label",
      "1857",
      "00001857-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.service.electronic_shelf_label"),

  /// The default service for Gaming Audio
  gamingAudio("Gaming Audio", "1858", "00001858-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.service.gaming_audio"),

  /// The default service for Mesh Proxy Solicitation
  meshProxySolicitation(
      "Mesh Proxy Solicitation",
      "1859",
      "00001859-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.service.mesh_proxy_solicitation"),

  /// The default service for Industrial Measurement Device
  industrialMeasurementDevice(
      "Industrial Measurement Device",
      "185a",
      "0000185a-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.service.industrial_measurement_device"),

  /// The default service for Ranging
  ranging("Ranging", "185b", "0000185b-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.service.ranging");

  ///
  /// A service UUID consists of a human readable name of the service,
  /// its uuid represented as a 16 bit uuid and a full 128 bit uuid,
  /// and the id assigned by the Bluetooth SIG
  ///
  const BluetoothDefaultServiceUUIDS(
    this.name,
    this.uuid16,
    this.uuid,
    this.id,
  );

  /// The name of the service.
  final String name;

  /// The shorter 16 bit uuid of the service.
  final String uuid16;

  /// The full uuid of the service.
  final String uuid;

  /// The bluetooth ID of the service
  final String id;

  /// All non-deprecated services.
  static const List<BluetoothDefaultServiceUUIDS> services = [
    gap,
    gatt,
    immediateAlert,
    linkLoss,
    txPower,
    currentTime,
    referenceTimeUpdate,
    nextDstChange,
    glucose,
    healthThermometer,
    deviceInformation,
    heartRate,
    phoneAlertStatus,
    battery,
    bloodPressure,
    alertNotification,
    humanInterfaceDevice,
    scanParameters,
    runningSpeedAndCadence,
    automationIo,
    cyclingSpeedAndCadence,
    cyclingPower,
    locationAndNavigation,
    environmentalSensing,
    bodyComposition,
    userData,
    weightScale,
    bondManagement,
    continuousGlucoseMonitoring,
    internetProtocolSupport,
    indoorPositioning,
    pulseOximeter,
    httpProxy,
    transportDiscovery,
    objectTransfer,
    fitnessMachine,
    meshProvisioning,
    meshProxy,
    reconnectionConfiguration,
    insulinDelivery,
    binarySensor,
    emergencyConfiguration,
    authorizationControl,
    physicalActivityMonitor,
    elapsedTime,
    genericHealthSensor,
    audioInputControl,
    volumeControl,
    volumeOffsetControl,
    coordinatedSetIdentification,
    deviceTime,
    mediaControl,
    genericMediaControl,
    constantToneExtension,
    telephoneBearer,
    genericTelephoneBearer,
    microphoneControl,
    audioStreamControl,
    broadcastAudioScan,
    publishedAudioCapabilities,
    basicAudioAnnouncement,
    broadcastAudioAnnouncement,
    commonAudio,
    hearingAccess,
    telephonyAndMediaAudio,
    publicBroadcastAnnouncement,
    electronicShelfLabel,
    gamingAudio,
    meshProxySolicitation,
    industrialMeasurementDevice,
    ranging
  ];

  /// All deprecated characteristics.
  @Deprecated(
      "This contains all deprecated services and should thus not be relied on")
  static const List<BluetoothDefaultServiceUUIDS> deprecatedServices = [];
}

/// All the default Bluetooth low energy characteristics are defined in this enum.
/// See: [values] for a list of all the characteristics.
/// See: [characteristics] for a list of all the non-deprecated characteristics.
/// ignore: deprecated_member_use_from_same_package
/// See: [deprecatedCharacteristics] for a list of all old deprecated characteristics.
enum BluetoothDefaultCharacteristicUUIDS {
  /// The default characteristic for Device Name
  deviceName("Device Name", "2a00", "00002a00-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.gap.device_name"),

  /// The default characteristic for Appearance
  appearance("Appearance", "2a01", "00002a01-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.gap.appearance"),

  /// The default characteristic for Peripheral Privacy Flag
  peripheralPrivacyFlag(
      "Peripheral Privacy Flag",
      "2a02",
      "00002a02-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.gap.peripheral_privacy_flag"),

  /// The default characteristic for Reconnection Address
  reconnectionAddress(
      "Reconnection Address",
      "2a03",
      "00002a03-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.gap.reconnection_address"),

  /// The default characteristic for Peripheral Preferred Connection Parameters
  peripheralPreferredConnectionParameters(
      "Peripheral Preferred Connection Parameters",
      "2a04",
      "00002a04-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.gap.peripheral_preferred_connection_parameters"),

  /// The default characteristic for Service Changed
  serviceChanged(
      "Service Changed",
      "2a05",
      "00002a05-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.gatt.service_changed"),

  /// The default characteristic for Alert Level
  alertLevel("Alert Level", "2a06", "00002a06-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.alert_level"),

  /// The default characteristic for Tx Power Level
  txPowerLevel("Tx Power Level", "2a07", "00002a07-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.tx_power_level"),

  /// The default characteristic for Date Time
  dateTime("Date Time", "2a08", "00002a08-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.date_time"),

  /// The default characteristic for Day of Week
  dayOfWeek("Day of Week", "2a09", "00002a09-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.day_of_week"),

  /// The default characteristic for Day Date Time
  dayDateTime("Day Date Time", "2a0a", "00002a0a-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.day_date_time"),

  /// The default characteristic for Exact Time 256
  exactTime256("Exact Time 256", "2a0c", "00002a0c-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.exact_time_256"),

  /// The default characteristic for DST Offset
  dstOffset("DST Offset", "2a0d", "00002a0d-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.dst_offset"),

  /// The default characteristic for Time Zone
  timeZone("Time Zone", "2a0e", "00002a0e-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.time_zone"),

  /// The default characteristic for Local Time Information
  localTimeInformation(
      "Local Time Information",
      "2a0f",
      "00002a0f-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.local_time_information"),

  /// The default characteristic for Time with DST
  timeWithDst("Time with DST", "2a11", "00002a11-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.time_with_dst"),

  /// The default characteristic for Time Accuracy
  timeAccuracy("Time Accuracy", "2a12", "00002a12-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.time_accuracy"),

  /// The default characteristic for Time Source
  timeSource("Time Source", "2a13", "00002a13-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.time_source"),

  /// The default characteristic for Reference Time Information
  referenceTimeInformation(
      "Reference Time Information",
      "2a14",
      "00002a14-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.reference_time_information"),

  /// The default characteristic for Time Update Control Point
  timeUpdateControlPoint(
      "Time Update Control Point",
      "2a16",
      "00002a16-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.time_update_control_point"),

  /// The default characteristic for Time Update State
  timeUpdateState(
      "Time Update State",
      "2a17",
      "00002a17-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.time_update_state"),

  /// The default characteristic for Glucose Measurement
  glucoseMeasurement(
      "Glucose Measurement",
      "2a18",
      "00002a18-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.glucose_measurement"),

  /// The default characteristic for Battery Level
  batteryLevel("Battery Level", "2a19", "00002a19-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.battery_level"),

  /// The default characteristic for Temperature Measurement
  temperatureMeasurement(
      "Temperature Measurement",
      "2a1c",
      "00002a1c-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.temperature_measurement"),

  /// The default characteristic for Temperature Type
  temperatureType(
      "Temperature Type",
      "2a1d",
      "00002a1d-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.temperature_type"),

  /// The default characteristic for Intermediate Temperature
  intermediateTemperature(
      "Intermediate Temperature",
      "2a1e",
      "00002a1e-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.intermediate_temperature"),

  /// The default characteristic for Measurement Interval
  measurementInterval(
      "Measurement Interval",
      "2a21",
      "00002a21-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.measurement_interval"),

  /// The default characteristic for Boot Keyboard Input Report
  bootKeyboardInputReport(
      "Boot Keyboard Input Report",
      "2a22",
      "00002a22-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.boot_keyboard_input_report"),

  /// The default characteristic for System ID
  systemId("System ID", "2a23", "00002a23-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.system_id"),

  /// The default characteristic for Model Number String
  modelNumberString(
      "Model Number String",
      "2a24",
      "00002a24-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.model_number_string"),

  /// The default characteristic for Serial Number String
  serialNumberString(
      "Serial Number String",
      "2a25",
      "00002a25-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.serial_number_string"),

  /// The default characteristic for Firmware Revision String
  firmwareRevisionString(
      "Firmware Revision String",
      "2a26",
      "00002a26-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.firmware_revision_string"),

  /// The default characteristic for Hardware Revision String
  hardwareRevisionString(
      "Hardware Revision String",
      "2a27",
      "00002a27-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.hardware_revision_string"),

  /// The default characteristic for Software Revision String
  softwareRevisionString(
      "Software Revision String",
      "2a28",
      "00002a28-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.software_revision_string"),

  /// The default characteristic for Manufacturer Name String
  manufacturerNameString(
      "Manufacturer Name String",
      "2a29",
      "00002a29-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.manufacturer_name_string"),

  /// The default characteristic for IEEE 11073-20601 Regulatory Certification Data List
  ieee1107320601RegulatoryCertificationDataList(
      "IEEE 11073-20601 Regulatory Certification Data List",
      "2a2a",
      "00002a2a-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.ieee_11073-20601_regulatory_certification_data_list"),

  /// The default characteristic for Current Time
  currentTime("Current Time", "2a2b", "00002a2b-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.current_time"),

  /// The default characteristic for Magnetic Declination
  magneticDeclination(
      "Magnetic Declination",
      "2a2c",
      "00002a2c-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.magnetic_declination"),

  /// The default characteristic for Scan Refresh
  scanRefresh("Scan Refresh", "2a31", "00002a31-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.scan_refresh"),

  /// The default characteristic for Boot Keyboard Output Report
  bootKeyboardOutputReport(
      "Boot Keyboard Output Report",
      "2a32",
      "00002a32-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.boot_keyboard_output_report"),

  /// The default characteristic for Boot Mouse Input Report
  bootMouseInputReport(
      "Boot Mouse Input Report",
      "2a33",
      "00002a33-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.boot_mouse_input_report"),

  /// The default characteristic for Glucose Measurement Context
  glucoseMeasurementContext(
      "Glucose Measurement Context",
      "2a34",
      "00002a34-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.glucose_measurement_context"),

  /// The default characteristic for Blood Pressure Measurement
  bloodPressureMeasurement(
      "Blood Pressure Measurement",
      "2a35",
      "00002a35-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.blood_pressure_measurement"),

  /// The default characteristic for Intermediate Cuff Pressure
  intermediateCuffPressure(
      "Intermediate Cuff Pressure",
      "2a36",
      "00002a36-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.intermediate_cuff_pressure"),

  /// The default characteristic for Heart Rate Measurement
  heartRateMeasurement(
      "Heart Rate Measurement",
      "2a37",
      "00002a37-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.heart_rate_measurement"),

  /// The default characteristic for Body Sensor Location
  bodySensorLocation(
      "Body Sensor Location",
      "2a38",
      "00002a38-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.body_sensor_location"),

  /// The default characteristic for Heart Rate Control Point
  heartRateControlPoint(
      "Heart Rate Control Point",
      "2a39",
      "00002a39-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.heart_rate_control_point"),

  /// The default characteristic for Alert Status
  alertStatus("Alert Status", "2a3f", "00002a3f-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.alert_status"),

  /// The default characteristic for Ringer Control Point
  ringerControlPoint(
      "Ringer Control Point",
      "2a40",
      "00002a40-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.ringer_control_point"),

  /// The default characteristic for Ringer Setting
  ringerSetting(
      "Ringer Setting",
      "2a41",
      "00002a41-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.ringer_setting"),

  /// The default characteristic for Alert Category ID Bit Mask
  alertCategoryIdBitMask(
      "Alert Category ID Bit Mask",
      "2a42",
      "00002a42-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.alert_category_id_bit_mask"),

  /// The default characteristic for Alert Category ID
  alertCategoryId(
      "Alert Category ID",
      "2a43",
      "00002a43-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.alert_category_id"),

  /// The default characteristic for Alert Notification Control Point
  alertNotificationControlPoint(
      "Alert Notification Control Point",
      "2a44",
      "00002a44-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.alert_notification_control_point"),

  /// The default characteristic for Unread Alert Status
  unreadAlertStatus(
      "Unread Alert Status",
      "2a45",
      "00002a45-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.unread_alert_status"),

  /// The default characteristic for New Alert
  newAlert("New Alert", "2a46", "00002a46-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.new_alert"),

  /// The default characteristic for Supported New Alert Category
  supportedNewAlertCategory(
      "Supported New Alert Category",
      "2a47",
      "00002a47-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.supported_new_alert_category"),

  /// The default characteristic for Supported Unread Alert Category
  supportedUnreadAlertCategory(
      "Supported Unread Alert Category",
      "2a48",
      "00002a48-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.supported_unread_alert_category"),

  /// The default characteristic for Blood Pressure Feature
  bloodPressureFeature(
      "Blood Pressure Feature",
      "2a49",
      "00002a49-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.blood_pressure_feature"),

  /// The default characteristic for HID Information
  hidInformation(
      "HID Information",
      "2a4a",
      "00002a4a-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.hid_information"),

  /// The default characteristic for Report Map
  reportMap("Report Map", "2a4b", "00002a4b-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.report_map"),

  /// The default characteristic for HID Control Point
  hidControlPoint(
      "HID Control Point",
      "2a4c",
      "00002a4c-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.hid_control_point"),

  /// The default characteristic for Report
  report("Report", "2a4d", "00002a4d-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.report"),

  /// The default characteristic for Protocol Mode
  protocolMode("Protocol Mode", "2a4e", "00002a4e-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.protocol_mode"),

  /// The default characteristic for Scan Interval Window
  scanIntervalWindow(
      "Scan Interval Window",
      "2a4f",
      "00002a4f-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.scan_interval_window"),

  /// The default characteristic for PnP ID
  pnpId("PnP ID", "2a50", "00002a50-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.pnp_id"),

  /// The default characteristic for Glucose Feature
  glucoseFeature(
      "Glucose Feature",
      "2a51",
      "00002a51-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.glucose_feature"),

  /// The default characteristic for Record Access Control Point
  recordAccessControlPoint(
      "Record Access Control Point",
      "2a52",
      "00002a52-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.record_access_control_point"),

  /// The default characteristic for RSC Measurement
  rscMeasurement(
      "RSC Measurement",
      "2a53",
      "00002a53-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.rsc_measurement"),

  /// The default characteristic for RSC Feature
  rscFeature("RSC Feature", "2a54", "00002a54-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.rsc_feature"),

  /// The default characteristic for SC Control Point
  scControlPoint(
      "SC Control Point",
      "2a55",
      "00002a55-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.sc_control_point"),

  /// The default characteristic for Aggregate
  aggregate("Aggregate", "2a5a", "00002a5a-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.aggregate"),

  /// The default characteristic for CSC Measurement
  cscMeasurement(
      "CSC Measurement",
      "2a5b",
      "00002a5b-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.csc_measurement"),

  /// The default characteristic for CSC Feature
  cscFeature("CSC Feature", "2a5c", "00002a5c-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.csc_feature"),

  /// The default characteristic for Sensor Location
  sensorLocation(
      "Sensor Location",
      "2a5d",
      "00002a5d-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.sensor_location"),

  /// The default characteristic for PLX Spot-Check Measurement
  plxSpotCheckMeasurement(
      "PLX Spot-Check Measurement",
      "2a5e",
      "00002a5e-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.plx_spot_check_measurement"),

  /// The default characteristic for PLX Continuous Measurement
  plxContinuousMeasurement(
      "PLX Continuous Measurement",
      "2a5f",
      "00002a5f-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.plx_continuous_measurement"),

  /// The default characteristic for PLX Features
  plxFeatures("PLX Features", "2a60", "00002a60-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.plx_features"),

  /// The default characteristic for Cycling Power Measurement
  cyclingPowerMeasurement(
      "Cycling Power Measurement",
      "2a63",
      "00002a63-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.cycling_power_measurement"),

  /// The default characteristic for Cycling Power Vector
  cyclingPowerVector(
      "Cycling Power Vector",
      "2a64",
      "00002a64-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.cycling_power_vector"),

  /// The default characteristic for Cycling Power Feature
  cyclingPowerFeature(
      "Cycling Power Feature",
      "2a65",
      "00002a65-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.cycling_power_feature"),

  /// The default characteristic for Cycling Power Control Point
  cyclingPowerControlPoint(
      "Cycling Power Control Point",
      "2a66",
      "00002a66-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.cycling_power_control_point"),

  /// The default characteristic for Location and Speed
  locationAndSpeed(
      "Location and Speed",
      "2a67",
      "00002a67-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.location_and_speed"),

  /// The default characteristic for Navigation
  navigation("Navigation", "2a68", "00002a68-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.navigation"),

  /// The default characteristic for Position Quality
  positionQuality(
      "Position Quality",
      "2a69",
      "00002a69-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.position_quality"),

  /// The default characteristic for LN Feature
  lnFeature("LN Feature", "2a6a", "00002a6a-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.ln_feature"),

  /// The default characteristic for LN Control Point
  lnControlPoint(
      "LN Control Point",
      "2a6b",
      "00002a6b-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.ln_control_point"),

  /// The default characteristic for Elevation
  elevation("Elevation", "2a6c", "00002a6c-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.elevation"),

  /// The default characteristic for Pressure
  pressure("Pressure", "2a6d", "00002a6d-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.pressure"),

  /// The default characteristic for Temperature
  temperature("Temperature", "2a6e", "00002a6e-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.temperature"),

  /// The default characteristic for Humidity
  humidity("Humidity", "2a6f", "00002a6f-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.humidity"),

  /// The default characteristic for True Wind Speed
  trueWindSpeed(
      "True Wind Speed",
      "2a70",
      "00002a70-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.true_wind_speed"),

  /// The default characteristic for True Wind Direction
  trueWindDirection(
      "True Wind Direction",
      "2a71",
      "00002a71-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.true_wind_direction"),

  /// The default characteristic for Apparent Wind Speed
  apparentWindSpeed(
      "Apparent Wind Speed",
      "2a72",
      "00002a72-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.apparent_wind_speed"),

  /// The default characteristic for Apparent Wind Direction
  apparentWindDirection(
      "Apparent Wind Direction",
      "2a73",
      "00002a73-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.apparent_wind_direction"),

  /// The default characteristic for Gust Factor
  gustFactor("Gust Factor", "2a74", "00002a74-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.gust_factor"),

  /// The default characteristic for Pollen Concentration
  pollenConcentration(
      "Pollen Concentration",
      "2a75",
      "00002a75-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.pollen_concentration"),

  /// The default characteristic for UV Index
  uvIndex("UV Index", "2a76", "00002a76-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.uv_index"),

  /// The default characteristic for Irradiance
  irradiance("Irradiance", "2a77", "00002a77-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.irradiance"),

  /// The default characteristic for Rainfall
  rainfall("Rainfall", "2a78", "00002a78-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.rainfall"),

  /// The default characteristic for Wind Chill
  windChill("Wind Chill", "2a79", "00002a79-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.wind_chill"),

  /// The default characteristic for Heat Index
  heatIndex("Heat Index", "2a7a", "00002a7a-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.heat_index"),

  /// The default characteristic for Dew Point
  dewPoint("Dew Point", "2a7b", "00002a7b-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.dew_point"),

  /// The default characteristic for Descriptor Value Changed
  descriptorValueChanged(
      "Descriptor Value Changed",
      "2a7d",
      "00002a7d-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.descriptor_value_changed"),

  /// The default characteristic for Aerobic Heart Rate Lower Limit
  aerobicHeartRateLowerLimit(
      "Aerobic Heart Rate Lower Limit",
      "2a7e",
      "00002a7e-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.aerobic_heart_rate_lower_limit"),

  /// The default characteristic for Aerobic Threshold
  aerobicThreshold(
      "Aerobic Threshold",
      "2a7f",
      "00002a7f-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.aerobic_threshold"),

  /// The default characteristic for Age
  age("Age", "2a80", "00002a80-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.age"),

  /// The default characteristic for Anaerobic Heart Rate Lower Limit
  anaerobicHeartRateLowerLimit(
      "Anaerobic Heart Rate Lower Limit",
      "2a81",
      "00002a81-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.anaerobic_heart_rate_lower_limit"),

  /// The default characteristic for Anaerobic Heart Rate Upper Limit
  anaerobicHeartRateUpperLimit(
      "Anaerobic Heart Rate Upper Limit",
      "2a82",
      "00002a82-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.anaerobic_heart_rate_upper_limit"),

  /// The default characteristic for Anaerobic Threshold
  anaerobicThreshold(
      "Anaerobic Threshold",
      "2a83",
      "00002a83-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.anaerobic_threshold"),

  /// The default characteristic for Aerobic Heart Rate Upper Limit
  aerobicHeartRateUpperLimit(
      "Aerobic Heart Rate Upper Limit",
      "2a84",
      "00002a84-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.aerobic_heart_rate_upper_limit"),

  /// The default characteristic for Date of Birth
  dateOfBirth("Date of Birth", "2a85", "00002a85-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.date_of_birth"),

  /// The default characteristic for Date of Threshold Assessment
  dateOfThresholdAssessment(
      "Date of Threshold Assessment",
      "2a86",
      "00002a86-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.date_of_threshold_assessment"),

  /// The default characteristic for Email Address
  emailAddress("Email Address", "2a87", "00002a87-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.email_address"),

  /// The default characteristic for Fat Burn Heart Rate Lower Limit
  fatBurnHeartRateLowerLimit(
      "Fat Burn Heart Rate Lower Limit",
      "2a88",
      "00002a88-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.fat_burn_heart_rate_lower_limit"),

  /// The default characteristic for Fat Burn Heart Rate Upper Limit
  fatBurnHeartRateUpperLimit(
      "Fat Burn Heart Rate Upper Limit",
      "2a89",
      "00002a89-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.fat_burn_heart_rate_upper_limit"),

  /// The default characteristic for First Name
  firstName("First Name", "2a8a", "00002a8a-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.first_name"),

  /// The default characteristic for Five Zone Heart Rate Limits
  fiveZoneHeartRateLimits(
      "Five Zone Heart Rate Limits",
      "2a8b",
      "00002a8b-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.five_zone_heart_rate_limits"),

  /// The default characteristic for Gender
  gender("Gender", "2a8c", "00002a8c-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.gender"),

  /// The default characteristic for Heart Rate Max
  heartRateMax("Heart Rate Max", "2a8d", "00002a8d-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.heart_rate_max"),

  /// The default characteristic for Height
  height("Height", "2a8e", "00002a8e-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.height"),

  /// The default characteristic for Hip Circumference
  hipCircumference(
      "Hip Circumference",
      "2a8f",
      "00002a8f-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.hip_circumference"),

  /// The default characteristic for Last Name
  lastName("Last Name", "2a90", "00002a90-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.last_name"),

  /// The default characteristic for Maximum Recommended Heart Rate
  maximumRecommendedHeartRate(
      "Maximum Recommended Heart Rate",
      "2a91",
      "00002a91-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.maximum_recommended_heart_rate"),

  /// The default characteristic for Resting Heart Rate
  restingHeartRate(
      "Resting Heart Rate",
      "2a92",
      "00002a92-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.resting_heart_rate"),

  /// The default characteristic for Sport Type for Aerobic and Anaerobic Thresholds
  sportTypeForAerobicAndAnaerobicThresholds(
      "Sport Type for Aerobic and Anaerobic Thresholds",
      "2a93",
      "00002a93-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.sport_type_for_aerobic_and_anaerobic_thresholds"),

  /// The default characteristic for Three Zone Heart Rate Limits
  threeZoneHeartRateLimits(
      "Three Zone Heart Rate Limits",
      "2a94",
      "00002a94-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.three_zone_heart_rate_limits"),

  /// The default characteristic for Two Zone Heart Rate Limits
  twoZoneHeartRateLimits(
      "Two Zone Heart Rate Limits",
      "2a95",
      "00002a95-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.two_zone_heart_rate_limits"),

  /// The default characteristic for VO2 Max
  vo2Max("VO2 Max", "2a96", "00002a96-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.vo2_max"),

  /// The default characteristic for Waist Circumference
  waistCircumference(
      "Waist Circumference",
      "2a97",
      "00002a97-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.waist_circumference"),

  /// The default characteristic for Weight
  weight("Weight", "2a98", "00002a98-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.weight"),

  /// The default characteristic for Database Change Increment
  databaseChangeIncrement(
      "Database Change Increment",
      "2a99",
      "00002a99-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.database_change_increment"),

  /// The default characteristic for User Index
  userIndex("User Index", "2a9a", "00002a9a-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.user_index"),

  /// The default characteristic for Body Composition Feature
  bodyCompositionFeature(
      "Body Composition Feature",
      "2a9b",
      "00002a9b-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.body_composition_feature"),

  /// The default characteristic for Body Composition Measurement
  bodyCompositionMeasurement(
      "Body Composition Measurement",
      "2a9c",
      "00002a9c-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.body_composition_measurement"),

  /// The default characteristic for Weight Measurement
  weightMeasurement(
      "Weight Measurement",
      "2a9d",
      "00002a9d-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.weight_measurement"),

  /// The default characteristic for Weight Scale Feature
  weightScaleFeature(
      "Weight Scale Feature",
      "2a9e",
      "00002a9e-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.weight_scale_feature"),

  /// The default characteristic for User Control Point
  userControlPoint(
      "User Control Point",
      "2a9f",
      "00002a9f-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.user_control_point"),

  /// The default characteristic for Magnetic Flux Density - 2D
  magneticFluxDensity2d(
      "Magnetic Flux Density - 2D",
      "2aa0",
      "00002aa0-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.magnetic_flux_density_2d"),

  /// The default characteristic for Magnetic Flux Density - 3D
  magneticFluxDensity3d(
      "Magnetic Flux Density - 3D",
      "2aa1",
      "00002aa1-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.magnetic_flux_density_3d"),

  /// The default characteristic for Language
  language("Language", "2aa2", "00002aa2-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.language"),

  /// The default characteristic for Barometric Pressure Trend
  barometricPressureTrend(
      "Barometric Pressure Trend",
      "2aa3",
      "00002aa3-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.barometric_pressure_trend"),

  /// The default characteristic for Bond Management Control Point
  bondManagementControlPoint(
      "Bond Management Control Point",
      "2aa4",
      "00002aa4-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.bond_management_control_point"),

  /// The default characteristic for Bond Management Feature
  bondManagementFeature(
      "Bond Management Feature",
      "2aa5",
      "00002aa5-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.bond_management_feature"),

  /// The default characteristic for Central Address Resolution
  centralAddressResolution(
      "Central Address Resolution",
      "2aa6",
      "00002aa6-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.gap.central_address_resolution"),

  /// The default characteristic for CGM Measurement
  cgmMeasurement(
      "CGM Measurement",
      "2aa7",
      "00002aa7-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.cgm_measurement"),

  /// The default characteristic for CGM Feature
  cgmFeature("CGM Feature", "2aa8", "00002aa8-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.cgm_feature"),

  /// The default characteristic for CGM Status
  cgmStatus("CGM Status", "2aa9", "00002aa9-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.cgm_status"),

  /// The default characteristic for CGM Session Start Time
  cgmSessionStartTime(
      "CGM Session Start Time",
      "2aaa",
      "00002aaa-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.cgm_session_start_time"),

  /// The default characteristic for CGM Session Run Time
  cgmSessionRunTime(
      "CGM Session Run Time",
      "2aab",
      "00002aab-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.cgm_session_run_time"),

  /// The default characteristic for CGM Specific Ops Control Point
  cgmSpecificOpsControlPoint(
      "CGM Specific Ops Control Point",
      "2aac",
      "00002aac-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.cgm_specific_ops_control_point"),

  /// The default characteristic for Indoor Positioning Configuration
  indoorPositioningConfiguration(
      "Indoor Positioning Configuration",
      "2aad",
      "00002aad-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.indoor_positioning_configuration"),

  /// The default characteristic for Latitude
  latitude("Latitude", "2aae", "00002aae-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.latitude"),

  /// The default characteristic for Longitude
  longitude("Longitude", "2aaf", "00002aaf-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.longitude"),

  /// The default characteristic for Local North Coordinate
  localNorthCoordinate(
      "Local North Coordinate",
      "2ab0",
      "00002ab0-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.local_north_coordinate"),

  /// The default characteristic for Local East Coordinate
  localEastCoordinate(
      "Local East Coordinate",
      "2ab1",
      "00002ab1-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.local_east_coordinate"),

  /// The default characteristic for Floor Number
  floorNumber("Floor Number", "2ab2", "00002ab2-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.floor_number"),

  /// The default characteristic for Altitude
  altitude("Altitude", "2ab3", "00002ab3-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.altitude"),

  /// The default characteristic for Uncertainty
  uncertainty("Uncertainty", "2ab4", "00002ab4-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.uncertainty"),

  /// The default characteristic for Location Name
  locationName("Location Name", "2ab5", "00002ab5-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.location_name"),

  /// The default characteristic for URI
  uri("URI", "2ab6", "00002ab6-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.uri"),

  /// The default characteristic for HTTP Headers
  httpHeaders("HTTP Headers", "2ab7", "00002ab7-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.http_headers"),

  /// The default characteristic for HTTP Status Code
  httpStatusCode(
      "HTTP Status Code",
      "2ab8",
      "00002ab8-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.http_status_code"),

  /// The default characteristic for HTTP Entity Body
  httpEntityBody(
      "HTTP Entity Body",
      "2ab9",
      "00002ab9-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.http_entity_body"),

  /// The default characteristic for HTTP Control Point
  httpControlPoint(
      "HTTP Control Point",
      "2aba",
      "00002aba-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.http_control_point"),

  /// The default characteristic for HTTPS Security
  httpsSecurity(
      "HTTPS Security",
      "2abb",
      "00002abb-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.https_security"),

  /// The default characteristic for TDS Control Point
  tdsControlPoint(
      "TDS Control Point",
      "2abc",
      "00002abc-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.tds_control_point"),

  /// The default characteristic for OTS Feature
  otsFeature("OTS Feature", "2abd", "00002abd-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.ots_feature"),

  /// The default characteristic for Object Name
  objectName("Object Name", "2abe", "00002abe-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.object_name"),

  /// The default characteristic for Object Type
  objectType("Object Type", "2abf", "00002abf-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.object_type"),

  /// The default characteristic for Object Size
  objectSize("Object Size", "2ac0", "00002ac0-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.object_size"),

  /// The default characteristic for Object First-Created
  objectFirstCreated(
      "Object First-Created",
      "2ac1",
      "00002ac1-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.object_first_created"),

  /// The default characteristic for Object Last-Modified
  objectLastModified(
      "Object Last-Modified",
      "2ac2",
      "00002ac2-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.object_last_modified"),

  /// The default characteristic for Object ID
  objectId("Object ID", "2ac3", "00002ac3-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.object_id"),

  /// The default characteristic for Object Properties
  objectProperties(
      "Object Properties",
      "2ac4",
      "00002ac4-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.object_properties"),

  /// The default characteristic for Object Action Control Point
  objectActionControlPoint(
      "Object Action Control Point",
      "2ac5",
      "00002ac5-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.object_action_control_point"),

  /// The default characteristic for Object List Control Point
  objectListControlPoint(
      "Object List Control Point",
      "2ac6",
      "00002ac6-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.object_list_control_point"),

  /// The default characteristic for Object List Filter
  objectListFilter(
      "Object List Filter",
      "2ac7",
      "00002ac7-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.object_list_filter"),

  /// The default characteristic for Object Changed
  objectChanged(
      "Object Changed",
      "2ac8",
      "00002ac8-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.object_changed"),

  /// The default characteristic for Resolvable Private Address Only
  resolvablePrivateAddressOnly(
      "Resolvable Private Address Only",
      "2ac9",
      "00002ac9-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.resolvable_private_address_only"),

  /// The default characteristic for Fitness Machine Feature
  fitnessMachineFeature(
      "Fitness Machine Feature",
      "2acc",
      "00002acc-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.fitness_machine_feature"),

  /// The default characteristic for Treadmill Data
  treadmillData(
      "Treadmill Data",
      "2acd",
      "00002acd-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.treadmill_data"),

  /// The default characteristic for Cross Trainer Data
  crossTrainerData(
      "Cross Trainer Data",
      "2ace",
      "00002ace-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.cross_trainer_data"),

  /// The default characteristic for Step Climber Data
  stepClimberData(
      "Step Climber Data",
      "2acf",
      "00002acf-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.step_climber_data"),

  /// The default characteristic for Stair Climber Data
  stairClimberData(
      "Stair Climber Data",
      "2ad0",
      "00002ad0-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.stair_climber_data"),

  /// The default characteristic for Rower Data
  rowerData("Rower Data", "2ad1", "00002ad1-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.rower_data"),

  /// The default characteristic for Indoor Bike Data
  indoorBikeData(
      "Indoor Bike Data",
      "2ad2",
      "00002ad2-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.indoor_bike_data"),

  /// The default characteristic for Training Status
  trainingStatus(
      "Training Status",
      "2ad3",
      "00002ad3-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.training_status"),

  /// The default characteristic for Supported Speed Range
  supportedSpeedRange(
      "Supported Speed Range",
      "2ad4",
      "00002ad4-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.supported_speed_range"),

  /// The default characteristic for Supported Inclination Range
  supportedInclinationRange(
      "Supported Inclination Range",
      "2ad5",
      "00002ad5-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.supported_inclination_range"),

  /// The default characteristic for Supported Resistance Level Range
  supportedResistanceLevelRange(
      "Supported Resistance Level Range",
      "2ad6",
      "00002ad6-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.supported_resistance_level_range"),

  /// The default characteristic for Supported Heart Rate Range
  supportedHeartRateRange(
      "Supported Heart Rate Range",
      "2ad7",
      "00002ad7-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.supported_heart_rate_range"),

  /// The default characteristic for Supported Power Range
  supportedPowerRange(
      "Supported Power Range",
      "2ad8",
      "00002ad8-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.supported_power_range"),

  /// The default characteristic for Fitness Machine Control Point
  fitnessMachineControlPoint(
      "Fitness Machine Control Point",
      "2ad9",
      "00002ad9-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.fitness_machine_control_point"),

  /// The default characteristic for Fitness Machine Status
  fitnessMachineStatus(
      "Fitness Machine Status",
      "2ada",
      "00002ada-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.fitness_machine_status"),

  /// The default characteristic for Mesh Provisioning Data In
  meshProvisioningDataIn(
      "Mesh Provisioning Data In",
      "2adb",
      "00002adb-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.mesh_provisioning_data_in"),

  /// The default characteristic for Mesh Provisioning Data Out
  meshProvisioningDataOut(
      "Mesh Provisioning Data Out",
      "2adc",
      "00002adc-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.mesh_provisioning_data_out"),

  /// The default characteristic for Mesh Proxy Data In
  meshProxyDataIn(
      "Mesh Proxy Data In",
      "2add",
      "00002add-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.mesh_proxy_data_in"),

  /// The default characteristic for Mesh Proxy Data Out
  meshProxyDataOut(
      "Mesh Proxy Data Out",
      "2ade",
      "00002ade-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.mesh_proxy_data_out"),

  /// The default characteristic for Average Current
  averageCurrent(
      "Average Current",
      "2ae0",
      "00002ae0-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.average_current"),

  /// The default characteristic for Average Voltage
  averageVoltage(
      "Average Voltage",
      "2ae1",
      "00002ae1-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.average_voltage"),

  /// The default characteristic for Boolean
  boolean("Boolean", "2ae2", "00002ae2-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.boolean"),

  /// The default characteristic for Chromatic Distance from Planckian
  chromaticDistanceFromPlanckian(
      "Chromatic Distance from Planckian",
      "2ae3",
      "00002ae3-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.chromatic_distance_from_planckian"),

  /// The default characteristic for Chromaticity Coordinates
  chromaticityCoordinates(
      "Chromaticity Coordinates",
      "2ae4",
      "00002ae4-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.chromaticity_coordinates"),

  /// The default characteristic for Chromaticity in CCT and Duv Values
  chromaticityInCctAndDuvValues(
      "Chromaticity in CCT and Duv Values",
      "2ae5",
      "00002ae5-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.chromaticity_in_cct_and_duv_values"),

  /// The default characteristic for Chromaticity Tolerance
  chromaticityTolerance(
      "Chromaticity Tolerance",
      "2ae6",
      "00002ae6-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.chromaticity_tolerance"),

  /// The default characteristic for CIE 13.3-1995 Color Rendering Index
  cie1331995ColorRenderingIndex(
      "CIE 13.3-1995 Color Rendering Index",
      "2ae7",
      "00002ae7-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.cie_13_3_1995_color_rendering_index"),

  /// The default characteristic for Coefficient
  coefficient("Coefficient", "2ae8", "00002ae8-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.coefficient"),

  /// The default characteristic for Correlated Color Temperature
  correlatedColorTemperature(
      "Correlated Color Temperature",
      "2ae9",
      "00002ae9-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.correlated_color_temperature"),

  /// The default characteristic for Count 16
  count16("Count 16", "2aea", "00002aea-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.count_16"),

  /// The default characteristic for Count 24
  count24("Count 24", "2aeb", "00002aeb-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.count_24"),

  /// The default characteristic for Country Code
  countryCode("Country Code", "2aec", "00002aec-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.country_code"),

  /// The default characteristic for Date UTC
  dateUtc("Date UTC", "2aed", "00002aed-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.date_utc"),

  /// The default characteristic for Electric Current
  electricCurrent(
      "Electric Current",
      "2aee",
      "00002aee-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.electric_current"),

  /// The default characteristic for Electric Current Range
  electricCurrentRange(
      "Electric Current Range",
      "2aef",
      "00002aef-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.electric_current_range"),

  /// The default characteristic for Electric Current Specification
  electricCurrentSpecification(
      "Electric Current Specification",
      "2af0",
      "00002af0-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.electric_current_specification"),

  /// The default characteristic for Electric Current Statistics
  electricCurrentStatistics(
      "Electric Current Statistics",
      "2af1",
      "00002af1-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.electric_current_statistics"),

  /// The default characteristic for Energy
  energy("Energy", "2af2", "00002af2-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.energy"),

  /// The default characteristic for Energy in a Period of Day
  energyInAPeriodOfDay(
      "Energy in a Period of Day",
      "2af3",
      "00002af3-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.energy_in_a_period_of_day"),

  /// The default characteristic for Event Statistics
  eventStatistics(
      "Event Statistics",
      "2af4",
      "00002af4-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.event_statistics"),

  /// The default characteristic for Fixed String 16
  fixedString16(
      "Fixed String 16",
      "2af5",
      "00002af5-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.fixed_string_16"),

  /// The default characteristic for Fixed String 24
  fixedString24(
      "Fixed String 24",
      "2af6",
      "00002af6-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.fixed_string_24"),

  /// The default characteristic for Fixed String 36
  fixedString36(
      "Fixed String 36",
      "2af7",
      "00002af7-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.fixed_string_36"),

  /// The default characteristic for Fixed String 8
  fixedString8("Fixed String 8", "2af8", "00002af8-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.fixed_string_8"),

  /// The default characteristic for Generic Level
  genericLevel("Generic Level", "2af9", "00002af9-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.generic_level"),

  /// The default characteristic for Global Trade Item Number
  globalTradeItemNumber(
      "Global Trade Item Number",
      "2afa",
      "00002afa-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.global_trade_item_number"),

  /// The default characteristic for Illuminance
  illuminance("Illuminance", "2afb", "00002afb-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.illuminance"),

  /// The default characteristic for Luminous Efficacy
  luminousEfficacy(
      "Luminous Efficacy",
      "2afc",
      "00002afc-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.luminous_efficacy"),

  /// The default characteristic for Luminous Energy
  luminousEnergy(
      "Luminous Energy",
      "2afd",
      "00002afd-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.luminous_energy"),

  /// The default characteristic for Luminous Exposure
  luminousExposure(
      "Luminous Exposure",
      "2afe",
      "00002afe-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.luminous_exposure"),

  /// The default characteristic for Luminous Flux
  luminousFlux("Luminous Flux", "2aff", "00002aff-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.luminous_flux"),

  /// The default characteristic for Luminous Flux Range
  luminousFluxRange(
      "Luminous Flux Range",
      "2b00",
      "00002b00-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.luminous_flux_range"),

  /// The default characteristic for Luminous Intensity
  luminousIntensity(
      "Luminous Intensity",
      "2b01",
      "00002b01-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.luminous_intensity"),

  /// The default characteristic for Mass Flow
  massFlow("Mass Flow", "2b02", "00002b02-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.mass_flow"),

  /// The default characteristic for Perceived Lightness
  perceivedLightness(
      "Perceived Lightness",
      "2b03",
      "00002b03-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.perceived_lightness"),

  /// The default characteristic for Percentage 8
  percentage8("Percentage 8", "2b04", "00002b04-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.percentage_8"),

  /// The default characteristic for Power
  power("Power", "2b05", "00002b05-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.power"),

  /// The default characteristic for Power Specification
  powerSpecification(
      "Power Specification",
      "2b06",
      "00002b06-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.power_specification"),

  /// The default characteristic for Relative Runtime in a Current Range
  relativeRuntimeInACurrentRange(
      "Relative Runtime in a Current Range",
      "2b07",
      "00002b07-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.relative_runtime_in_a_current_range"),

  /// The default characteristic for Relative Runtime in a Generic Level Range
  relativeRuntimeInAGenericLevelRange(
      "Relative Runtime in a Generic Level Range",
      "2b08",
      "00002b08-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.relative_runtime_in_a_generic_level_range"),

  /// The default characteristic for Relative Value in a Voltage Range
  relativeValueInAVoltageRange(
      "Relative Value in a Voltage Range",
      "2b09",
      "00002b09-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.relative_value_in_a_voltage_range"),

  /// The default characteristic for Relative Value in an Illuminance Range
  relativeValueInAnIlluminanceRange(
      "Relative Value in an Illuminance Range",
      "2b0a",
      "00002b0a-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.relative_value_in_an_illuminance_range"),

  /// The default characteristic for Relative Value in a Period of Day
  relativeValueInAPeriodOfDay(
      "Relative Value in a Period of Day",
      "2b0b",
      "00002b0b-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.relative_value_in_a_period_of_day"),

  /// The default characteristic for Relative Value in a Temperature Range
  relativeValueInATemperatureRange(
      "Relative Value in a Temperature Range",
      "2b0c",
      "00002b0c-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.relative_value_in_a_temperature_range"),

  /// The default characteristic for Temperature 8
  temperature8("Temperature 8", "2b0d", "00002b0d-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.temperature_8"),

  /// The default characteristic for Temperature 8 in a Period of Day
  temperature8InAPeriodOfDay(
      "Temperature 8 in a Period of Day",
      "2b0e",
      "00002b0e-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.temperature_8_in_a_period_of_day"),

  /// The default characteristic for Temperature 8 Statistics
  temperature8Statistics(
      "Temperature 8 Statistics",
      "2b0f",
      "00002b0f-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.temperature_8_statistics"),

  /// The default characteristic for Temperature Range
  temperatureRange(
      "Temperature Range",
      "2b10",
      "00002b10-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.temperature_range"),

  /// The default characteristic for Temperature Statistics
  temperatureStatistics(
      "Temperature Statistics",
      "2b11",
      "00002b11-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.temperature_statistics"),

  /// The default characteristic for Time Decihour 8
  timeDecihour8(
      "Time Decihour 8",
      "2b12",
      "00002b12-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.time_decihour_8"),

  /// The default characteristic for Time Exponential 8
  timeExponential8(
      "Time Exponential 8",
      "2b13",
      "00002b13-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.time_exponential_8"),

  /// The default characteristic for Time Hour 24
  timeHour24("Time Hour 24", "2b14", "00002b14-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.time_hour_24"),

  /// The default characteristic for Time Millisecond 24
  timeMillisecond24(
      "Time Millisecond 24",
      "2b15",
      "00002b15-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.time_millisecond_24"),

  /// The default characteristic for Time Second 16
  timeSecond16("Time Second 16", "2b16", "00002b16-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.time_second_16"),

  /// The default characteristic for Time Second 8
  timeSecond8("Time Second 8", "2b17", "00002b17-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.time_second_8"),

  /// The default characteristic for Voltage
  voltage("Voltage", "2b18", "00002b18-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.voltage"),

  /// The default characteristic for Voltage Specification
  voltageSpecification(
      "Voltage Specification",
      "2b19",
      "00002b19-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.voltage_specification"),

  /// The default characteristic for Voltage Statistics
  voltageStatistics(
      "Voltage Statistics",
      "2b1a",
      "00002b1a-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.voltage_statistics"),

  /// The default characteristic for Volume Flow
  volumeFlow("Volume Flow", "2b1b", "00002b1b-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.volume_flow"),

  /// The default characteristic for Chromaticity Coordinate
  chromaticityCoordinate(
      "Chromaticity Coordinate",
      "2b1c",
      "00002b1c-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.chromaticity_coordinate"),

  /// The default characteristic for RC Feature
  rcFeature("RC Feature", "2b1d", "00002b1d-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.rc_feature"),

  /// The default characteristic for RC Settings
  rcSettings("RC Settings", "2b1e", "00002b1e-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.rc_settings"),

  /// The default characteristic for Reconnection Configuration Control Point
  reconnectionConfigurationControlPoint(
      "Reconnection Configuration Control Point",
      "2b1f",
      "00002b1f-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.reconnection_configuration_control_point"),

  /// The default characteristic for IDD Status Changed
  iddStatusChanged(
      "IDD Status Changed",
      "2b20",
      "00002b20-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.idd_status_changed"),

  /// The default characteristic for IDD Status
  iddStatus("IDD Status", "2b21", "00002b21-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.idd_status"),

  /// The default characteristic for IDD Annunciation Status
  iddAnnunciationStatus(
      "IDD Annunciation Status",
      "2b22",
      "00002b22-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.idd_annunciation_status"),

  /// The default characteristic for IDD Features
  iddFeatures("IDD Features", "2b23", "00002b23-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.idd_features"),

  /// The default characteristic for IDD Status Reader Control Point
  iddStatusReaderControlPoint(
      "IDD Status Reader Control Point",
      "2b24",
      "00002b24-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.idd_status_reader_control_point"),

  /// The default characteristic for IDD Command Control Point
  iddCommandControlPoint(
      "IDD Command Control Point",
      "2b25",
      "00002b25-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.idd_command_control_point"),

  /// The default characteristic for IDD Command Data
  iddCommandData(
      "IDD Command Data",
      "2b26",
      "00002b26-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.idd_command_data"),

  /// The default characteristic for IDD Record Access Control Point
  iddRecordAccessControlPoint(
      "IDD Record Access Control Point",
      "2b27",
      "00002b27-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.idd_record_access_control_point"),

  /// The default characteristic for IDD History Data
  iddHistoryData(
      "IDD History Data",
      "2b28",
      "00002b28-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.idd_history_data"),

  /// The default characteristic for Client Supported Features
  clientSupportedFeatures(
      "Client Supported Features",
      "2b29",
      "00002b29-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.client_supported_features"),

  /// The default characteristic for Database Hash
  databaseHash("Database Hash", "2b2a", "00002b2a-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.database_hash"),

  /// The default characteristic for BSS Control Point
  bssControlPoint(
      "BSS Control Point",
      "2b2b",
      "00002b2b-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.bss_control_point"),

  /// The default characteristic for BSS Response
  bssResponse("BSS Response", "2b2c", "00002b2c-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.bss_response"),

  /// The default characteristic for Emergency ID
  emergencyId("Emergency ID", "2b2d", "00002b2d-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.emergency_id"),

  /// The default characteristic for Emergency Text
  emergencyText(
      "Emergency Text",
      "2b2e",
      "00002b2e-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.emergency_text"),

  /// The default characteristic for ACS Status
  acsStatus("ACS Status", "2b2f", "00002b2f-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.acs_status"),

  /// The default characteristic for ACS Data In
  acsDataIn("ACS Data In", "2b30", "00002b30-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.acs_data_in"),

  /// The default characteristic for ACS Data Out Notify
  acsDataOutNotify(
      "ACS Data Out Notify",
      "2b31",
      "00002b31-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.acs_data_out_notify"),

  /// The default characteristic for ACS Data Out Indicate
  acsDataOutIndicate(
      "ACS Data Out Indicate",
      "2b32",
      "00002b32-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.acs_data_out_indicate"),

  /// The default characteristic for ACS Control Point
  acsControlPoint(
      "ACS Control Point",
      "2b33",
      "00002b33-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.acs_control_point"),

  /// The default characteristic for Enhanced Blood Pressure Measurement
  enhancedBloodPressureMeasurement(
      "Enhanced Blood Pressure Measurement",
      "2b34",
      "00002b34-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.enhanced_blood_pressure_measurement"),

  /// The default characteristic for Enhanced Intermediate Cuff Pressure
  enhancedIntermediateCuffPressure(
      "Enhanced Intermediate Cuff Pressure",
      "2b35",
      "00002b35-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.enhanced_intermediate_cuff_pressure"),

  /// The default characteristic for Blood Pressure Record
  bloodPressureRecord(
      "Blood Pressure Record",
      "2b36",
      "00002b36-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.blood_pressure_record"),

  /// The default characteristic for Registered User
  registeredUser(
      "Registered User",
      "2b37",
      "00002b37-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.registered_user"),

  /// The default characteristic for BR-EDR Handover Data
  brEdrHandoverData(
      "BR-EDR Handover Data",
      "2b38",
      "00002b38-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.br_edr_handover_data"),

  /// The default characteristic for Bluetooth SIG Data
  bluetoothSigData(
      "Bluetooth SIG Data",
      "2b39",
      "00002b39-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.bluetooth_sig_data"),

  /// The default characteristic for Server Supported Features
  serverSupportedFeatures(
      "Server Supported Features",
      "2b3a",
      "00002b3a-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.server_supported_features"),

  /// The default characteristic for Physical Activity Monitor Features
  physicalActivityMonitorFeatures(
      "Physical Activity Monitor Features",
      "2b3b",
      "00002b3b-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.physical_activity_monitor_features"),

  /// The default characteristic for General Activity Instantaneous Data
  generalActivityInstantaneousData(
      "General Activity Instantaneous Data",
      "2b3c",
      "00002b3c-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.general_activity_instantaneous_data"),

  /// The default characteristic for General Activity Summary Data
  generalActivitySummaryData(
      "General Activity Summary Data",
      "2b3d",
      "00002b3d-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.general_activity_summary_data"),

  /// The default characteristic for CardioRespiratory Activity Instantaneous Data
  cardiorespiratoryActivityInstantaneousData(
      "CardioRespiratory Activity Instantaneous Data",
      "2b3e",
      "00002b3e-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.cardiorespiratory_activity_instantaneous_data"),

  /// The default characteristic for CardioRespiratory Activity Summary Data
  cardiorespiratoryActivitySummaryData(
      "CardioRespiratory Activity Summary Data",
      "2b3f",
      "00002b3f-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.cardiorespiratory_activity_summary_data"),

  /// The default characteristic for Step Counter Activity Summary Data
  stepCounterActivitySummaryData(
      "Step Counter Activity Summary Data",
      "2b40",
      "00002b40-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.step_counter_activity_summary_data"),

  /// The default characteristic for Sleep Activity Instantaneous Data
  sleepActivityInstantaneousData(
      "Sleep Activity Instantaneous Data",
      "2b41",
      "00002b41-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.sleep_activity_instantaneous_data"),

  /// The default characteristic for Sleep Activity Summary Data
  sleepActivitySummaryData(
      "Sleep Activity Summary Data",
      "2b42",
      "00002b42-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.sleep_activity_summary_data"),

  /// The default characteristic for Physical Activity Monitor Control Point
  physicalActivityMonitorControlPoint(
      "Physical Activity Monitor Control Point",
      "2b43",
      "00002b43-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.physical_activity_monitor_control_point"),

  /// The default characteristic for Physical Activity Current Session
  physicalActivityCurrentSession(
      "Physical Activity Current Session",
      "2b44",
      "00002b44-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.physical_activity_current_session"),

  /// The default characteristic for Physical Activity Session Descriptor
  physicalActivitySessionDescriptor(
      "Physical Activity Session Descriptor",
      "2b45",
      "00002b45-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.physical_activity_session_descriptor"),

  /// The default characteristic for Preferred Units
  preferredUnits(
      "Preferred Units",
      "2b46",
      "00002b46-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.preferred_units"),

  /// The default characteristic for High Resolution Height
  highResolutionHeight(
      "High Resolution Height",
      "2b47",
      "00002b47-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.high_resolution_height"),

  /// The default characteristic for Middle Name
  middleName("Middle Name", "2b48", "00002b48-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.middle_name"),

  /// The default characteristic for Stride Length
  strideLength("Stride Length", "2b49", "00002b49-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.stride_length"),

  /// The default characteristic for Handedness
  handedness("Handedness", "2b4a", "00002b4a-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.handedness"),

  /// The default characteristic for Device Wearing Position
  deviceWearingPosition(
      "Device Wearing Position",
      "2b4b",
      "00002b4b-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.device_wearing_position"),

  /// The default characteristic for Four Zone Heart Rate Limits
  fourZoneHeartRateLimits(
      "Four Zone Heart Rate Limits",
      "2b4c",
      "00002b4c-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.four_zone_heart_rate_limits"),

  /// The default characteristic for High Intensity Exercise Threshold
  highIntensityExerciseThreshold(
      "High Intensity Exercise Threshold",
      "2b4d",
      "00002b4d-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.high_intensity_exercise_threshold"),

  /// The default characteristic for Activity Goal
  activityGoal("Activity Goal", "2b4e", "00002b4e-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.activity_goal"),

  /// The default characteristic for Sedentary Interval Notification
  sedentaryIntervalNotification(
      "Sedentary Interval Notification",
      "2b4f",
      "00002b4f-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.sedentary_interval_notification"),

  /// The default characteristic for Caloric Intake
  caloricIntake(
      "Caloric Intake",
      "2b50",
      "00002b50-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.caloric_intake"),

  /// The default characteristic for TMAP Role
  tmapRole("TMAP Role", "2b51", "00002b51-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.tmap_role"),

  /// The default characteristic for Audio Input State
  audioInputState(
      "Audio Input State",
      "2b77",
      "00002b77-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.audio_input_state"),

  /// The default characteristic for Gain Settings Attribute
  gainSettingsAttribute(
      "Gain Settings Attribute",
      "2b78",
      "00002b78-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.gain_settings_attribute"),

  /// The default characteristic for Audio Input Type
  audioInputType(
      "Audio Input Type",
      "2b79",
      "00002b79-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.audio_input_type"),

  /// The default characteristic for Audio Input Status
  audioInputStatus(
      "Audio Input Status",
      "2b7a",
      "00002b7a-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.audio_input_status"),

  /// The default characteristic for Audio Input Control Point
  audioInputControlPoint(
      "Audio Input Control Point",
      "2b7b",
      "00002b7b-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.audio_input_control_point"),

  /// The default characteristic for Audio Input Description
  audioInputDescription(
      "Audio Input Description",
      "2b7c",
      "00002b7c-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.audio_input_description"),

  /// The default characteristic for Volume State
  volumeState("Volume State", "2b7d", "00002b7d-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.volume_state"),

  /// The default characteristic for Volume Control Point
  volumeControlPoint(
      "Volume Control Point",
      "2b7e",
      "00002b7e-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.volume_control_point"),

  /// The default characteristic for Volume Flags
  volumeFlags("Volume Flags", "2b7f", "00002b7f-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.volume_flags"),

  /// The default characteristic for Volume Offset State
  volumeOffsetState(
      "Volume Offset State",
      "2b80",
      "00002b80-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.volume_offset_state"),

  /// The default characteristic for Audio Location
  audioLocation(
      "Audio Location",
      "2b81",
      "00002b81-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.audio_location"),

  /// The default characteristic for Volume Offset Control Point
  volumeOffsetControlPoint(
      "Volume Offset Control Point",
      "2b82",
      "00002b82-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.volume_offset_control_point"),

  /// The default characteristic for Audio Output Description
  audioOutputDescription(
      "Audio Output Description",
      "2b83",
      "00002b83-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.audio_output_description"),

  /// The default characteristic for Set Identity Resolving Key
  setIdentityResolvingKey(
      "Set Identity Resolving Key",
      "2b84",
      "00002b84-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.set_identity_resolving_key"),

  /// The default characteristic for Coordinated Set Size
  coordinatedSetSize(
      "Coordinated Set Size",
      "2b85",
      "00002b85-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.size_characteristic"),

  /// The default characteristic for Set Member Lock
  setMemberLock(
      "Set Member Lock",
      "2b86",
      "00002b86-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.lock_characteristic"),

  /// The default characteristic for Set Member Rank
  setMemberRank(
      "Set Member Rank",
      "2b87",
      "00002b87-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.rank_characteristic"),

  /// The default characteristic for Encrypted Data Key Material
  encryptedDataKeyMaterial(
      "Encrypted Data Key Material",
      "2b88",
      "00002b88-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.encrypted_data_key_material"),

  /// The default characteristic for Apparent Energy 32
  apparentEnergy32(
      "Apparent Energy 32",
      "2b89",
      "00002b89-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.apparent_energy_32"),

  /// The default characteristic for Apparent Power
  apparentPower(
      "Apparent Power",
      "2b8a",
      "00002b8a-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.apparent_power"),

  /// The default characteristic for Live Health Observations
  liveHealthObservations(
      "Live Health Observations",
      "2b8b",
      "00002b8b-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.live_health_observations"),

  /// The default characteristic for CO2 Concentration
  co2Concentration(
      "CO2 Concentration",
      "2b8c",
      "00002b8c-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.co2_concentration"),

  /// The default characteristic for Cosine of the Angle
  cosineOfTheAngle(
      "Cosine of the Angle",
      "2b8d",
      "00002b8d-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.cosine_of_the_angle"),

  /// The default characteristic for Device Time Feature
  deviceTimeFeature(
      "Device Time Feature",
      "2b8e",
      "00002b8e-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.device_time_feature"),

  /// The default characteristic for Device Time Parameters
  deviceTimeParameters(
      "Device Time Parameters",
      "2b8f",
      "00002b8f-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.device_time_parameters"),

  /// The default characteristic for Device Time
  deviceTime("Device Time", "2b90", "00002b90-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.device_time"),

  /// The default characteristic for Device Time Control Point
  deviceTimeControlPoint(
      "Device Time Control Point",
      "2b91",
      "00002b91-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.device_time_control_point"),

  /// The default characteristic for Time Change Log Data
  timeChangeLogData(
      "Time Change Log Data",
      "2b92",
      "00002b92-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.time_change_log_data"),

  /// The default characteristic for Media Player Name
  mediaPlayerName(
      "Media Player Name",
      "2b93",
      "00002b93-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.media_player_name"),

  /// The default characteristic for Media Player Icon Object ID
  mediaPlayerIconObjectId(
      "Media Player Icon Object ID",
      "2b94",
      "00002b94-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.media_player_icon_object_id"),

  /// The default characteristic for Media Player Icon URL
  mediaPlayerIconUrl(
      "Media Player Icon URL",
      "2b95",
      "00002b95-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.media_player_icon_url"),

  /// The default characteristic for Track Changed
  trackChanged("Track Changed", "2b96", "00002b96-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.track_changed"),

  /// The default characteristic for Track Title
  trackTitle("Track Title", "2b97", "00002b97-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.track_title"),

  /// The default characteristic for Track Duration
  trackDuration(
      "Track Duration",
      "2b98",
      "00002b98-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.track_duration"),

  /// The default characteristic for Track Position
  trackPosition(
      "Track Position",
      "2b99",
      "00002b99-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.track_position"),

  /// The default characteristic for Playback Speed
  playbackSpeed(
      "Playback Speed",
      "2b9a",
      "00002b9a-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.playback_speed"),

  /// The default characteristic for Seeking Speed
  seekingSpeed("Seeking Speed", "2b9b", "00002b9b-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.seeking_speed"),

  /// The default characteristic for Current Track Segments Object ID
  currentTrackSegmentsObjectId(
      "Current Track Segments Object ID",
      "2b9c",
      "00002b9c-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.current_track_segments_object_id"),

  /// The default characteristic for Current Track Object ID
  currentTrackObjectId(
      "Current Track Object ID",
      "2b9d",
      "00002b9d-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.current_track_object_id"),

  /// The default characteristic for Next Track Object ID
  nextTrackObjectId(
      "Next Track Object ID",
      "2b9e",
      "00002b9e-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.next_track_object_id"),

  /// The default characteristic for Parent Group Object ID
  parentGroupObjectId(
      "Parent Group Object ID",
      "2b9f",
      "00002b9f-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.parent_group_object_id"),

  /// The default characteristic for Current Group Object ID
  currentGroupObjectId(
      "Current Group Object ID",
      "2ba0",
      "00002ba0-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.current_group_object_id"),

  /// The default characteristic for Playing Order
  playingOrder("Playing Order", "2ba1", "00002ba1-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.playing_order"),

  /// The default characteristic for Playing Orders Supported
  playingOrdersSupported(
      "Playing Orders Supported",
      "2ba2",
      "00002ba2-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.playing_orders_supported"),

  /// The default characteristic for Media State
  mediaState("Media State", "2ba3", "00002ba3-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.media_state"),

  /// The default characteristic for Media Control Point
  mediaControlPoint(
      "Media Control Point",
      "2ba4",
      "00002ba4-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.media_control_point"),

  /// The default characteristic for Media Control Point Opcodes Supported
  mediaControlPointOpcodesSupported(
      "Media Control Point Opcodes Supported",
      "2ba5",
      "00002ba5-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.media_control_point_opcodes_supported"),

  /// The default characteristic for Search Results Object ID
  searchResultsObjectId(
      "Search Results Object ID",
      "2ba6",
      "00002ba6-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.search_results_object_id"),

  /// The default characteristic for Search Control Point
  searchControlPoint(
      "Search Control Point",
      "2ba7",
      "00002ba7-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.search_control_point"),

  /// The default characteristic for Energy 32
  energy32("Energy 32", "2ba8", "00002ba8-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.energy_32"),

  /// The default characteristic for Constant Tone Extension Enable
  constantToneExtensionEnable(
      "Constant Tone Extension Enable",
      "2bad",
      "00002bad-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.constant_tone_extension_enable"),

  /// The default characteristic for Advertising Constant Tone Extension Minimum Length
  advertisingConstantToneExtensionMinimumLength(
      "Advertising Constant Tone Extension Minimum Length",
      "2bae",
      "00002bae-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.advertising_constant_tone_extension_minimum_length"),

  /// The default characteristic for Advertising Constant Tone Extension Minimum Transmit Count
  advertisingConstantToneExtensionMinimumTransmitCount(
      "Advertising Constant Tone Extension Minimum Transmit Count",
      "2baf",
      "00002baf-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.advertising_constant_tone_extension_minimum_transmit_count"),

  /// The default characteristic for Advertising Constant Tone Extension Transmit Duration
  advertisingConstantToneExtensionTransmitDuration(
      "Advertising Constant Tone Extension Transmit Duration",
      "2bb0",
      "00002bb0-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.advertising_constant_tone_extension_transmit_duration"),

  /// The default characteristic for Advertising Constant Tone Extension Interval
  advertisingConstantToneExtensionInterval(
      "Advertising Constant Tone Extension Interval",
      "2bb1",
      "00002bb1-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.advertising_constant_tone_extension_interval"),

  /// The default characteristic for Advertising Constant Tone Extension PHY
  advertisingConstantToneExtensionPhy(
      "Advertising Constant Tone Extension PHY",
      "2bb2",
      "00002bb2-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.advertising_constant_tone_extension_phy"),

  /// The default characteristic for Bearer Provider Name
  bearerProviderName(
      "Bearer Provider Name",
      "2bb3",
      "00002bb3-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.bearer_provider_name"),

  /// The default characteristic for Bearer UCI
  bearerUci("Bearer UCI", "2bb4", "00002bb4-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.bearer_uci"),

  /// The default characteristic for Bearer Technology
  bearerTechnology(
      "Bearer Technology",
      "2bb5",
      "00002bb5-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.bearer_technology"),

  /// The default characteristic for Bearer URI Schemes Supported List
  bearerUriSchemesSupportedList(
      "Bearer URI Schemes Supported List",
      "2bb6",
      "00002bb6-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.bearer_uri_schemes_supported_list"),

  /// The default characteristic for Bearer Signal Strength
  bearerSignalStrength(
      "Bearer Signal Strength",
      "2bb7",
      "00002bb7-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.bearer_signal_strength"),

  /// The default characteristic for Bearer Signal Strength Reporting Interval
  bearerSignalStrengthReportingInterval(
      "Bearer Signal Strength Reporting Interval",
      "2bb8",
      "00002bb8-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.bearer_signal_strength_reporting_interval"),

  /// The default characteristic for Bearer List Current Calls
  bearerListCurrentCalls(
      "Bearer List Current Calls",
      "2bb9",
      "00002bb9-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.bearer_list_current_calls"),

  /// The default characteristic for Content Control ID
  contentControlId(
      "Content Control ID",
      "2bba",
      "00002bba-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.content_control_id"),

  /// The default characteristic for Status Flags
  statusFlags("Status Flags", "2bbb", "00002bbb-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.status_flags"),

  /// The default characteristic for Incoming Call Target Bearer URI
  incomingCallTargetBearerUri(
      "Incoming Call Target Bearer URI",
      "2bbc",
      "00002bbc-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.incoming_call_target_bearer_uri"),

  /// The default characteristic for Call State
  callState("Call State", "2bbd", "00002bbd-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.call_state"),

  /// The default characteristic for Call Control Point
  callControlPoint(
      "Call Control Point",
      "2bbe",
      "00002bbe-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.call_control_point"),

  /// The default characteristic for Call Control Point Optional Opcodes
  callControlPointOptionalOpcodes(
      "Call Control Point Optional Opcodes",
      "2bbf",
      "00002bbf-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.call_control_point_optional_opcodes"),

  /// The default characteristic for Termination Reason
  terminationReason(
      "Termination Reason",
      "2bc0",
      "00002bc0-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.termination_reason"),

  /// The default characteristic for Incoming Call
  incomingCall("Incoming Call", "2bc1", "00002bc1-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.incoming_call"),

  /// The default characteristic for Call Friendly Name
  callFriendlyName(
      "Call Friendly Name",
      "2bc2",
      "00002bc2-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.call_friendly_name"),

  /// The default characteristic for Mute
  mute("Mute", "2bc3", "00002bc3-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.mute"),

  /// The default characteristic for Sink ASE
  sinkAse("Sink ASE", "2bc4", "00002bc4-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.sink_ase"),

  /// The default characteristic for Source ASE
  sourceAse("Source ASE", "2bc5", "00002bc5-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.source_ase"),

  /// The default characteristic for ASE Control Point
  aseControlPoint(
      "ASE Control Point",
      "2bc6",
      "00002bc6-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.ase_control_point"),

  /// The default characteristic for Broadcast Audio Scan Control Point
  broadcastAudioScanControlPoint(
      "Broadcast Audio Scan Control Point",
      "2bc7",
      "00002bc7-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.broadcast_audio_scan_control_point"),

  /// The default characteristic for Broadcast Receive State
  broadcastReceiveState(
      "Broadcast Receive State",
      "2bc8",
      "00002bc8-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.broadcast_receive_state"),

  /// The default characteristic for Sink PAC
  sinkPac("Sink PAC", "2bc9", "00002bc9-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.sink_pac"),

  /// The default characteristic for Sink Audio Locations
  sinkAudioLocations(
      "Sink Audio Locations",
      "2bca",
      "00002bca-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.sink_audio_locations"),

  /// The default characteristic for Source PAC
  sourcePac("Source PAC", "2bcb", "00002bcb-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.source_pac"),

  /// The default characteristic for Source Audio Locations
  sourceAudioLocations(
      "Source Audio Locations",
      "2bcc",
      "00002bcc-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.source_audio_locations"),

  /// The default characteristic for Available Audio Contexts
  availableAudioContexts(
      "Available Audio Contexts",
      "2bcd",
      "00002bcd-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.available_audio_contexts"),

  /// The default characteristic for Supported Audio Contexts
  supportedAudioContexts(
      "Supported Audio Contexts",
      "2bce",
      "00002bce-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.supported_audio_contexts"),

  /// The default characteristic for Ammonia Concentration
  ammoniaConcentration(
      "Ammonia Concentration",
      "2bcf",
      "00002bcf-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.ammonia_concentration"),

  /// The default characteristic for Carbon Monoxide Concentration
  carbonMonoxideConcentration(
      "Carbon Monoxide Concentration",
      "2bd0",
      "00002bd0-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.carbon_monoxide_concentration"),

  /// The default characteristic for Methane Concentration
  methaneConcentration(
      "Methane Concentration",
      "2bd1",
      "00002bd1-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.methane_concentration"),

  /// The default characteristic for Nitrogen Dioxide Concentration
  nitrogenDioxideConcentration(
      "Nitrogen Dioxide Concentration",
      "2bd2",
      "00002bd2-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.nitrogen_dioxide_concentration"),

  /// The default characteristic for Non-Methane Volatile Organic Compounds Concentration
  nonMethaneVolatileOrganicCompoundsConcentration(
      "Non-Methane Volatile Organic Compounds Concentration",
      "2bd3",
      "00002bd3-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.non-methane_volatile_organic_compounds_concentration"),

  /// The default characteristic for Ozone Concentration
  ozoneConcentration(
      "Ozone Concentration",
      "2bd4",
      "00002bd4-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.ozone_concentration"),

  /// The default characteristic for Particulate Matter - PM1 Concentration
  particulateMatterPm1Concentration(
      "Particulate Matter - PM1 Concentration",
      "2bd5",
      "00002bd5-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.particulate_matter_pm1_concentration"),

  /// The default characteristic for Particulate Matter - PM2.5 Concentration
  particulateMatterPm25Concentration(
      "Particulate Matter - PM2.5 Concentration",
      "2bd6",
      "00002bd6-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.particulate_matter_pm2_5_concentration"),

  /// The default characteristic for Particulate Matter - PM10 Concentration
  particulateMatterPm10Concentration(
      "Particulate Matter - PM10 Concentration",
      "2bd7",
      "00002bd7-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.particulate_matter_pm10_concentration"),

  /// The default characteristic for Sulfur Dioxide Concentration
  sulfurDioxideConcentration(
      "Sulfur Dioxide Concentration",
      "2bd8",
      "00002bd8-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.sulfur_dioxide_concentration"),

  /// The default characteristic for Sulfur Hexafluoride Concentration
  sulfurHexafluorideConcentration(
      "Sulfur Hexafluoride Concentration",
      "2bd9",
      "00002bd9-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.sulfur_hexafluoride_concentration"),

  /// The default characteristic for Hearing Aid Features
  hearingAidFeatures(
      "Hearing Aid Features",
      "2bda",
      "00002bda-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.hearing_aid_features"),

  /// The default characteristic for Hearing Aid Preset Control Point
  hearingAidPresetControlPoint(
      "Hearing Aid Preset Control Point",
      "2bdb",
      "00002bdb-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.hearing_aid_preset_control_point"),

  /// The default characteristic for Active Preset Index
  activePresetIndex(
      "Active Preset Index",
      "2bdc",
      "00002bdc-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.active_preset_index"),

  /// The default characteristic for Stored Health Observations
  storedHealthObservations(
      "Stored Health Observations",
      "2bdd",
      "00002bdd-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.stored_health_observations"),

  /// The default characteristic for Fixed String 64
  fixedString64(
      "Fixed String 64",
      "2bde",
      "00002bde-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.fixed_string_64"),

  /// The default characteristic for High Temperature
  highTemperature(
      "High Temperature",
      "2bdf",
      "00002bdf-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.high_temperature"),

  /// The default characteristic for High Voltage
  highVoltage("High Voltage", "2be0", "00002be0-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.high_voltage"),

  /// The default characteristic for Light Distribution
  lightDistribution(
      "Light Distribution",
      "2be1",
      "00002be1-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.light_distribution"),

  /// The default characteristic for Light Output
  lightOutput("Light Output", "2be2", "00002be2-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.light_output"),

  /// The default characteristic for Light Source Type
  lightSourceType(
      "Light Source Type",
      "2be3",
      "00002be3-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.light_source_type"),

  /// The default characteristic for Noise
  noise("Noise", "2be4", "00002be4-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.noise"),

  /// The default characteristic for Relative Runtime in a Correlated Color Temperature Range
  relativeRuntimeInACorrelatedColorTemperatureRange(
      "Relative Runtime in a Correlated Color Temperature Range",
      "2be5",
      "00002be5-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.relative_runtime_in_a_correlated_color_temperature_range"),

  /// The default characteristic for Time Second 32
  timeSecond32("Time Second 32", "2be6", "00002be6-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.time_second_32"),

  /// The default characteristic for VOC Concentration
  vocConcentration(
      "VOC Concentration",
      "2be7",
      "00002be7-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.voc_concentration"),

  /// The default characteristic for Voltage Frequency
  voltageFrequency(
      "Voltage Frequency",
      "2be8",
      "00002be8-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.voltage_frequency"),

  /// The default characteristic for Battery Critical Status
  batteryCriticalStatus(
      "Battery Critical Status",
      "2be9",
      "00002be9-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.battery_critical_status"),

  /// The default characteristic for Battery Health Status
  batteryHealthStatus(
      "Battery Health Status",
      "2bea",
      "00002bea-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.battery_health_status"),

  /// The default characteristic for Battery Health Information
  batteryHealthInformation(
      "Battery Health Information",
      "2beb",
      "00002beb-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.battery_health_information"),

  /// The default characteristic for Battery Information
  batteryInformation(
      "Battery Information",
      "2bec",
      "00002bec-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.battery_information"),

  /// The default characteristic for Battery Level Status
  batteryLevelStatus(
      "Battery Level Status",
      "2bed",
      "00002bed-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.battery_level_status"),

  /// The default characteristic for Battery Time Status
  batteryTimeStatus(
      "Battery Time Status",
      "2bee",
      "00002bee-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.battery_time_status"),

  /// The default characteristic for Estimated Service Date
  estimatedServiceDate(
      "Estimated Service Date",
      "2bef",
      "00002bef-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.estimated_service_date"),

  /// The default characteristic for Battery Energy Status
  batteryEnergyStatus(
      "Battery Energy Status",
      "2bf0",
      "00002bf0-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.battery_energy_status"),

  /// The default characteristic for Observation Schedule Changed
  observationScheduleChanged(
      "Observation Schedule Changed",
      "2bf1",
      "00002bf1-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.observation_schedule_changed"),

  /// The default characteristic for Current Elapsed Time
  currentElapsedTime(
      "Current Elapsed Time",
      "2bf2",
      "00002bf2-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.current_elapsed_time"),

  /// The default characteristic for Health Sensor Features
  healthSensorFeatures(
      "Health Sensor Features",
      "2bf3",
      "00002bf3-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.health_sensor_features"),

  /// The default characteristic for GHS Control Point
  ghsControlPoint(
      "GHS Control Point",
      "2bf4",
      "00002bf4-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.ghs_control_point"),

  /// The default characteristic for LE GATT Security Levels
  leGattSecurityLevels(
      "LE GATT Security Levels",
      "2bf5",
      "00002bf5-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.le_gatt_security_levels"),

  /// The default characteristic for ESL Address
  eslAddress("ESL Address", "2bf6", "00002bf6-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.esl_address"),

  /// The default characteristic for AP Sync Key Material
  apSyncKeyMaterial(
      "AP Sync Key Material",
      "2bf7",
      "00002bf7-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.ap_sync_key_material"),

  /// The default characteristic for ESL Response Key Material
  eslResponseKeyMaterial(
      "ESL Response Key Material",
      "2bf8",
      "00002bf8-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.esl_response_key_material"),

  /// The default characteristic for ESL Current Absolute Time
  eslCurrentAbsoluteTime(
      "ESL Current Absolute Time",
      "2bf9",
      "00002bf9-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.esl_current_absolute_time"),

  /// The default characteristic for ESL Display Information
  eslDisplayInformation(
      "ESL Display Information",
      "2bfa",
      "00002bfa-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.esl_display_information"),

  /// The default characteristic for ESL Image Information
  eslImageInformation(
      "ESL Image Information",
      "2bfb",
      "00002bfb-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.esl_image_information"),

  /// The default characteristic for ESL Sensor Information
  eslSensorInformation(
      "ESL Sensor Information",
      "2bfc",
      "00002bfc-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.esl_sensor_information"),

  /// The default characteristic for ESL LED Information
  eslLedInformation(
      "ESL LED Information",
      "2bfd",
      "00002bfd-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.esl_led_information"),

  /// The default characteristic for ESL Control Point
  eslControlPoint(
      "ESL Control Point",
      "2bfe",
      "00002bfe-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.esl_control_point"),

  /// The default characteristic for UDI for Medical Devices
  udiForMedicalDevices(
      "UDI for Medical Devices",
      "2bff",
      "00002bff-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.medical_devices"),

  /// The default characteristic for GMAP Role
  gmapRole("GMAP Role", "2c00", "00002c00-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.gmap_role"),

  /// The default characteristic for UGG Features
  uggFeatures("UGG Features", "2c01", "00002c01-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.ugg_features"),

  /// The default characteristic for UGT Features
  ugtFeatures("UGT Features", "2c02", "00002c02-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.ugt_features"),

  /// The default characteristic for BGS Features
  bgsFeatures("BGS Features", "2c03", "00002c03-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.bgs_features"),

  /// The default characteristic for BGR Features
  bgrFeatures("BGR Features", "2c04", "00002c04-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.bgr_features"),

  /// The default characteristic for Percentage 8 Steps
  percentage8Steps(
      "Percentage 8 Steps",
      "2c05",
      "00002c05-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.percentage_8_steps"),

  /// The default characteristic for Acceleration
  acceleration("Acceleration", "2c06", "00002c06-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.acceleration"),

  /// The default characteristic for Force
  force("Force", "2c07", "00002c07-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.force"),

  /// The default characteristic for Linear Position
  linearPosition(
      "Linear Position",
      "2c08",
      "00002c08-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.linear_position"),

  /// The default characteristic for Rotational Speed
  rotationalSpeed(
      "Rotational Speed",
      "2c09",
      "00002c09-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.rotational_speed"),

  /// The default characteristic for Length
  length("Length", "2c0a", "00002c0a-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.length"),

  /// The default characteristic for Torque
  torque("Torque", "2c0b", "00002c0b-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.torque"),

  /// The default characteristic for IMD Status
  imdStatus("IMD Status", "2c0c", "00002c0c-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.imd_status"),

  /// The default characteristic for IMDS Descriptor Value Changed
  imdsDescriptorValueChanged(
      "IMDS Descriptor Value Changed",
      "2c0d",
      "00002c0d-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.imds_descriptor_value_changed"),

  /// The default characteristic for First Use Date
  firstUseDate("First Use Date", "2c0e", "00002c0e-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.first_use_date"),

  /// The default characteristic for Life Cycle Data
  lifeCycleData(
      "Life Cycle Data",
      "2c0f",
      "00002c0f-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.life_cycle_data"),

  /// The default characteristic for Work Cycle Data
  workCycleData(
      "Work Cycle Data",
      "2c10",
      "00002c10-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.work_cycle_data"),

  /// The default characteristic for Service Cycle Data
  serviceCycleData(
      "Service Cycle Data",
      "2c11",
      "00002c11-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.service_cycle_data"),

  /// The default characteristic for IMD Control
  imdControl("IMD Control", "2c12", "00002c12-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.imd_control"),

  /// The default characteristic for IMD Historical Data
  imdHistoricalData(
      "IMD Historical Data",
      "2c13",
      "00002c13-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.imd_historical_data"),

  /// The default characteristic for RAS Features
  rasFeatures("RAS Features", "2c14", "00002c14-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.ras_features"),

  /// The default characteristic for Real-time Ranging Data
  realTimeRangingData(
      "Real-time Ranging Data",
      "2c15",
      "00002c15-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.real-time_ranging_data"),

  /// The default characteristic for On-demand Ranging Data
  onDemandRangingData(
      "On-demand Ranging Data",
      "2c16",
      "00002c16-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.on-demand_ranging_data"),

  /// The default characteristic for RAS Control Point
  rasControlPoint(
      "RAS Control Point",
      "2c17",
      "00002c17-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.ras_control_point"),

  /// The default characteristic for Ranging Data Ready
  rangingDataReady(
      "Ranging Data Ready",
      "2c18",
      "00002c18-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.ranging_data_ready"),

  /// The default characteristic for Ranging Data Overwritten
  rangingDataOverwritten(
      "Ranging Data Overwritten",
      "2c19",
      "00002c19-0000-1000-8000-00805f9b34fb",
      "org.bluetooth.characteristic.ranging_data_overwritten");

  ///
  /// A characteristic UUID consists of a human readable name of the characteristic,
  /// its uuid represented as a 16 bit uuid and a full 128 bit uuid,
  /// and the id assigned by the Bluetooth SIG
  ///
  const BluetoothDefaultCharacteristicUUIDS(
    this.name,
    this.uuid16,
    this.uuid,
    this.id,
  );

  /// The name of the characteristic.
  final String name;

  /// The shorter 16 bit uuid of the characteristic.
  final String uuid16;

  /// The full uuid of the characteristic.
  final String uuid;

  /// The bluetooth ID of the service
  final String id;

  /// All non-deprecated characteristics.
  static const List<BluetoothDefaultCharacteristicUUIDS> characteristics = [
    deviceName,
    appearance,
    peripheralPrivacyFlag,
    reconnectionAddress,
    peripheralPreferredConnectionParameters,
    serviceChanged,
    alertLevel,
    txPowerLevel,
    dateTime,
    dayOfWeek,
    dayDateTime,
    exactTime256,
    dstOffset,
    timeZone,
    localTimeInformation,
    timeWithDst,
    timeAccuracy,
    timeSource,
    referenceTimeInformation,
    timeUpdateControlPoint,
    timeUpdateState,
    glucoseMeasurement,
    batteryLevel,
    temperatureMeasurement,
    temperatureType,
    intermediateTemperature,
    measurementInterval,
    bootKeyboardInputReport,
    systemId,
    modelNumberString,
    serialNumberString,
    firmwareRevisionString,
    hardwareRevisionString,
    softwareRevisionString,
    manufacturerNameString,
    ieee1107320601RegulatoryCertificationDataList,
    currentTime,
    magneticDeclination,
    scanRefresh,
    bootKeyboardOutputReport,
    bootMouseInputReport,
    glucoseMeasurementContext,
    bloodPressureMeasurement,
    intermediateCuffPressure,
    heartRateMeasurement,
    bodySensorLocation,
    heartRateControlPoint,
    alertStatus,
    ringerControlPoint,
    ringerSetting,
    alertCategoryIdBitMask,
    alertCategoryId,
    alertNotificationControlPoint,
    unreadAlertStatus,
    newAlert,
    supportedNewAlertCategory,
    supportedUnreadAlertCategory,
    bloodPressureFeature,
    hidInformation,
    reportMap,
    hidControlPoint,
    report,
    protocolMode,
    scanIntervalWindow,
    pnpId,
    glucoseFeature,
    recordAccessControlPoint,
    rscMeasurement,
    rscFeature,
    scControlPoint,
    aggregate,
    cscMeasurement,
    cscFeature,
    sensorLocation,
    plxSpotCheckMeasurement,
    plxContinuousMeasurement,
    plxFeatures,
    cyclingPowerMeasurement,
    cyclingPowerVector,
    cyclingPowerFeature,
    cyclingPowerControlPoint,
    locationAndSpeed,
    navigation,
    positionQuality,
    lnFeature,
    lnControlPoint,
    elevation,
    pressure,
    temperature,
    humidity,
    trueWindSpeed,
    trueWindDirection,
    apparentWindSpeed,
    apparentWindDirection,
    gustFactor,
    pollenConcentration,
    uvIndex,
    irradiance,
    rainfall,
    windChill,
    heatIndex,
    dewPoint,
    descriptorValueChanged,
    aerobicHeartRateLowerLimit,
    aerobicThreshold,
    age,
    anaerobicHeartRateLowerLimit,
    anaerobicHeartRateUpperLimit,
    anaerobicThreshold,
    aerobicHeartRateUpperLimit,
    dateOfBirth,
    dateOfThresholdAssessment,
    emailAddress,
    fatBurnHeartRateLowerLimit,
    fatBurnHeartRateUpperLimit,
    firstName,
    fiveZoneHeartRateLimits,
    gender,
    heartRateMax,
    height,
    hipCircumference,
    lastName,
    maximumRecommendedHeartRate,
    restingHeartRate,
    sportTypeForAerobicAndAnaerobicThresholds,
    threeZoneHeartRateLimits,
    twoZoneHeartRateLimits,
    vo2Max,
    waistCircumference,
    weight,
    databaseChangeIncrement,
    userIndex,
    bodyCompositionFeature,
    bodyCompositionMeasurement,
    weightMeasurement,
    weightScaleFeature,
    userControlPoint,
    magneticFluxDensity2d,
    magneticFluxDensity3d,
    language,
    barometricPressureTrend,
    bondManagementControlPoint,
    bondManagementFeature,
    centralAddressResolution,
    cgmMeasurement,
    cgmFeature,
    cgmStatus,
    cgmSessionStartTime,
    cgmSessionRunTime,
    cgmSpecificOpsControlPoint,
    indoorPositioningConfiguration,
    latitude,
    longitude,
    localNorthCoordinate,
    localEastCoordinate,
    floorNumber,
    altitude,
    uncertainty,
    locationName,
    uri,
    httpHeaders,
    httpStatusCode,
    httpEntityBody,
    httpControlPoint,
    httpsSecurity,
    tdsControlPoint,
    otsFeature,
    objectName,
    objectType,
    objectSize,
    objectFirstCreated,
    objectLastModified,
    objectId,
    objectProperties,
    objectActionControlPoint,
    objectListControlPoint,
    objectListFilter,
    objectChanged,
    resolvablePrivateAddressOnly,
    fitnessMachineFeature,
    treadmillData,
    crossTrainerData,
    stepClimberData,
    stairClimberData,
    rowerData,
    indoorBikeData,
    trainingStatus,
    supportedSpeedRange,
    supportedInclinationRange,
    supportedResistanceLevelRange,
    supportedHeartRateRange,
    supportedPowerRange,
    fitnessMachineControlPoint,
    fitnessMachineStatus,
    meshProvisioningDataIn,
    meshProvisioningDataOut,
    meshProxyDataIn,
    meshProxyDataOut,
    averageCurrent,
    averageVoltage,
    boolean,
    chromaticDistanceFromPlanckian,
    chromaticityCoordinates,
    chromaticityInCctAndDuvValues,
    chromaticityTolerance,
    cie1331995ColorRenderingIndex,
    coefficient,
    correlatedColorTemperature,
    count16,
    count24,
    countryCode,
    dateUtc,
    electricCurrent,
    electricCurrentRange,
    electricCurrentSpecification,
    electricCurrentStatistics,
    energy,
    energyInAPeriodOfDay,
    eventStatistics,
    fixedString16,
    fixedString24,
    fixedString36,
    fixedString8,
    genericLevel,
    globalTradeItemNumber,
    illuminance,
    luminousEfficacy,
    luminousEnergy,
    luminousExposure,
    luminousFlux,
    luminousFluxRange,
    luminousIntensity,
    massFlow,
    perceivedLightness,
    percentage8,
    power,
    powerSpecification,
    relativeRuntimeInACurrentRange,
    relativeRuntimeInAGenericLevelRange,
    relativeValueInAVoltageRange,
    relativeValueInAnIlluminanceRange,
    relativeValueInAPeriodOfDay,
    relativeValueInATemperatureRange,
    temperature8,
    temperature8InAPeriodOfDay,
    temperature8Statistics,
    temperatureRange,
    temperatureStatistics,
    timeDecihour8,
    timeExponential8,
    timeHour24,
    timeMillisecond24,
    timeSecond16,
    timeSecond8,
    voltage,
    voltageSpecification,
    voltageStatistics,
    volumeFlow,
    chromaticityCoordinate,
    rcFeature,
    rcSettings,
    reconnectionConfigurationControlPoint,
    iddStatusChanged,
    iddStatus,
    iddAnnunciationStatus,
    iddFeatures,
    iddStatusReaderControlPoint,
    iddCommandControlPoint,
    iddCommandData,
    iddRecordAccessControlPoint,
    iddHistoryData,
    clientSupportedFeatures,
    databaseHash,
    bssControlPoint,
    bssResponse,
    emergencyId,
    emergencyText,
    acsStatus,
    acsDataIn,
    acsDataOutNotify,
    acsDataOutIndicate,
    acsControlPoint,
    enhancedBloodPressureMeasurement,
    enhancedIntermediateCuffPressure,
    bloodPressureRecord,
    registeredUser,
    brEdrHandoverData,
    bluetoothSigData,
    serverSupportedFeatures,
    physicalActivityMonitorFeatures,
    generalActivityInstantaneousData,
    generalActivitySummaryData,
    cardiorespiratoryActivityInstantaneousData,
    cardiorespiratoryActivitySummaryData,
    stepCounterActivitySummaryData,
    sleepActivityInstantaneousData,
    sleepActivitySummaryData,
    physicalActivityMonitorControlPoint,
    physicalActivityCurrentSession,
    physicalActivitySessionDescriptor,
    preferredUnits,
    highResolutionHeight,
    middleName,
    strideLength,
    handedness,
    deviceWearingPosition,
    fourZoneHeartRateLimits,
    highIntensityExerciseThreshold,
    activityGoal,
    sedentaryIntervalNotification,
    caloricIntake,
    tmapRole,
    audioInputState,
    gainSettingsAttribute,
    audioInputType,
    audioInputStatus,
    audioInputControlPoint,
    audioInputDescription,
    volumeState,
    volumeControlPoint,
    volumeFlags,
    volumeOffsetState,
    audioLocation,
    volumeOffsetControlPoint,
    audioOutputDescription,
    setIdentityResolvingKey,
    coordinatedSetSize,
    setMemberLock,
    setMemberRank,
    encryptedDataKeyMaterial,
    apparentEnergy32,
    apparentPower,
    liveHealthObservations,
    co2Concentration,
    cosineOfTheAngle,
    deviceTimeFeature,
    deviceTimeParameters,
    deviceTime,
    deviceTimeControlPoint,
    timeChangeLogData,
    mediaPlayerName,
    mediaPlayerIconObjectId,
    mediaPlayerIconUrl,
    trackChanged,
    trackTitle,
    trackDuration,
    trackPosition,
    playbackSpeed,
    seekingSpeed,
    currentTrackSegmentsObjectId,
    currentTrackObjectId,
    nextTrackObjectId,
    parentGroupObjectId,
    currentGroupObjectId,
    playingOrder,
    playingOrdersSupported,
    mediaState,
    mediaControlPoint,
    mediaControlPointOpcodesSupported,
    searchResultsObjectId,
    searchControlPoint,
    energy32,
    constantToneExtensionEnable,
    advertisingConstantToneExtensionMinimumLength,
    advertisingConstantToneExtensionMinimumTransmitCount,
    advertisingConstantToneExtensionTransmitDuration,
    advertisingConstantToneExtensionInterval,
    advertisingConstantToneExtensionPhy,
    bearerProviderName,
    bearerUci,
    bearerTechnology,
    bearerUriSchemesSupportedList,
    bearerSignalStrength,
    bearerSignalStrengthReportingInterval,
    bearerListCurrentCalls,
    contentControlId,
    statusFlags,
    incomingCallTargetBearerUri,
    callState,
    callControlPoint,
    callControlPointOptionalOpcodes,
    terminationReason,
    incomingCall,
    callFriendlyName,
    mute,
    sinkAse,
    sourceAse,
    aseControlPoint,
    broadcastAudioScanControlPoint,
    broadcastReceiveState,
    sinkPac,
    sinkAudioLocations,
    sourcePac,
    sourceAudioLocations,
    availableAudioContexts,
    supportedAudioContexts,
    ammoniaConcentration,
    carbonMonoxideConcentration,
    methaneConcentration,
    nitrogenDioxideConcentration,
    nonMethaneVolatileOrganicCompoundsConcentration,
    ozoneConcentration,
    particulateMatterPm1Concentration,
    particulateMatterPm25Concentration,
    particulateMatterPm10Concentration,
    sulfurDioxideConcentration,
    sulfurHexafluorideConcentration,
    hearingAidFeatures,
    hearingAidPresetControlPoint,
    activePresetIndex,
    storedHealthObservations,
    fixedString64,
    highTemperature,
    highVoltage,
    lightDistribution,
    lightOutput,
    lightSourceType,
    noise,
    relativeRuntimeInACorrelatedColorTemperatureRange,
    timeSecond32,
    vocConcentration,
    voltageFrequency,
    batteryCriticalStatus,
    batteryHealthStatus,
    batteryHealthInformation,
    batteryInformation,
    batteryLevelStatus,
    batteryTimeStatus,
    estimatedServiceDate,
    batteryEnergyStatus,
    observationScheduleChanged,
    currentElapsedTime,
    healthSensorFeatures,
    ghsControlPoint,
    leGattSecurityLevels,
    eslAddress,
    apSyncKeyMaterial,
    eslResponseKeyMaterial,
    eslCurrentAbsoluteTime,
    eslDisplayInformation,
    eslImageInformation,
    eslSensorInformation,
    eslLedInformation,
    eslControlPoint,
    udiForMedicalDevices,
    gmapRole,
    uggFeatures,
    ugtFeatures,
    bgsFeatures,
    bgrFeatures,
    percentage8Steps,
    acceleration,
    force,
    linearPosition,
    rotationalSpeed,
    length,
    torque,
    imdStatus,
    imdsDescriptorValueChanged,
    firstUseDate,
    lifeCycleData,
    workCycleData,
    serviceCycleData,
    imdControl,
    imdHistoricalData,
    rasFeatures,
    realTimeRangingData,
    onDemandRangingData,
    rasControlPoint,
    rangingDataReady,
    rangingDataOverwritten
  ];

  /// All deprecated characteristics.
  @Deprecated(
      "This contains all deprecated characteristics and should thus not be relied on")
  static const List<BluetoothDefaultCharacteristicUUIDS>
      deprecatedCharacteristics = [];
}
