# Contributing

Thanks for taking the time to contribute!

The following is a set of guidelines for contributing to `flutter_pin_code_fields` package. These are mostly guidelines, not rules. Use your best judgment, and feel to propose changes to this document in a pull request.

## Reporting bugs

If you'd like to report a bug or open an issue:

1. Check if there is a current issue. If there is a current issue, please add any more information you have to it.
2. When submitting an issue, please describe it as clearly as possible, including steps to reproduce and current and expected behaviour.

## Your first code contribution

Unsure where to begin contributing? You can start by looking through `good first issue` and `help wanted` issues.

### Pull request

Please follow these steps to have you contribution considered:

1. Follow the [pull request template](PULL_REQUEST_TEMPLATE.md).
2. Follow the [commit guidelines](#commit-message-guidelines).
3. After you submit your pull request, verify that all the status checks are passing.

## Commit message guidelines

* Use present tense ("Add feature" not "Added feature")
* Use the imperative mood ("Move file to..." not "Moves file to...")
* Limit the first line to 70 characters or less.
* Reference issues and pull request after the first line.
