import 'package:dbus/dbus.dart';

/// An exception generated by the BlueZ server.
class BlueZException extends DBusMethodResponseException {
  /// Exception message as reported by BlueZ server.
  String get message =>
      response.values.isNotEmpty ? response.values[0].asString() : '';

  BlueZException(DBusMethodErrorResponse response) : super(response);
}

class BlueZInvalidArgumentsException extends BlueZException {
  BlueZInvalidArgumentsException(DBusMethodErrorResponse response)
      : super(response);
}

class BlueZInProgressException extends BlueZException {
  BlueZInProgressException(DBusMethodErrorResponse response) : super(response);
}

class BlueZAlreadyExistsException extends BlueZException {
  BlueZAlreadyExistsException(DBusMethodErrorResponse response)
      : super(response);
}

class BlueZNotSupportedException extends BlueZException {
  BlueZNotSupportedException(DBusMethodErrorResponse response)
      : super(response);
}

class BlueZNotConnectedException extends BlueZException {
  BlueZNotConnectedException(DBusMethodErrorResponse response)
      : super(response);
}

class BlueZAlreadyConnectedException extends BlueZException {
  BlueZAlreadyConnectedException(DBusMethodErrorResponse response)
      : super(response);
}

class BlueZNotAvailableException extends BlueZException {
  BlueZNotAvailableException(DBusMethodErrorResponse response)
      : super(response);
}

class BlueZDoesNotExistException extends BlueZException {
  BlueZDoesNotExistException(DBusMethodErrorResponse response)
      : super(response);
}

class BlueZNotAuthorizedException extends BlueZException {
  BlueZNotAuthorizedException(DBusMethodErrorResponse response)
      : super(response);
}

class BlueZNotPermittedException extends BlueZException {
  BlueZNotPermittedException(DBusMethodErrorResponse response)
      : super(response);
}

class BlueZNoSuchAdapterException extends BlueZException {
  BlueZNoSuchAdapterException(DBusMethodErrorResponse response)
      : super(response);
}

class BlueZAgentNotAvailableException extends BlueZException {
  BlueZAgentNotAvailableException(DBusMethodErrorResponse response)
      : super(response);
}

class BlueZNotReadyException extends BlueZException {
  BlueZNotReadyException(DBusMethodErrorResponse response) : super(response);
}

class BlueZFailedException extends BlueZException {
  BlueZFailedException(DBusMethodErrorResponse response) : super(response);
}

class BlueZAuthenticationCanceledException extends BlueZException {
  BlueZAuthenticationCanceledException(DBusMethodErrorResponse response)
      : super(response);
}

class BlueZAuthenticationFailedException extends BlueZException {
  BlueZAuthenticationFailedException(DBusMethodErrorResponse response)
      : super(response);
}

class BlueZAuthenticationRejectedException extends BlueZException {
  BlueZAuthenticationRejectedException(DBusMethodErrorResponse response)
      : super(response);
}

class BlueZAuthenticationTimeoutException extends BlueZException {
  BlueZAuthenticationTimeoutException(DBusMethodErrorResponse response)
      : super(response);
}
