#pragma once

/**
** \defgroup ssb_rpc SSB RPC
** Implementations of all the necessary MUXRPC handlers (createHistoryStream,
** ebt.replicate, blobs.get, ...).
** @{
*/

/** An SSB instance. */
typedef struct _tf_ssb_t tf_ssb_t;

/**
** Register standard muxrpc callbacks.
** @param ssb The SSB instance.
*/
void tf_ssb_rpc_register(tf_ssb_t* ssb);

/**
** Start periodic SSB maintenance tasks.
** @param ssb The SSB instance.
*/
void tf_ssb_rpc_start_periodic(tf_ssb_t* ssb);

/** @} */
