#pragma once

/**
** \defgroup tf_import Tilde Friends Import
** Support for importing Tilde Friends apps from disk to the database.
**
** I don't know why it has SSB in the name.
** @{
*/

/** An SSB instance. */
typedef struct _tf_ssb_t tf_ssb_t;

/**
** Import apps in a directory to a user's account.
** @param ssb The SSB instance.
** @param user The username.
** @param path The on-disk path of the apps.
*/
void tf_ssb_import(tf_ssb_t* ssb, const char* user, const char* path);

/**
** Import apps from a zip file to a user's account.
** @param ssb The SSB instance.
** @param zip_path The path to the zip file on disk.
** @param user The user into whose account the apps will be imported.
** @param path The path in the zip to the apps.
*/
void tf_ssb_import_from_zip(tf_ssb_t* ssb, const char* zip_path, const char* user, const char* path);

/** @} */
