#pragma once

/**
** \defgroup ssb_connections SSB Connections
** Primitive tracking for SSB connections, as in we tried to connect to host X
** Y seconds ago, and it failed.  This needs to be replaced with something better.
** @{
*/

/** An SSB instance. */
typedef struct _tf_ssb_t tf_ssb_t;

/** An SSB connections tracker instance. */
typedef struct _tf_ssb_connections_t tf_ssb_connections_t;

/**
** Create a connection tracker.
** @param ssb The SSB instance.
** @return The connection tracker instance.
*/
tf_ssb_connections_t* tf_ssb_connections_create(tf_ssb_t* ssb);

/**
** Destroy a connection tracker.
** @param connections The connection tracker to destroy.
*/
void tf_ssb_connections_destroy(tf_ssb_connections_t* connections);

/**
** Store a connection in the connection tracker.
** @param connections The connection tracker.
** @param host The host name or address.
** @param port The network port number.
** @param key The identity on the other end of the connection.
*/
void tf_ssb_connections_store(tf_ssb_connections_t* connections, const char* host, int port, const char* key);

/**
** Record that a connection was recently attempted.
** @param connections The connection tracker.
** @param host The host name or address.
** @param port The network port number.
** @param key The identity on the other end of the connection.
*/
void tf_ssb_connections_set_attempted(tf_ssb_connections_t* connections, const char* host, int port, const char* key);

/**
** Record that a connection recently succeeded.
** @param connections The connection tracker.
** @param host The host name or address.
** @param port The network port number.
** @param key The identity on the other end of the connection.
*/
void tf_ssb_connections_set_succeeded(tf_ssb_connections_t* connections, const char* host, int port, const char* key);

/**
** Initiate an immediate sync.
** @param connections The connections tracker.
*/
void tf_ssb_connections_sync_start(tf_ssb_connections_t* connections);

/** @} */
