#pragma once

/**
** \defgroup serialize JS binary serialization
** Converts JS data to a basic binary format with support for exporting
** functions so that they can be called across the barrier, too.
** @{
*/

#include "quickjs.h"

/** A task. */
typedef struct _tf_task_t tf_task_t;
/** A handle to a remote task. */
typedef struct _tf_taskstub_t tf_taskstub_t;

/**
** Store JS data in a binary blob.
** @param task The calling task.
** @param to The handle to the task to which the data will be sent.
** @param[out] out_buffer Populated with the stored data.
** @param[out] out_size Populated with the size of out_data.
** @param value The JS value to store.
*/
void tf_serialize_store(tf_task_t* task, tf_taskstub_t* to, void** out_buffer, size_t* out_size, JSValue value);

/**
** Retrieve JS data from a binary blob.
** @param task The calling task.
** @param from The handle to the task from which the data was received.
** @param buffer The data.
** @param size The size of the data.
** @return The received JS data.
*/
JSValue tf_serialize_load(tf_task_t* task, tf_taskstub_t* from, const char* buffer, size_t size);

/** @} */
