#pragma once

/**
** \defgroup bip39 BIP39
** Convert between raw bytes and \ref bip39_words.
** See: https://github.com/bitcoin/bips/blob/master/bip-0039.mediawiki.
** @{
*/

#include <stdbool.h>
#include <stddef.h>
#include <stdint.h>

/**
** Convert a key from bytes to words.
** @param bytes A raw binary representation of a key.
** @param bytes_size The size of bytes.
** @param[out] out_words A human-readable English word representation of a key.
** @param words_size The size of the out_words buffer.
** @return True if the key was successfully converted.
*/
bool tf_bip39_bytes_to_words(const uint8_t* bytes, size_t bytes_size, char* out_words, size_t words_size);

/**
** Convert a key from words to bytes.
** @param words A space-separated list of English words forming a key.
** @param[out] out_bytes A buffer to receive the raw binary form of the key.
** @param bytes_size The size of the out_bytes buffer.
** @return True if the key was successfully converted.
*/
bool tf_bip39_words_to_bytes(const char* words, uint8_t* out_bytes, size_t bytes_size);

/** @} */
