@page vision Vision

Tilde Friends is a tool for making and sharing.

It is both a peer-to-peer social network client, participating in Secure
Scuttlebutt, and an environment for creating and running web applications.

## Why

This is a thing that I wanted to exist and wanted to work on. No other reason.
There is not a business model. I believe it is interesting and unique.

## Goals

1. Make it **easy and fun** to run all sorts of web applications.

2. Provide **security** that is easy to understand and protects your data.

3. Make **creating and sharing** web applications accessible to anyone with a
   browser.

## Ways to Use Tilde Friends

1. **Social Network User**: This is a social network first. You are just here,
   because your friends are. Or you like how we limit your message length or
   short videos or whatever the trend is. If you are ambitious, you click links
   and see interactive experiences (apps) that you wouldn't see elsewhere.

2. **Web Visitor**: You get links from a friend to meeting invites, polls, games,
   lists, wiki pages, ..., and you interact with them as though they were
   cloud-hosted by a megacorporation. They just work, and you don't think twice.

3. **Group leader**: You host or use a small public instance, installing apps for
   a group of friends to use as web visitors.

4. **Developer**: You like to write code and make or improve apps for fun or to
   solve problems. When you encounter a Tilde Friends app on a strange server,
   you know you can trivially modify it or download it to your own instance.

## Future Goals / Endgame

1. Mobile apps. This can run on your old phone. Maybe you won't be hosting
   the web interface publicly, but you can sync, install and edit apps, and
   otherwise get the full experience from a tiny touch screen.

2. The universal application runtime. The web browser is the universal
   platform, but even for the simplest application that you might want to host
   for your friends, cloud hosting, containers, and complicated dependencies might
   all enter the mix. Tilde Friends, though it is yet another thing to host,
   includes everything you need out of the box to run a vast variety of interesting
   apps.

   Tilde Friends will be built out, gradually providing safe access to host
   resources and client resources the same way web browsers extended access to
   resources like GPU, persistent storage, cameras, ... over the years.

   Not much effort has been put forward yet to having a robust, long-lasting API,
   but since the client side longevity is already handled by web browsers, it
   seems possible that the server-side API can be managed in a similar way.

3. An awesome development environment. Right now it runs JavaScript from the
   first embeddable text editor I could poorly configure enough to edit code,
   but it could incorporate a debugger, source control integration a la ssb-git,
   merge tools, and transpiling from all sorts of different languages.
