# CLI Usage

## tildefriends -h

```
Usage: out/debug/tildefriends command [command-options]
commands:
  run - Run tildefriends (default).
  sandbox - Run a sandboxed tildefriends sandbox process (used internally).
  import - Import apps from file to the database.
  export - Export apps from the database to file.
  publish - Append a message to a feed.
  private - Append a private post message to a feed.
  create_invite - Create an invite.
  get_sequence - Get the last sequence number for a feed.
  get_identity - Get the server account identity.
  get_profile - Get profile information for the given identity.
  get_contacts - Get information about followed, blocked, and friend identities.
  has_blob - Check whether a blob is in the blob store.
  get_blob - Read a file from the blob store.
  store_blob - Write a file to the blob store.
  verify - Verify a feed.
  test - Test SSB.
```

## tildefriends run -h

```

Usage: out/debug/tildefriends run [options]

Run tildefriends (default).

options:
  -s, --script script        Script to run (default: core/core.js).
  -d, --db-path path         SQLite database path (default: /home/cory/.local/share/tildefriends/db.sqlite).
  -k, --ssb-network-key key  SSB network key to use.
  -n, --count count          Number of instances to run.
  -a, --args args            Arguments of the format key=value,foo=bar,verbose=true (note: these are persisted to the database).
                                 code_of_conduct (default: ""): Code of conduct presented at sign-in.
                                 ssb_port (default: 8008): Port on which to listen for SSB secure handshake connections.
                                 http_local_only (default: false): Whether to bind http(s) to the loopback address.  Otherwise any.
                                 http_port (default: 12345): Port on which to listen for HTTP connections.
                                 out_http_port_file (default: ""): File to which to write bound HTTP port.
                                 blob_fetch_age_seconds (default: -1): Only blobs mentioned more recently than this age will be automatically fetched.
                                 blob_expire_age_seconds (default: -1): Blobs older than this will be automatically deleted.
                                 http_redirect (default: ""): If connecting by HTTP and HTTPS is configured, Location header prefix (ie, "http://example.com")
                                 index (default: "/~core/intro/"): Default path.
                                 index_map (default: ""): Mappings from hostname to redirect path, one per line, as in: "www.tildefriends.net=/~core/index/"
                                 peer_exchange (default: false): Enable discovery of, sharing of, and connecting to internet peer strangers, including announcing this instance.
                                 replicator (default: true): Enable message and blob replication.
                                 room (default: true): Enable peers to tunnel through this instance as a room.
                                 room_name (default: "tilde friends tunnel"): Name of the room.
                                 seeds_host (default: "seeds.tildefriends.net"): Hostname for seed connections.
                                 account_registration (default: true): Allow registration of new accounts.
                                 replication_hops (default: 2): Number of hops to replicate (1 = direct follows, 2 = follows of follows, etc.).
                                 delete_stale_feeds (default: false): Periodically delete feeds that aren't visible from local accounts or related follows.
                                 talk_to_strangers (default: true): Whether connections are accepted from accounts that aren't in the replication range or otherwise already known.
                                 autologin (default: false): Whether mobile autologin is supported.
                                 broadcast (default: true): Send network discovery broadcasts.
                                 discovery (default: true): Receive network discovery broadcasts.
                                 stay_connected (default: false): Whether to attempt to keep several peer connections open.
                                 accepted_eula_version (default: 0): The version of the last accepted EULA.
  -o, --one-proc             Run everything in one process (unsafely!).
  -z, --zip path             Zip archive from which to load files.
  -v, --verbose              Log raw messages.
  -h, --help                 Show this usage information.
```

## tildefriends sandbox -h

```

Usage: out/debug/tildefriends sandbox [options]

Run a sandboxed tildefriends sandbox process (used internally).

options:
  -h, --help    Show this usage information.
  -f, --fd      File descriptor with which to communicate with parent process.
```

## tildefriends import -h

```

Usage: out/debug/tildefriends import [options] [paths...]

Import apps from file to the database.

options:
  -u, --user user          User into whose account apps will be imported (default: "import").
  -d, --db-path db_path    SQLite database path (default: /home/cory/.local/share/tildefriends/db.sqlite).
  -h, --help               Show this usage information.
```

## tildefriends export -h

```

Usage: out/debug/tildefriends export [options] [paths...]

Export apps from the database to file.

options:
  -u, --user user          User from whose account apps will be exported (default: "core").
  -d, --db-path db_path    SQLite database path (default: /home/cory/.local/share/tildefriends/db.sqlite).
  -h, --help               Show this usage information.

paths                      Paths of apps to export (example: /~core/ssb /~user/app).
```

## tildefriends publish -h

```

Usage: out/debug/tildefriends publish [options]

Append a message to a feed.

options:
  -u, --user user          User owning identity with which to publish.
  -i, --id identity        Identity with which to publish message.
  -d, --db-path db_path    SQLite database path (default: /home/cory/.local/share/tildefriends/db.sqlite).
  -c, --content json       JSON content of message to publish.
  -h, --help               Show this usage information.
```

## tildefriends private -h

```

Usage: out/debug/tildefriends private [options]

Append a private post message to a feed.

options:
  -u, --user user              User owning identity with which to publish (optional).
  -i, --id identity            Identity with which to publish message.
  -r, --recipients recipients  Recipient identities.
  -d, --db-path db_path        SQLite database path (default: /home/cory/.local/share/tildefriends/db.sqlite).
  -t, --text text              Private post text.
  -h, --help                   Show this usage information.
```

## tildefriends create_invite -h

```

Usage: out/debug/tildefriends create_invite [options]

Create an invite.

options:
  -d, --db-path db_path    SQLite database path (default: /home/cory/.local/share/tildefriends/db.sqlite).
  -i, --identity identity  Account from which to get latest sequence number.
  -a, --address address    Address to which the recipient will connect.
  -p, --port port          Port to which the recipient will connect.
  -u, --use_count count    Number of times this invite may be used (default: 1).
  -e, --expires seconds    How long this invite is valid in seconds (-1 for indefinitely, default: 1 hour).
  -h, --help               Show this usage information.
```

## tildefriends get_sequence -h

```

Usage: out/debug/tildefriends get_sequence [options]

Get the last sequence number for a feed.

options:
  -d, --db-path db_path    SQLite database path (default: /home/cory/.local/share/tildefriends/db.sqlite).
  -i, --identity identity  Account from which to get latest sequence number.
  -h, --help               Show this usage information.
```

## tildefriends get_identity -h

```

Usage: out/debug/tildefriends get_identity [options]

Get the server account identity.

options:
  -d, --db-path db_path    SQLite database path (default: /home/cory/.local/share/tildefriends/db.sqlite).
  -h, --help               Show this usage information.
```

## tildefriends get_profile -h

```

Usage: out/debug/tildefriends get_profile [options]

Get profile information for the given identity.

options:
  -d, --db-path db_path    SQLite database path (default: /home/cory/.local/share/tildefriends/db.sqlite).
  -i, --identity identity  Account for which to get profile information.
  -h, --help               Show this usage information.
```

## tildefriends get_contacts -h

```

Usage: out/debug/tildefriends get_contacts [options]

Get information about followed, blocked, and friend identities.

options:
  -d, --db-path db_path    SQLite database path (default: /home/cory/.local/share/tildefriends/db.sqlite).
  -i, --identity identity  Account from which to get contact information.
  -h, --help               Show this usage information.
```

## tildefriends has_blob -h

```

Usage: out/debug/tildefriends has_blob [options]

Check whether a blob is in the blob store.

options:
  -d, --db-path db_path    SQLite database path (default: /home/cory/.local/share/tildefriends/db.sqlite).
  -b, --blob_id blob_id    ID of blob to query.
  -h, --help               Show this usage information.
```

## tildefriends get_blob -h

```

Usage: out/debug/tildefriends get_blob [options]

Read a file from the blob store.

options:
  -d, --db-path db_path    SQLite database path (default: /home/cory/.local/share/tildefriends/db.sqlite).
  -b, --blob blob_id       Blob identifier to retrieve.
  -o, --output file_path   Location to write the retrieved blob.
  -h, --help               Show this usage information.
```

## tildefriends store_blob -h

```

Usage: out/debug/tildefriends store_blob [options]

Write a file to the blob store.

options:
  -d, --db-path db_path    SQLite database path (default: /home/cory/.local/share/tildefriends/db.sqlite).
  -f, --file file_path     Path to file to add to the blob store.
  -h, --help               Show this usage information.
```

## tildefriends verify -h

```

Usage: out/debug/tildefriends verify [options]

Verify a feed.

options:
  -i, --identity identity  Identity to verify.
  -s, --sequence sequence  Sequence number to debug.
  -d, --db-path db_path    SQLite database path (default: /home/cory/.local/share/tildefriends/db.sqlite).
  -h, --help               Show this usage information.
```

## tildefriends test -h

```

Usage: out/debug/tildefriends test [options]

Test SSB.

options:
  -t, --tests tests      Comma-separated list of tests to run.  (default: all)
  -h, --help             Show this usage information.
```
