@page app_development_cheat_sheet App Development Cheat Sheet

Making apps for the impatient tilde friend.

## Prerequisites

- either run your own instance or use [tildefriends.net](https://www.tildefriends.net/)
- register and login
- [optional] use the `ssb` app to create yourself an SSB identity

## Development Process

1.  hit the `edit` link from any app or new app URL
2.  make sure the path in the text box is under your username: `/~username/app/`
3.  write server-side code in `app.js`
4.  click the `save` button or press the save hotkey (Alt+S or _[browser-specific modifiers]_+S)
5.  see the app reload on the right side

## Output

- `app.setDocument(html)` - send HTML to the browser
- `print(...)` - send values to the browser's developer console

## Persistence

- `app.localStorageGet(key)` -> `value`
- `app.localStorageSet(key, value)`
- `database()`, `shared_database(key)`, `my_shared_database(package, key)`
  - `db.get(key)` -> `value`
  - `db.set(key, value)`
  - `db.exchange(key, expected, value)` -> `exchanged`
  - `db.remove(key)`
  - `db.getAll()` -> `[key1, ...]`
  - `db.getLike(pattern)` -> `{key1: value1, ...}`

## SSB

- `ssb.createIdentity()` -> `id`
- `ssb.getIdentities()` -> `[id1, ...]`
- `ssb.appendMessageWithIdentity(id, content)` -> `message_id`
- `ssb.blobStore(blob)` -> `blob_id`
- `ssb.blobGet(id)` -> `blob`
- `ssb.sqlAsync(query, args, row_callback)`

## TF-RPC

Stock helper code for calling functions across the web server and browser boundary.

- on the server: `import * as tfrpc from "/tfrpc.js";`
- in the browser: `import * as tfrpc from "/static/tfrpc.js";`
- either direction:
  - register a function: `tfrpc.register(function my_function() {});`
  - call a remote function: `let promise = tfrpc.rpc.my_function();`

## Share

- give out web links: [https://www.tildefriends.net/~cory/screwble/](https://www.tildefriends.net/~cory/screwble/)
- use the `Attach App` button when composing a post in [the SSB app](https://www.tildefriends.net/~core/ssb/)

## More Docs

- [api reference](https://www.tildefriends.net/~cory/api/)
- [source code](https://dev.tildefriends.net/cory/tildefriends/releases)
