# How to upgrade to a newer version
# - On the june and december release, you'll have to update nixpkgs to the current branch
# Change `nixpkgs.url = "github:NixOS/nixpkgs/nixos-24.11";`
# to the latest release (see https://nixos.org/)
# - Run `$ nix flake update`
# - Comment `src.hash`
# - Change `version`
# - Run `$ nix build`
# This will fetch the source code
# Since `hash` is not provided, nix will stop building and throw an error:
#
# error: hash mismatch in fixed-output derivation '/nix/store/fghi3ljs6fhz8pwm3dh73j5fwjpq5wbz-source.drv':
#          specified: sha256-AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA=
#             got:    sha256-+uthA1w8CmZfW+WOK9wYGl2fUl/k10ufOc8W+Pwa9iQ=
# error: 1 dependencies of derivation '/nix/store/imcwsw5r74vkd8r0qa2k7cys2xfgraaz-tildefriends-0.0.18.drv' failed to build
#
# - Change `src.hash` to the new one, ie `sha256-+uthA1w8CmZfW+WOK9wYGl2fUl/k10ufOc8W+Pwa9iQ=`
# - Uncomment `src.hash`
# - Build again, this time it should work.
# - Check the release notes, if there's a new dependency or a change to `GNUMakefile`, this file might need to be changed too.
# For more details, contact tasiaiso @ https://tilde.club/~tasiaiso/
{
  pkgs ? import <nixpkgs> {},
  lib ? import <nixpkgs/lib>,
}:
pkgs.stdenv.mkDerivation rec {
  pname = "tildefriends";
  version = "0.2025.11";

  src = pkgs.fetchFromGitea {
    domain = "dev.tildefriends.net";
    owner = "cory";
    repo = "tildefriends";
    rev = "v${version}";
    hash = "sha256-z4v4ghKOBTMv+agTUKg+HU8zfE4imluXFsozQCT4qX8=";
    fetchSubmodules = true;
  };

  nativeBuildInputs = with pkgs; [
    glibc
    gnumake
    openssl
    which
  ];

  buildInputs = with pkgs; [
    glibc
    openssl
    which
  ];

  buildPhase = ''
    make -j $NIX_BUILD_CORES release USE_SYSTEM_SSL=1
  '';

  installPhase = ''
    mkdir -p $out/bin
    cp -r out/release/tildefriends $out/bin
  '';

  doCheck = false;

  meta = with pkgs; {
    homepage = "https://tildefriends.net";
    description = "Make apps and friends from the comfort of your web browser.";
    mainProgram = "tildefriends";
    license = with lib.licenses; [mit];
    platforms = lib.platforms.all;
  };
}
