import * as utils from './utils.js';
import * as commonmark from './commonmark.min.js';

function markdown(md) {
	let reader = new commonmark.Parser();
	let writer = new commonmark.HtmlRenderer({safe: true});
	let parsed = reader.parse(md || '');
	let walker = parsed.walker();
	let event;
	while ((event = walker.next())) {
		let node = event.node;
		if (event.entering) {
			if (node.destination?.startsWith('&')) {
				node.destination =
					'/' + node.destination + '/view?filename=' + node.firstChild?.literal;
			} else if (node.type === 'link') {
				if (
					node.destination.indexOf(':') == -1 &&
					node.destination.indexOf('/') == -1
				) {
					node.destination = `${node.destination}`;
				}
			}
		}
	}
	return writer.render(parsed);
}

async function main() {
	let slash = request.path.indexOf('/');
	if (slash != -1) {
		let wiki_name = request.path.substring(0, slash);
		let wiki_doc_name = request.path.substring(slash + 1);

		let ids = Object.keys(
			await ssb.following(await ssb.getOwnerIdentities(), 1)
		);
		let [max_row_id, wikis] = await utils.collection(ids, 'wiki', null, -1, {});
		let wiki;
		for (let w of Object.values(wikis)) {
			if (w.name === wiki_name && !w.tombstone) {
				wiki = w;
				break;
			}
		}
		let wiki_doc;
		if (wiki) {
			let [max_row_id, wiki_docs] = await utils.collection(
				ids,
				'wiki-doc',
				wiki.id,
				-1,
				{}
			);
			for (let w of Object.values(wiki_docs)) {
				if (w.name === wiki_doc_name && !w.tombstone) {
					wiki_doc = w;
					break;
				}
			}
		}

		let md;
		if (wiki_doc?.blob) {
			md = utf8Decode(await ssb.blobGet(wiki_doc.blob));
		}

		await respond({
			data: `
				<h1>${wiki_name}: ${wiki_doc_name}</h1>
				<div>${markdown(md)}</div>
			`,
			content_type: 'text/html; charset=utf-8',
			status_code: 200,
		});
	} else {
		await respond({
			data: '<h1>File not found</h1>',
			content_type: 'text/html',
			status_code: 404,
		});
	}
}
main();
