import {LitElement, html, unsafeHTML} from './lit-all.min.js';
import {styles, generate_theme} from './tf-styles.js';

class TfReactionsModalElement extends LitElement {
	static get properties() {
		return {
			users: {type: Object},
			votes: {type: Array},
		};
	}

	static styles = styles;

	constructor() {
		super();
		this.votes = [];
		this.users = {};
	}

	clear() {
		this.votes = [];
	}

	render() {
		let self = this;
		return this.votes?.length
			? html` <style>
						${generate_theme()}
					</style>
					<div
						class="w3-modal w3-animate-opacity"
						style="display: block; box-sizing: border-box; z-index: 10"
						@click=${this.clear}
					>
						<div
							class="w3-modal-content w3-card-4 w3-theme-d1"
							onclick="event.stopPropagation()"
						>
							<div class="w3-container w3-padding">
								<header class="w3-container">
									<h2>Reactions</h2>
									<span
										class="w3-button w3-display-topright"
										@click=${this.clear}
										>&times;</span
									>
								</header>
								<ul class="w3-theme-dark w3-container w3-ul">
									${this.votes
										.sort((x, y) => y.timestamp - x.timestamp)
										.map(
											(x) => html`
												<li
													style="display: flex; flex-direction: row; gap: 4px"
												>
													<span style="flex-basis: 3em"
														>${x?.content?.vote?.expression}</span
													>
													<tf-user
														style="flex: 1 1; overflow: hidden"
														id=${x.author}
														.users=${this.users}
													></tf-user>
													<span
														style="flex-shrink: 1; white-space: nowrap; overflow: hidden; text-overflow: ellipsis"
														>${new Date(x?.timestamp).toLocaleString()}</span
													>
												</li>
											`
										)}
								</ul>
								<footer class="w3-container w3-padding">
									<button class="w3-button" @click=${this.clear}>Close</button>
								</footer>
							</div>
						</div>
					</div>`
			: undefined;
	}
}

customElements.define('tf-reactions-modal', TfReactionsModalElement);
