import {LitElement, html} from './lit-all.min.js';
import * as tfrpc from '/static/tfrpc.js';

/*
 ** Provide a list of IDs, and this lets the user pick one.
 */
class TfIdentityPickerElement extends LitElement {
	static get properties() {
		return {
			ids: {type: Array},
			selected: {type: String},
		};
	}

	constructor() {
		super();
		this.ids = [];
	}

	changed(event) {
		this.selected = event.srcElement.value;
		this.dispatchEvent(
			new Event('change', {
				srcElement: this,
			})
		);
	}

	render() {
		return html`
			<select @change=${this.changed} style="max-width: 100%">
				${(this.ids ?? []).map(
					(id) =>
						html`<option ?selected=${id == this.selected} value=${id}>
							${id}
						</option>`
				)}
			</select>
		`;
	}
}

customElements.define('tf-id-picker', TfIdentityPickerElement);
