import * as commonmark from './commonmark.min.js';
import {unsafeHTML} from './lit-all.min.js';

function image(node, entering) {
	if (
		node.firstChild?.type === 'text' &&
		node.firstChild.literal.startsWith('video:')
	) {
		if (entering) {
			this.lit(
				'<video style="max-width: 100%; max-height: 480px" title="' +
					this.esc(node.firstChild?.literal) +
					'" controls>'
			);
			this.lit('<source src="' + this.esc(node.destination) + '"></source>');
			this.disableTags += 1;
		} else {
			this.disableTags -= 1;
			this.lit('</video>');
		}
	} else if (
		node.firstChild?.type === 'text' &&
		node.firstChild.literal.startsWith('audio:')
	) {
		if (entering) {
			this.lit(
				'<audio style="height: 32px; max-width: 100%" title="' +
					this.esc(node.firstChild?.literal) +
					'" controls>'
			);
			this.lit('<source src="' + this.esc(node.destination) + '"></source>');
			this.disableTags += 1;
		} else {
			this.disableTags -= 1;
			this.lit('</audio>');
		}
	} else {
		if (entering) {
			if (this.disableTags === 0) {
				this.lit(
					'<div class="img_caption">' +
						this.esc(node.firstChild?.literal || node.destination) +
						'</div>'
				);
				if (this.options.safe && potentiallyUnsafe(node.destination)) {
					this.lit('<img src="" title="');
				} else {
					this.lit('<img src="' + this.esc(node.destination) + '" title="');
				}
			}
			this.disableTags += 1;
		} else {
			this.disableTags -= 1;
			if (this.disableTags === 0) {
				if (node.title) {
					this.lit('" title="' + this.esc(node.title));
				}
				this.lit('" />');
			}
		}
	}
}

function code(node) {
	let attrs = this.attrs(node);
	attrs.push(['class', k_code_classes]);
	this.tag('code', attrs);
	this.out(node.literal);
	this.tag('/code');
}

function attrs(node) {
	let result = commonmark.HtmlRenderer.prototype.attrs.bind(this)(node);
	if (node.type == 'block_quote') {
		result.push(['class', 'w3-theme-d1']);
	} else if (node.type == 'code_block') {
		result.push(['class', k_code_classes]);
	}
	return result;
}

export function markdown(md) {
	let reader = new commonmark.Parser();
	let writer = new commonmark.HtmlRenderer({safe: true});
	writer.image = image;
	writer.code = code;
	writer.attrs = attrs;
	let parsed = reader.parse(md || '');
	let walker = parsed.walker();
	let event, node;
	while ((event = walker.next())) {
		node = event.node;
		if (event.entering) {
			if (node.type == 'link') {
				if (
					node.destination.startsWith('@') &&
					node.destination.endsWith('.ed25519')
				) {
					node.destination = '#' + encodeURIComponent(node.destination);
				} else if (
					node.destination.startsWith('%') &&
					node.destination.endsWith('.sha256')
				) {
					node.destination = '#' + encodeURIComponent(node.destination);
				} else if (
					node.destination.startsWith('&') &&
					node.destination.endsWith('.sha256')
				) {
					node.destination = '/' + node.destination + '/view';
				}
			} else if (node.type == 'image') {
				if (node.destination.startsWith('&')) {
					node.destination = '/' + node.destination + '/view';
				}
			}
		}
	}
	return unsafeHTML(writer.render(parsed));
}
