import {LitElement, html, map, unsafeHTML} from './lit-all.min.js';
import {markdown} from './markdown.js';

class BookClubElement extends LitElement {
	render() {
		if (!g_data?.length) {
			return html`<h1>No bookclub messages to display.</h1>`;
		}
		return html`
			<link rel="stylesheet" href="w3.css"></link>
			<div class="w3-grid" style="background-color: #fff; gap:8px; grid-template-columns: repeat(auto-fit, minmax(400px, 1fr))">
				${map(
					g_data,
					(x) => html`
						<div class="w3-card-4">
							<header class="w3-container w3-center">
								<h1>${markdown(x.title)}</h1>
								<p>${map(x.authors, (author) => markdown(author))}</p>
							</header>
							<div class="w3-container w3-center">
								<img
									src="/${x.image}/view"
									style="max-height: 2in; max-width: 2in"
								/>
							</div>
							<div class="w3-container">
								<p>${markdown(x.description)}</p>
							</div>
							<ul class="w3-container w3-list">
								${map(
									x.reviews.filter(
										(x) => x.content?.rating || x.content?.review
									),
									(review) => html`
										<li>
											${review.content.rating} /
											${review.content.ratingMax ?? 5}
											${review.content.ratingType ?? 'stars'}
											<div>${review.content.review}</div>
										</li>
									`
								)}
							</ul>
						</div>
					`
				)}
			</div>`;
	}
}

customElements.define('bc-app', BookClubElement);
