export const docs = {};

docs.global = `# Tilde Friends API Documentation

Welcome to the Tilde Friends API documentation.

 * [App Globals](#App_Globals)
 * [Database Interface](#Database)
 * [Remote Procedure Calls](#tfrpc)

<a id="App_Globals"></a>
## <span style="color: #aaf">App Globals</span>
The following are functions and values exposed to all apps in their \`app.js\` or \`handler.js\`.  Most
of these are asynchronous, returning a \`Promise\` that will be resolved when the call completes, unless
noted otherwise.

This is all a work in progess. These are liable to change without warning.  Feedback is welcome.

The exposed functions in this API balance multiple competing needs:
 * The surface area of the exposed API ought to be fairly minimal.  If something can be implemented entirely app-side, that is
   generally preferred over building it into the core.
 * Everything is built on this API.  Ideally the admin app, the SSB app, and the editor all use standard API exposed to all
   apps, with appropriate permission guards in place making it so that only trusted apps do potentially destructive operations.
   There will be some things here that aren't necessarily general use to support what's required.

If you are looking at the [Tilde Friends source code](https://www.tildefriends.net/~cory/releases/),
the vast majority of these are implemented in \`src/*.js.c\` files, and exposed to apps via \`core/core.js\`.
`;

docs['core.user.credentials.session.name'] = `
*String* The name of the authenticated user.
`;

docs['app.setDocument()'] = `
Set the contents of the client &lt;iframe/&gt;.
### Parameters
 * *String* **html** The HTML contents.
`;

docs['core.apps()'] = `
Gets a list of apps owned by the current user.
### Returns
*Array* An array of string names of the apps owned by the current user.
`;

docs['core.url'] = `
The url by which the running app is being invoked.
`;

docs['app.localStorageSet()'] = `
Set a value in browser local storage.
### Parameters
*String* **key** The localStorage key to set.
*String* **value** The localStorage value to set.
`;

docs['app.localStorageGet()'] = `
Gets a value from browser local storage.
### Parameters
*String* **key** The key with which the value was set.
### Returns
*String* The value, or undefined.
`;

docs['app.print()'] = `
Log information for debugging purposes to the server and to the connected browser console.
### Parameters
 * ... Any args to print.
`;

docs['ssb.createIdentity()'] = `
Create a new SSB identity.
### Returns
*String* The created identity public key.
`;

docs['ssb.getIdentities()'] = `
Get all SSB identities owned by the current user.
### Returns
*Array* An array of public key strings.
`;

docs['ssb.sqlAsync()'] = `
Run an SQL query against the sqlite database.
### Parameters
 * *String* **query** The sqlite query.
 * *Array* **args** The query arguments to bind.
 * *Function* **callback** Callback called for each row result.
`;

docs['ssb.appendMessageWithIdentity()'] = `
Signs and stores a message in the SSB database.
### Parameters
 * *String* **id** The public key of an SSB identity owned by the authenticated user.
 * *Object* **message** The unsigned message.
`;

docs['ssb.storeMessage()'] = `
Verifies and stores a signed message in the SSB database.
### Parameters
 * *Object* **message** The valid, signed message to store.
`;

docs['ssb.blobStore()'] = `
Store a blob in the SSB database.
### Parameters
 * *String*/*Uint8Array* **blob** The blob contents to store
### Returns
*String* The stored blob ID.
`;

docs['ssb.blobGet()'] = `
Fetches a blob from the database.
### Parameters
 * *String* **blob_id** The blob identifier to fetch (\`&....sha256\`).
### Returns
*ArrayBuffer* The blob data.
`;

docs['print()'] = `
Log debug information both to the server's console and to the visiting user's browser console when possible.
### Parameters
 * **...** Whatever you want to log.  Will be joined with spaces.
`;

docs['database()'] = `
Returns a database instance that is specific to the authenticated user and the given key.
### Parameters
 * *String* **key** The database key.
### Returns
 *Database* A database.
`;

docs['my_shared_database()'] = `
Returns a database instance that is specific to the authenticated user and the given key.
### Parameters
 * *String* **package_name** The database package name.
 * *String* **key** The database key.
### Returns
*Database* A database.
`;

docs['shared_database()'] = `
Returns a database instance that is shared between all users of the app, determined by its owner and app name.
### Parameters
 * *String* **key** The database key.
### Returns
*Database* A database.
`;

docs['base64Decode()'] = `
Decode a base64 string to bytes.

Completes synchronously.
### Parameters
 * *String* value The base64-encoded string.
### Returns
*Uint8Array* The decoded bytes.
`;

docs['base64Encode()'] = `
Encode bytes to a base64 string.

Completes synchronously.
### Parameters
 * *Uint8Array* The bytes to encode.
### Returns
*String* The base64-encoded string.
`;

docs['utf8Decode()'] = `
Decode UTF-8 bytes to a string.

Completes synchronously.
### Parameters
 * *Uint8Array* **value** The value to decode.
### Returns
*String* The value as a string.
`;

docs['utf8Encode()'] = `
Encodes a string to UTF-8 bytes.

Completes synchronously.
### Parameters
 * *String* **value** The value to encode.
### Returns
*Uint8Array* The encoded \`value\`.
`;

docs['setTimeout()'] = `
Call a function after some delay.
### Parameters
 * *Function* **callback** The function to call.
 * *Number* **timeout** Number of milliseconds to wait before calling the callback function.
`;

docs['exit()'] = `
Exits the app.  But why would you want to do that?

Completes synchronously.
### Parameters
 * *Integer* **exit_code** System exit code.
`;

docs['version()'] = `
Gets version information for the running server.
### Returns
*Object* Keys are things like \`name\` and \`number\` for the server itself and \`libuv\` and \`openssl\` for
dependencies.  Values are *String* version numbers.
`;

docs['platform()'] = `
Gets the host operating system platform of the running server.
### Returns
*String* The platform, one of \`windows\`, \`android\`, \`linux\`, or \`other\`.
`;

docs['getFile()'] = `
Gets a file from the running app.
### Parameters
 * *String* **name** Name of the file to retrieve.
### Returns
*Uint8Array* The contents of a file from the app with the given name, or *undefined*.
`;

docs.database = `
# <span style="color: #aaf">Database</span>
Local-only storage is provided by a \`Database\` type representing a key-value store.
`;

docs['database.get()'] = `
Gets a value from the database.
### Parameters
 * *String* **key** The key.
### Returns
*String* The value from the database or undefined if not found.
`;

docs['database.getAll()'] = `
Gets all keys from the database.
### Returns
*Array* An array of *String* key names for all keys in the given database.
`;

docs['database.getLike()'] = `
Gets all keys and values from the database matching a pattern.
### Parameters
 * *String* **pattern** An sqlite \`LIKE\` pattern to match keys against.
### Returns
*Object* An object whose keys are the database keys and values are the database values that match the given pattern.
`;

docs['database.set()'] = `
Sets a value in the database, creating a new entry or replacing an existing entry.
### Parameters
 * *String* **key** The key.
 * *String* **value** The value.
`;

docs['database.exchange()'] = `
Performs an atomic compare and exchange operation, setting a value in the database only if its current value matches what is expected.
### Parameters
 * *String* **key** The key.
 * *String* **expected** The expected value.
 * *String* **value** The new value.
 ### Returns
 *Boolean* true if the value is now the given value.
`;

docs['database.remove()'] = `
Removes an entry from the database if it exists.
### Parameters
 * *String* **key** The key.
`;

docs.tfrpc = `
# <span style="color: #aaf" id="tfrpc">tfrpc</span>
\`tfrpc.js\` is a small helper script that is available to be used to facilitate communication between parts of an application.

\`tfrpc.js\` can be used to asynchronously make calls between the app code running in a sandboxed iframe in the browser
and the app process on the server.

From \`app.js\`:
\`\`\`
import * as tfrpc from '/tfrpc.js';
\`\`\`


From script running in the browser:
\`\`\`
import * as tfrpc from '/static/tfrpc.js';
\`\`\`

Either side can register or call functions, though they must be registered before they can be called.  Arguments and return
values are ultimately serialized by means that attempt to preserve most JSON-serializable values as well as functions themselves.
`;

docs['tfrpc.register()'] = `
Register a function, allowing it to be called remotely.
### Parameters
 * *Function* **function** The function to register.  Its name will be how it will be called.
`;

docs['tfrpc.rpc.*()'] = `
Call a remote function.
### Parameters
 * **...** Parameters to pass to the function.
### Returns
The return value of the called function.
`;
