import {html, render} from './lit.min.js';
import * as tfrpc from '/static/tfrpc.js';

function delete_user(user) {
	if (confirm(`Are you sure you want to delete the user "${user}"?`)) {
		tfrpc.rpc
			.delete_user(user)
			.then(function () {
				alert(`User "${user}" deleted successfully.`);
			})
			.catch(function (error) {
				alert(
					`Failed to delete user "${user}": ${JSON.stringify(error, null, 2)}.`
				);
			});
	}
}

async function add_block() {
	await tfrpc.rpc.addBlock(document.getElementById('add_block').value);
}

async function remove_block(id) {
	await tfrpc.rpc.removeBlock(id);
}

function global_settings_set(key, value) {
	tfrpc.rpc
		.global_settings_set(key, value)
		.then(function () {
			alert(`Set "${key}" to "${value}".`);
		})
		.catch(function (error) {
			alert(`Failed to set "${key}": ${JSON.stringify(error, null, 2)}.`);
		});
}

function title_case(name) {
	return name
		.split('_')
		.map((x) => x.charAt(0).toUpperCase() + x.substring(1))
		.join(' ');
}

window.addEventListener('load', function () {
	const permission_template = (permission) => html` <code>${permission}</code>`;
	function input_template(key, description) {
		if (description.type === 'boolean') {
			return html`
				<li class="w3-row">
					<label class="w3-quarter" for=${'gs_' + key} style="font-weight: bold">${title_case(key)}</label>
					<div class="w3-quarter w3-padding">${description.description}</div>
					<div class="w3-quarter w3-padding w3-center"><input class="w3-check" type="checkbox" ?checked=${description.value} id=${'gs_' + key}></input></div>
					<button class="w3-quarter w3-button w3-theme-action" @click=${(e) => global_settings_set(key, e.srcElement.previousElementSibling.firstChild.checked)}>Set</button>
				</li>
			`;
		} else if (description.type === 'textarea') {
			return html`
				<li class="w3-row">
					<label class="w3-quarter" for=${'gs_' + key} style="font-weight: bold"
						>${title_case(key)}</label
					>
					<div class="w3-rest w3-padding">${description.description}</div>
					<textarea
						class="w3-input"
						style="vertical-align: top; resize: vertical"
						id=${'gs_' + key}
					>
${description.value}</textarea
					>
					<button
						class="w3-button w3-right w3-quarter w3-theme-action"
						@click=${(e) =>
							global_settings_set(
								key,
								e.srcElement.previousElementSibling.value
							)}
					>
						Set
					</button>
				</li>
			`;
		} else if (description.type != 'hidden') {
			return html`
				<li class="w3-row">
					<label class="w3-quarter" for=${'gs_' + key} style="font-weight: bold">${title_case(key)}</label>
					<div class="w3-quarter w3-padding">${description.description}</div>
					<input class="w3-input w3-quarter" type="text" value="${description.value}" id=${'gs_' + key}></input>
					<button class="w3-button w3-quarter w3-theme-action" @click=${(e) => global_settings_set(key, e.srcElement.previousElementSibling.value)}>Set</button>
				</li>
			`;
		}
	}
	const user_template = (user, permissions) => html`
		<li class="w3-card w3-margin">
			<button
				class="w3-button w3-theme-action"
				@click=${(e) => delete_user(user)}
			>
				Delete
			</button>
			${user}: ${permissions.map((x) => permission_template(x))}
		</li>
	`;
	const block_template = (block) => html`
		<li class="w3-card w3-margin">
			<button
				class="w3-button w3-theme-action"
				@click=${(e) => remove_block(block.id)}
			>
				Delete
			</button>
			<code>${block.id}</code>
			${new Date(block.timestamp)}
		</li>
	`;
	const users_template = (users) =>
		html` <header class="w3-container w3-theme-l2"><h2>Users</h2></header>
			<ul class="w3-ul">
				${Object.entries(users).map((u) => user_template(u[0], u[1]))}
			</ul>`;
	const blocks_template = (blocks) =>
		html` <header class="w3-container w3-theme-l2"><h2>Blocks</h2></header>
			<div class="w3-row w3-margin">
				<input type="text" class="w3-threequarter w3-input" id="add_block"></input>
				<button class="w3-quarter w3-button w3-theme-action" @click=${add_block}>Add</button>
			</div>
			<ul class="w3-ul">
				${blocks.map((b) => block_template(b))}
			</ul>`;
	const page_template = (data) =>
		html`<div style="padding: 0; margin: 0; width: 100%; max-width: 100%">
			<header class="w3-container w3-theme-l2"><h2>Global Settings</h2></header>
			<div class="w3-container">
				<ul class="w3-ul">
					${Object.keys(data.settings)
						.sort()
						.map((x) => html`${input_template(x, data.settings[x])}`)}
				</ul>
			</div>
			${users_template(data.users)} ${blocks_template(data.blocks)}
		</div> `;
	render(page_template(g_data), document.body);
});
