# Contributing to Tilde Friends

Thank you for your interest in Tilde Friends.

Above all, Tilde Friends aims to be a fun, safe place to play. When that is at
odds with the course of development, we will work through it with respectful
communication.

## How can I contribute?

The nature of Tilde Friends makes for a wide range of ways to contribute

- Just use it. Really, just kicking the tires will probably shake out issues
  in useful ways at this point.
- Report and comment on bugs: https://dev.tildefriends.net/issues.
- Make apps. You don't need my permission to make and share apps with Tilde
  Friends. I hope that an ecosystem of good apps grows outside of this
  repository. If you want to recreate better versions of the stock apps, just
  do it. If you make a better ssb app or whatever and drop me a line however
  is most convenient for you, I will probably take a look and consider
  replacing the stock one with it.
- Write about it. Docs in the git repository, blog posts, private messages to
  me with ideas...really there is no wrong answer. Just make some noise, and
  I'll do my best to incorporate or otherwise link your feedback and make the
  most of it.
- Write C code in the git repository. I'm really striving for it to be the
  case that other people don't really need to meddle in there, but if you can
  help out, I will gladly review your pull requests via
  https://dev.tildefriends.net/pulls.

## Best practices

- The C code is formatted with clang-format. Run `make format`.
- The rest is formatted with prettier. Run `npm run prettier`.
- We strive to have code compile on all platforms with no warnings and run with
  no sanitizer issues.
- There are tests. Run `out/debug/tildefriends test`.
