#!/usr/bin/env python3

import json
import os
import re
import urllib.request

if not os.path.exists('out/emoji-test.txt'):
    urllib.request.urlretrieve('https://unicode.org/Public/emoji/latest/emoji-test.txt', 'out/emoji-test.txt')

doc = {}

with open('out/emoji-test.txt', 'r') as f:
    for line in f:
        line = line.strip()
        if line.startswith('# group: '):
            group = line[len('# group: '):]
        elif line.startswith('# subgroup: '):
            subgroup = line[len('# subgroup: '):]
        else:
            m = re.match(r'((?:\s?[0-9A-F]+)+)\s+; (\S+).*#.*E\d+\.\d+ (.*)', line)
            if m:
                emoji = ''.join(chr(int(g, 16)) for g in m.group(1).split(' '))
                qualified = m.group(2)
                if qualified == 'fully-qualified':
                    name = m.group(3)
                    if not group in doc:
                        doc[group] = {}
                    doc[group][name] = emoji

with open('apps/ssb/emojis.json', 'w') as f:
    json.dump(doc, f, ensure_ascii = False)
