#pragma once

/**
** \defgroup tests Tests
** This is the test harness.
** @{
*/

/**
** Options to control how tests are run.
*/
typedef struct _tf_test_options_t
{
	/** The path to the Tilde Friends executable, in order to run subprocesses. */
	const char* exe_path;
	/** A comma-separated list of tests to run, or NULL. */
	const char* tests;
	/** Path to the actual local database for running performance tests against. */
	const char* db_path;
} tf_test_options_t;

/**
** Run tests.
** @param options Test options.
*/
void tf_tests(const tf_test_options_t* options);

/** @} */
