#pragma once

/**
** \defgroup ssb_tests SSB Tests
** Tests for SSB functionality.
** @{
*/

/**
** Options to control how tests are run.
*/
typedef struct _tf_test_options_t tf_test_options_t;

/**
** Test converting SSB identities.
** @param options The test options.
*/
void tf_ssb_test_id_conversion(const tf_test_options_t* options);

/**
** Test SSB connections and replication.
** @param options The test options.
*/
void tf_ssb_test_ssb(const tf_test_options_t* options);

/**
** Test SSB following calculations.
** @param options The test options.
*/
void tf_ssb_test_following(const tf_test_options_t* options);

/**
** Test SSB rooms.
** @param options The test options.
*/
void tf_ssb_test_rooms(const tf_test_options_t* options);

/**
** Benchmark SSB replication performacnce.
** @param options The test options.
*/
void tf_ssb_test_bench(const tf_test_options_t* options);

/**
** Test communicating with go-ssb-room.
** @param options The test options.
*/
void tf_ssb_test_go_ssb_room(const tf_test_options_t* options);

/**
** Test encrypting a private message.
** @param options The test options.
*/
void tf_ssb_test_encrypt(const tf_test_options_t* options);

/**
** Test peer exchange.
** @param options The test options.
*/
void tf_ssb_test_peer_exchange(const tf_test_options_t* options);

/**
** Test publishing a message.
** @param options The test options.
*/
void tf_ssb_test_publish(const tf_test_options_t* options);

/**
** Test message and replication.
** @param options The test options.
*/
void tf_ssb_test_replicate(const tf_test_options_t* options);

/**
** Test blob replication for a message received while already connected.
** @param options The test options.
*/
void tf_ssb_test_replicate_blob(const tf_test_options_t* options);

/**
** Test connecting by string.
** @param options The test options.
*/
void tf_ssb_test_connect_str(const tf_test_options_t* options);

/**
** Test invites.
** @param options The test options.
*/
void tf_ssb_test_invite(const tf_test_options_t* options);

/**
** Test triggers.
** @param options The test options.
*/
void tf_ssb_test_triggers(const tf_test_options_t* options);

/**
** Test command-line interface.
** @param options The test options.
*/
void tf_ssb_test_cli(const tf_test_options_t* options);

/**
** Test following performance.
** @param options The test options.
*/
void tf_ssb_test_following_perf(const tf_test_options_t* options);

/** @} */
