{
  description = "Tilde Friends is a platform for making, running, and sharing web applications.";

  inputs = {
    nixpkgs.url = "github:NixOS/nixpkgs/nixos-25.05";
    flake-utils.url = "github:numtide/flake-utils";
  };

  outputs = {
    self,
    nixpkgs,
    flake-utils,
  }:
    flake-utils.lib.eachDefaultSystem (system: let
        pkgs = import nixpkgs {
          inherit system;
        };
      in rec
      {
        # Nix formatter, run using `$ nix fmt`
        formatter = pkgs.alejandra;

        # Exports the tildefriends package
        # Build with `$ nix build`
        packages.default = pkgs.callPackage ./default.nix {};

        # Creates a shell with the necessary dependencies
        # Enter using `$ nix develop`
        devShell = pkgs.mkShell {
          buildInputs = with pkgs; [
            openssl
            llvmPackages_17.clang-unwrapped
            unzip
            doxygen
            graphviz
          ];
        };
      });
}
