# Model

A reasonable mental model of Tilde Friends is as a virtual computer. User
interace is through a web browser. Communication with the outside world is
through the Secure Scuttlebutt (SSB) network protocol. Persistence is through
an SSB store and an additional key-value store in an sqlite database.

The schema for the sqlite database is primarily a `messages` table and a
`blobs` table, which are what one would expect from the SSB specifications.

```dot
digraph {
    web_browser -> tilde_friends_web_interface [dir=both];
    web_browser [shape=rect,label="Web Browser"];
    subgraph cluster_tilde_friends {
        label = "Tilde Friends";
        tilde_friends_web_interface -> example_app [dir=both];
        subgraph cluster_sandbox {
            label = "app sandbox";
            example_app;
        }
        example_app -> tilde_friends_core;
        tilde_friends_core -> example_app;
        tilde_friends_web_interface -> tilde_friends_core;
        tilde_friends_core -> "db.sqlite";
        tilde_friends_core -> ssb;
        "db.sqlite" [shape=cylinder];
    }
    ssb -> other_ssb_clients [label="Secure Handshake",dir=both];
    other_ssb_clients [shape=rect,label="SSB Peers"];
}
```
