import {EditorState} from "@codemirror/state"
import {EditorView} from '@codemirror/view';
import {javascript} from "@codemirror/lang-javascript"
import {html} from "@codemirror/lang-html"
import {css} from "@codemirror/lang-css"
import {search} from "@codemirror/search"
import {oneDark} from "./theme-tf-dark.js"
import {lineNumbers, highlightActiveLineGutter, highlightSpecialChars, highlightTrailingWhitespace, drawSelection, dropCursor, rectangularSelection, crosshairCursor, highlightActiveLine, keymap, highlightWhitespace} from '@codemirror/view';
import {foldGutter, indentUnit, indentOnInput, syntaxHighlighting, defaultHighlightStyle, bracketMatching, foldKeymap} from '@codemirror/language';
import {history, defaultKeymap, historyKeymap, indentWithTab} from '@codemirror/commands';
import {highlightSelectionMatches, searchKeymap} from '@codemirror/search';
import {autocompletion, closeBracketsKeymap, completionKeymap} from '@codemirror/autocomplete';
import {lintKeymap} from '@codemirror/lint';

let updateListenerExtension = EditorView.updateListener.of((update) => {
	if (update.docChanged && update.view.onDocChange) {
		update.view.onDocChange();
	}
});

const extensions = [
	lineNumbers(),
	highlightActiveLineGutter(),
	highlightSpecialChars(),
	highlightWhitespace(),
	history(),
	foldGutter(),
	drawSelection(),
	dropCursor(),
	EditorState.allowMultipleSelections.of(true),
	indentOnInput(),
	indentUnit.of('\t'),
	syntaxHighlighting(defaultHighlightStyle, { fallback: true }),
	bracketMatching(),
	autocompletion(),
	rectangularSelection(),
	crosshairCursor(),
	highlightActiveLine(),
	highlightSelectionMatches(),
	highlightTrailingWhitespace(),
	keymap.of([
		...defaultKeymap,
		...searchKeymap,
		...historyKeymap,
		...foldKeymap,
		...completionKeymap,
		...lintKeymap,
		indentWithTab,
	]),
	javascript(),
	html(),
	css(),
	search(),
	oneDark,
	updateListenerExtension,
];

function TildeFriendsEditorView(parent) {
	return new EditorView({
		extensions: extensions,
		parent: parent,
	});
};

export {
	TildeFriendsEditorView,
	EditorState,
	EditorView,
	extensions,
};
