import * as tfrpc from '/tfrpc.js';
import * as utils from './utils.js';

let g_hash;
let g_collection_notifies = {};

tfrpc.register(async function getActiveIdentity() {
	return ssb.getActiveIdentity();
});
tfrpc.register(async function getOwnerIdentities() {
	return ssb.getOwnerIdentities();
});

tfrpc.register(async function getIdentities() {
	return ssb.getIdentities();
});

tfrpc.register(async function query(sql, args) {
	let result = [];
	await ssb.sqlAsync(sql, args, function callback(row) {
		result.push(row);
	});
	return result;
});

tfrpc.register(async function localStorageGet(key) {
	return app.localStorageGet(key);
});

tfrpc.register(async function localStorageSet(key, value) {
	return app.localStorageSet(key, value);
});

tfrpc.register(async function following(ids, depth) {
	return ssb.following(ids, depth);
});

tfrpc.register(async function appendMessage(id, message) {
	print('APPENDING', message);
	return ssb.appendMessageWithIdentity(id, message);
});

tfrpc.register(async function store_blob(blob) {
	if (Array.isArray(blob)) {
		blob = Uint8Array.from(blob);
	}
	return await ssb.blobStore(blob);
});

tfrpc.register(async function get_blob(id) {
	return utf8Decode(await ssb.blobGet(id));
});

core.register('message', async function message_handler(message) {
	if (message.event == 'hashChange') {
		g_hash = message.hash;
		await tfrpc.rpc.hash_changed(message.hash);
	}
});
core.register('setActiveIdentity', async function setActiveIdentityHandler(id) {
	await tfrpc.rpc.setActiveIdentity(id);
});

tfrpc.register(function set_hash(hash) {
	if (g_hash != hash) {
		return app.setHash(hash);
	}
});

tfrpc.register(function get_hash(id, message) {
	return g_hash;
});

tfrpc.register(async function try_decrypt(id, content) {
	return await ssb.privateMessageDecrypt(id, content);
});
tfrpc.register(async function encrypt(id, recipients, content) {
	return await ssb.privateMessageEncrypt(id, recipients, content);
});

tfrpc.register(utils.collection);

async function main() {
	await app.setDocument(utf8Decode(await getFile('index.html')));
}

main();
