import {LitElement, html, unsafeHTML} from './lit-all.min.js';
import {styles, generate_theme} from './tf-styles.js';

class TfTagElement extends LitElement {
	static get properties() {
		return {
			tag: {type: String},
			count: {type: Number},
		};
	}

	static styles = styles;

	constructor() {
		super();
	}

	render() {
		let number = this.count ? html` (${this.count})` : undefined;
		return html`
			<style>
				${generate_theme()}</style
			><a
				href=${'#' + encodeURIComponent(this.tag)}
				class="w3-tag w3-theme-d1 w3-round-4 w3-button"
				>${this.tag}${number}</a
			>
		`;
	}
}

customElements.define('tf-tag', TfTagElement);
