import * as tfrpc from '/tfrpc.js';

tfrpc.register(async function getAllIdentities() {
	return ssb.getAllIdentities();
});
tfrpc.register(async function query(sql, args) {
	let result = [];
	await ssb.sqlAsync(sql, args, function callback(row) {
		result.push(row);
	});
	return result;
});

tfrpc.register(async function store_blob(blob) {
	if (Array.isArray(blob)) {
		blob = Uint8Array.from(blob);
	}
	return await ssb.blobStore(blob);
});
tfrpc.register(async function get_blob(id) {
	return Array.from(new Uint8Array(await ssb.blobGet(id)));
});
tfrpc.register(async function store_message(message) {
	return await ssb.storeMessage(message);
});

async function main() {
	await app.setDocument(utf8Decode(await getFile('index.html')));
}
main();
