# Tilde Friends

Tilde Friends participates in the Secure Scuttlebutt decentralized social
network while also functioning as a platform for making, sharing, and running
web applications.

A public instance lives at https://www.tildefriends.net/.

## Goals

1. Be the fanciest, best-maintained Secure Scuttlebutt client in town.
1. Make it easy to make, share, and run all sorts of applications while
   respecting the privacy and safety of your data.

## Getting the Source

Tilde Friends uses git submodules, so either:

```
git clone --recurse-submodules https://dev.tildefriends.net/cory/tildefriends.git
```

or:

```
git clone https://dev.tildefriends.net/cory/tildefriends.git
cd tildefriends
git submodule update --init --recursive
```

The `.tar.xz` source releases are all-inclusive.

## Building

Builds on Linux (x86_64 and aarch64), MacOS, OpenBSD, and Haiku. It's possible
to build for Android, iOS, and Windows on Linux, if you have the right
dependencies in the right places.

### Requirements

On MacOS, Xcode's command-line tools are expected to be available.

### Build Commands

Run `make` with no arguments to see available build targets and options. `make
debug` is a good place to start.

To build in docker, `docker build .`.

`make format` and `make prettier` will normalize formatting to the coding
standard.

## Running

By default, running the built `out/debug/tildefriends` executable will start a
web server at <http://localhost:12345/>. `tildefriends -h` lists further
options.

The first user to create an account and log in will be granted administrative
privileges. Further administration can be done in the `admin` app at
<http://localhost:12345/~core/admin/>.

## Documentation

Docs live here: <https://docs.tildefriends.net/>.

## License

All code unless otherwise noted in is provided under the
[MIT](https://opensource.org/licenses/MIT) license.
