#!/usr/bin/env python3

import os
import subprocess
import sys
import time

if sys.platform == 'haiku1':
	print('Automation tests are disabled on Haiku.')
	exit(0)

import selenium
from selenium import webdriver
from selenium.webdriver.firefox.service import Service
from selenium.webdriver.common.by import By
from selenium.webdriver.support import expected_conditions
from selenium.webdriver.support.ui import WebDriverWait

def select(driver, path, action = None, keep_trying = False):
	start_time = time.time()
	done = False
	while True:
		try:
			driver.switch_to.default_content()
			context = driver
			for node in path:
				if node.startswith('#'):
					context = context.find_element(By.ID, node[1:])
				elif node.startswith('/'):
					context = context.find_element(By.XPATH, node)
				elif node.startswith('.'):
					context = context.find_element(By.CLASS_NAME, node[1:])
				elif node.startswith('='):
					context = context.find_element(By.LINK_TEXT, node[1:])
				elif node == 'frame':
					driver.switch_to.frame(context)
					context = driver
				elif node == 'shadow_root':
					context = context.shadow_root
				else:
					context = context.find_element(By.TAG_NAME, node)
			if action is not None:
				if action[0] == 'click':
					context.click()
				elif action[0] == 'send_keys':
					context.send_keys(action[1])
				elif action[0] == 'clear':
					context.clear()
				else:
					raise RuntimeError(f'Unexpected action: {action}.')
				done = True
				if not keep_trying:
					break
			else:
				return context
		except (selenium.common.exceptions.NoSuchElementException,
				selenium.common.exceptions.NoSuchShadowRootException,
				selenium.common.exceptions.StaleElementReferenceException,
				selenium.common.exceptions.WebDriverException):
			if done and keep_trying:
				break
			if time.time() - start_time < 5.0:
				time.sleep(0.1)
				pass

success = False
try:
	options = webdriver.FirefoxOptions()
	service = Service(log_output = 'out/geckodriver.log')
	#options.add_argument('--headless')
	driver = webdriver.Firefox(options = options, service = service)
	wait = WebDriverWait(driver, 10)

	driver.get('http://localhost:8888/~core/apps/')
	select(driver, ['tf-navigation', 'shadow_root', '=login'], ('click',))
	select(driver, ['tf-auth', 'shadow_root', '#register_label'], ('click',))
	select(driver, ['tf-auth', 'shadow_root', '#name'], ('send_keys', 'adminuser'))
	select(driver, ['tf-auth', 'shadow_root', '#password'], ('send_keys', 'admin_password'))
	select(driver, ['tf-auth', 'shadow_root', '#confirm'], ('send_keys', 'admin_password'))
	select(driver, ['tf-auth', 'shadow_root', '#loginButton'], ('click',))
	select(driver, ['#document', 'frame', '=identity'])

	driver.get('http://localhost:8888/')
	select(driver, ['#document', 'frame', '//button[text()="Next"]'], ('click',))
	select(driver, ['#document', 'frame', '//button[text()="Onward"]'], ('click',))
	select(driver, ['#document', 'frame', '//button[text()="Got It"]'], ('click',))
	select(driver, ['#document', 'frame', '//button[text()="Okay"]'], ('click',))
	select(driver, ['#document', 'frame', '//button[text()="Let\'s Go!"]'], ('click',))
	select(driver, ['//button[text()="✅ Allow"]'], ('click',))
	select(driver, ['#document', 'frame', 'tf-app', 'shadow_root', '#tf-tab-news', 'shadow_root', '#tf-compose', 'shadow_root', '#edit'], ('send_keys', 'We made it to the ssb app.'))

	driver.get('http://localhost:8888/~core/admin/')
	select(driver, ['#document', 'frame', '#gs_room_name'], ('send_keys', 'test room'))
	select(driver, ['#document', 'frame', '//*[@id="gs_room_name"]/following-sibling::button'], ('click',))
	select(driver, ['//button[text()="✅ Allow"]'], ('click',))
	wait.until(expected_conditions.alert_is_present()).accept()

	select(driver, ['tf-navigation', 'shadow_root', '#identity'], ('click',))
	select(driver, ['tf-navigation', 'shadow_root', '#logout'], ('click',))

	driver.get('http://localhost:8888/~core/apps/')
	select(driver, ['tf-navigation', 'shadow_root', '=login'], ('click',))
	select(driver, ['tf-auth', 'shadow_root', '#register_label'], ('click',))
	select(driver, ['tf-auth', 'shadow_root', '#name'], ('send_keys', 'testuser'))
	select(driver, ['tf-auth', 'shadow_root', '#password'], ('send_keys', 'test_password'))
	select(driver, ['tf-auth', 'shadow_root', '#confirm'], ('send_keys', 'test_password'))
	select(driver, ['tf-auth', 'shadow_root', '#loginButton'], ('click',))
	select(driver, ['#document'])

	select(driver, ['tf-navigation', 'shadow_root', '#create_identity'], ('click',))
	wait.until(expected_conditions.alert_is_present()).accept()

	select(driver, ['tf-navigation', 'shadow_root', '#identity'], ('click',))
	select(driver, ['tf-navigation', 'shadow_root', '#id_dropdown', '//button[position()=2]'], ('click',))

	select(driver, ['#document', 'frame', 'tf-app', 'shadow_root', '#tf-tab-news', 'shadow_root', '.tf-profile', 'shadow_root', '#edit_profile'], ('click',), keep_trying = True)
	select(driver, ['#document', 'frame', 'tf-app', 'shadow_root', '#tf-tab-news', 'shadow_root', '.tf-profile', 'shadow_root', '#name'], ('send_keys', 'user'))
	select(driver, ['#document', 'frame', 'tf-app', 'shadow_root', '#tf-tab-news', 'shadow_root', '.tf-profile', 'shadow_root', '#save_profile'], ('click',))

	select(driver, ['//button[text()="✅ Allow"]'], ('click',))

	driver.get('http://localhost:8888/~testuser/test/')
	select(driver, ['#document'])
	select(driver, ['tf-navigation', 'shadow_root', '#close_error'], ('click',))
	select(driver, ['tf-navigation', 'shadow_root', '=edit'], ('click',))
	select(driver, ['#editor', '.cm-content'], ('click',))
	select(driver, ['#editor', '.cm-content'], ('send_keys', 'app.setDocument(\n\t`<div id=\'test-div\' style=\'color: white; font-size: xx-large\'>\n\t\tHello, world!\n\t</div>`\n);'))
	select(driver, ['#save'], ('click',))

	select(driver, ['#document', 'frame', '#test-div'])

	size = driver.get_window_size()
	driver.set_window_size(1200, 540)
	driver.save_screenshot('out/screenshot0.png')
	driver.set_window_size(size['width'], size['height'])

	select(driver, ['#editor', '.cm-content'], ('click',))
	select(driver, ['#editor', '.cm-content'], ('clear',))
	select(driver, ['#editor', '.cm-content'], ('send_keys', 'app.setDocument("<div id=\'test-div2\'>Hello, world, again!</div>")'))
	select(driver, ['#save'], ('click',))
	select(driver, ['#document', 'frame', '#test-div2'])

	select(driver, ['#delete'], ('click',))
	wait.until(expected_conditions.alert_is_present()).accept()
	wait.until(expected_conditions.alert_is_present()).dismiss()
	driver.get('http://localhost:8888/~testuser/test/')

	select(driver, ['#document'])
	select(driver, ['tf-navigation', 'shadow_root', '#close_error'], ('click',))
	select(driver, ['tf-navigation', 'shadow_root', '=edit'], ('click',))

	driver.get('http://localhost:8888/~core/apps/')

	select(driver, ['#document', 'frame', '=identity'])

	size = driver.get_window_size()
	driver.set_window_size(540, 1200)
	driver.save_screenshot('out/screenshot1.png')
	driver.set_window_size(size['width'], size['height'])

	select(driver, ['#document', 'frame', '=identity'], ('click',))

	select(driver, ['#document', 'frame', '#create_id'], ('click',))
	id0 = select(driver, ['#document', 'frame', 'li']).text.split(' ')[-1]

	select(driver, ['#document', 'frame', '//li/button[text()="Export Identity"]'], ('click',))
	select(driver, ['//button[text()="✅ Allow"]'], ('click',))
	words = select(driver, ['#document', 'frame', '//li//textarea']).get_attribute('value')
	select(driver, ['#document', 'frame', '//li/button[text()="Delete Identity"]'], ('click',))
	driver.switch_to.alert.send_keys('DELETE')
	driver.switch_to.alert.accept()
	select(driver, ['//button[text()="✅ Allow"]'], ('click',))
	driver.switch_to.alert.accept()
	words = select(driver, ['#document', 'frame', '//textarea'], ('send_keys', words))
	select(driver, ['#document', 'frame', '//button[text()="Import Identity"]'], ('click',))
	select(driver, ['//button[text()="✅ Allow"]'], ('click',))
	driver.switch_to.alert.accept()
	driver.switch_to.frame(wait.until(expected_conditions.presence_of_element_located((By.ID, 'document'))))
	id1 = select(driver, ['#document', 'frame', 'li']).text.split(' ')[-1]
	assert id0 == id1

	driver.get('http://localhost:8888/~core/apps/')
	select(driver, ['#document', 'frame', '=ssb'], ('click',))
	select(driver, ['#document', 'frame', 'tf-app', 'shadow_root', '#tf-tab-news', 'shadow_root', '#tf-compose', 'shadow_root', '#edit'], ('send_keys', 'Hello, world!'))
	select(driver, ['#document', 'frame', 'tf-app', 'shadow_root', '#tf-tab-news', 'shadow_root', '#tf-compose', 'shadow_root', '#submit'], ('click',))
	select(driver, ['//label[text()="Remember this decision."]'], ('click',))
	select(driver, ['//button[text()="❌ Deny"]'], ('click',))
	driver.switch_to.alert.accept()
	select(driver, ['#document', 'frame', 'tf-app', 'shadow_root', '#tf-tab-news', 'shadow_root', '#tf-compose', 'shadow_root', '#submit'], ('click',))
	driver.switch_to.alert.accept()
	select(driver, ['#document', 'frame', 'tf-app', 'shadow_root', '#tf-tab-news', 'shadow_root', '#tf-compose', 'shadow_root', '#submit'], ('click',))
	select(driver, ['tf-navigation', 'shadow_root', '=🎛️'], ('click',))
	select(driver, ['tf-navigation', 'shadow_root', '#permission_reset:ssb_append'], ('click',))
	select(driver, ['tf-navigation', 'shadow_root', '#permissions_close'], ('click',))
	select(driver, ['#document', 'frame', 'tf-app', 'shadow_root', '#tf-tab-news', 'shadow_root', '#tf-compose', 'shadow_root', '#submit'], ('click',))
	select(driver, ['//button[text()="❌ Deny"]'], ('click',))
	driver.switch_to.alert.accept()
	select(driver, ['#document', 'frame', 'tf-app', 'shadow_root', '#tf-tab-news', 'shadow_root', '#tf-compose', 'shadow_root', '#submit'], ('click',))
	select(driver, ['//button[text()="✅ Allow"]'], ('click',))
	select(driver, ['#document', 'frame', 'tf-app', 'shadow_root', '#tf-tab-news', 'shadow_root', '#tf-compose', 'shadow_root', '#edit'], ('send_keys', 'Hello, world 2!'))
	select(driver, ['#document', 'frame', 'tf-app', 'shadow_root', '#tf-tab-news', 'shadow_root', '#tf-compose', 'shadow_root', '#submit'], ('click',))
	select(driver, ['//label[text()="Remember this decision."]'], ('click',))
	select(driver, ['//button[text()="✅ Allow"]'], ('click',))
	select(driver, ['#document', 'frame', 'tf-app', 'shadow_root', '#tf-tab-news', 'shadow_root', '#tf-compose', 'shadow_root', '#edit'], ('send_keys', 'Hello, world 3!'))
	select(driver, ['#document', 'frame', 'tf-app', 'shadow_root', '#tf-tab-news', 'shadow_root', '#tf-compose', 'shadow_root', '#submit'], ('click',))

	select(driver, ['tf-navigation', 'shadow_root', '#identity'], ('click',))
	select(driver, ['tf-navigation', 'shadow_root', '#logout'], ('click',))
	select(driver, ['tf-auth', 'shadow_root', '#login_label'], ('click',))
	select(driver, ['tf-auth', 'shadow_root', '#name'], ('send_keys', 'testuser'))
	select(driver, ['tf-auth', 'shadow_root', '#password'], ('send_keys', 'test_password'))
	select(driver, ['tf-auth', 'shadow_root', '#loginButton'], ('click',))

	select(driver, ['tf-navigation', 'shadow_root', '#identity'], ('click',))
	select(driver, ['tf-navigation', 'shadow_root', '#logout'], ('click',))
	select(driver, ['tf-auth', 'shadow_root', '#guest_label'], ('click',))
	select(driver, ['tf-auth', 'shadow_root', '#guestButton'], ('click',))
	select(driver, ['#document', 'frame', 'tf-app', 'shadow_root'])

	select(driver, ['tf-navigation', 'shadow_root', '#logout'], ('click',))
	select(driver, ['tf-auth', 'shadow_root', '#login_label'], ('click',))

	select(driver, ['tf-auth', 'shadow_root', '#name'], ('send_keys', 'testuser'))
	select(driver, ['tf-auth', 'shadow_root', '#password'], ('send_keys', 'wrong_password'))
	select(driver, ['tf-auth', 'shadow_root', '#loginButton'], ('click',))
	select(driver, ['tf-auth', 'shadow_root', '#error'])

	select(driver, ['tf-auth', 'shadow_root', '#name'], ('send_keys', 'wrong_user'))
	select(driver, ['tf-auth', 'shadow_root', '#password'], ('send_keys', 'test_password'))
	select(driver, ['tf-auth', 'shadow_root', '#loginButton'], ('click',))
	select(driver, ['tf-auth', 'shadow_root', '#error'])

	select(driver, ['tf-auth', 'shadow_root', '#register_label'], ('click',))
	select(driver, ['tf-auth', 'shadow_root', '#name'], ('send_keys', 'testuser'))
	select(driver, ['tf-auth', 'shadow_root', '#password'], ('send_keys', 'wrong_test_password'))
	select(driver, ['tf-auth', 'shadow_root', '#confirm'], ('send_keys', 'wrong_test_password'))
	select(driver, ['tf-auth', 'shadow_root', '#loginButton'], ('click',))
	select(driver, ['tf-auth', 'shadow_root', '#error'])

	select(driver, ['tf-auth', 'shadow_root', '#register_label'], ('click',))
	select(driver, ['tf-auth', 'shadow_root', '#name'], ('send_keys', 'testuser'))
	select(driver, ['tf-auth', 'shadow_root', '#password'], ('send_keys', 'test_password'))
	select(driver, ['tf-auth', 'shadow_root', '#confirm'], ('send_keys', 'test_password'))
	select(driver, ['tf-auth', 'shadow_root', '#loginButton'], ('click',))
	select(driver, ['tf-auth', 'shadow_root', '#error'])

	select(driver, ['tf-auth', 'shadow_root', '#register_label'], ('click',))
	select(driver, ['tf-auth', 'shadow_root', '#name'], ('send_keys', '😁'))
	select(driver, ['tf-auth', 'shadow_root', '#password'], ('send_keys', 'test_password'))
	select(driver, ['tf-auth', 'shadow_root', '#confirm'], ('send_keys', 'test_password'))
	select(driver, ['tf-auth', 'shadow_root', '#loginButton'], ('click',))
	select(driver, ['tf-auth', 'shadow_root', '#error'])

	select(driver, ['tf-auth', 'shadow_root', '#change_label'], ('click',))
	select(driver, ['tf-auth', 'shadow_root', '#name'], ('send_keys', 'testuser'))
	select(driver, ['tf-auth', 'shadow_root', '#password'], ('send_keys', 'test_password'))
	select(driver, ['tf-auth', 'shadow_root', '#new_password'], ('send_keys', 'new_password'))
	select(driver, ['tf-auth', 'shadow_root', '#confirm'], ('send_keys', 'new_password'))
	select(driver, ['tf-auth', 'shadow_root', '#loginButton'], ('click',))
	select(driver, ['#document', 'frame'])

	select(driver, ['tf-navigation', 'shadow_root', '#identity'], ('click',))
	select(driver, ['tf-navigation', 'shadow_root', '#logout'], ('click',))
	select(driver, ['tf-auth', 'shadow_root', '#login_label'], ('click',))
	select(driver, ['tf-auth', 'shadow_root', '#name'], ('send_keys', 'testuser'))
	select(driver, ['tf-auth', 'shadow_root', '#password'], ('send_keys', 'test_password'))
	select(driver, ['tf-auth', 'shadow_root', '#loginButton'], ('click',))
	select(driver, ['tf-auth', 'shadow_root', '#error'])
	select(driver, ['tf-auth', 'shadow_root', '#login_label'], ('click',))
	select(driver, ['tf-auth', 'shadow_root', '#name'], ('send_keys', 'testuser'))
	select(driver, ['tf-auth', 'shadow_root', '#password'], ('send_keys', 'new_password'))
	select(driver, ['tf-auth', 'shadow_root', '#loginButton'], ('click',))
	select(driver, ['#document', 'frame'])

	success = True
finally:
	driver.close()
	driver.quit()

if success:
	print('\033[92mTEST SUCCEEDED.\033[0m')
else:
	print('\033[91mTEST FAILED.\033[0m')
