#pragma once

/**
** \defgroup log Logging helpers
** @{
*/

/**
** Log a message using printf-style formatting.  Tries to use appropriate
** platform-specific functionality where necessary to make sure output goes
** somewhere that it can be seen.
*/
#if defined(__ANDROID__)
#include <android/log.h>
#define tf_printf(...) __android_log_print(ANDROID_LOG_INFO, "tildefriends", __VA_ARGS__)
#elif defined(__APPLE__)
#include <TargetConditionals.h>
#if TARGET_OS_IPHONE
#include <os/log.h>
#define tf_printf(...) \
	do \
	{ \
		char buffer##__LINE__[2048]; \
		snprintf(buffer##__LINE__, sizeof(buffer##__LINE__), __VA_ARGS__); \
		os_log(OS_LOG_DEFAULT, "%{public}s", buffer##__LINE__); \
	} while (0)
#else
#include <stdio.h>
#define tf_printf printf
#endif
#else
#include <stdio.h>
#define tf_printf printf
#endif

/** @} */
