#pragma once

/**
** \defgroup file_js File Interface
** Exposes an operating system file I/O API to script.
** @{
*/

#include <uv.h>

/** A JS context. */
typedef struct JSContext JSContext;
/** A task. */
typedef struct _tf_task_t tf_task_t;

/**
** Register the file script interface.
** @param context The JS context.
*/
void tf_file_register(JSContext* context);

/**
** Asynchronously stat() a file.
** @param task The running task.
** @param path The path to the file to stat().
** @param callback A function that will be called with the stat result.
** @param user_data User data that will be passed to the callback.
*/
void tf_file_stat(tf_task_t* task, const char* path, void (*callback)(tf_task_t* task, const char* path, int result, const uv_stat_t* stat, void* user_data), void* user_data);

/**
** Asynchronously read a file's contents.
** @param task The running task.
** @param path The path to the file.
** @param callback A callback that will be called with the file contents.
** @param user_data User data that will be provided to the callback.
*/
void tf_file_read(tf_task_t* task, const char* path, void (*callback)(tf_task_t* task, const char* path, int result, const void* data, void* user_data), void* user_data);

/** @} */
