import {LitElement, html} from './lit-all.min.js';
import * as tfrpc from '/static/tfrpc.js';
import {styles, generate_theme} from './tf-styles.js';

class TfUserElement extends LitElement {
	static get properties() {
		return {
			id: {type: String},
			fallback_name: {type: String},
			icon_only: {type: Boolean},
			users: {type: Object},
			nolink: {type: Boolean},
		};
	}

	static styles = styles;

	constructor() {
		super();
		this.id = null;
		this.fallback_name = null;
		this.icon_only = false;
		this.users = {};
	}

	render() {
		let user = this.users[this.id];
		let shape =
			user?.follow_depth === undefined || user.follow_depth >= 2
				? 'w3-circle'
				: 'w3-round';
		let image = html`<span
			class=${'w3-theme-l4 ' + shape}
			style="display: inline-block; width: 2em; height: 2em; text-align: center; line-height: 2em"
			>😎</span
		>`;
		let name = this.users?.[this.id]?.name;
		let name_string = name ?? this.fallback_name ?? this.id;
		name = this.icon_only
			? undefined
			: !this.nolink
				? html`<a target="_top" href=${'#' + this.id}>${name_string}</a>`
				: html`<span>${name_string}</span>`;

		if (user) {
			let image_link = user.image;
			if (typeof image_link == 'string' && !image_link.startsWith('&')) {
				try {
					image_link = JSON.parse(image_link)?.link;
				} catch {}
			}
			if (image_link !== undefined) {
				image = html`<img
					class=${'w3-theme-l4 ' + shape}
					style="width: 2em; height: 2em; vertical-align: middle; object-fit: cover"
					src="/${image_link}/view"
					title=${name_string + ' (' + this.id + ')'}
				/>`;
			}
		}
		return html` <style>
				${generate_theme()}
			</style>
			<div
				style=${'display: inline-block; vertical-align: middle; text-wrap: nowrap; max-width: 100%; overflow: hidden; text-overflow: ellipsis' +
				(this.nolink ? '' : '; font-weight: bold')}
			>
				${image} ${name}
			</div>`;
	}
}

customElements.define('tf-user', TfUserElement);
