import * as blog from './blog.js';

async function main() {
	if (request.path.startsWith('%') && request.path.endsWith('.sha256')) {
		let id = request.path.startsWith('%25')
			? '%' + request.path.substring(3)
			: request.path;
		let message = await blog.get_blog_message(id);
		if (message) {
			respond({
				data: await blog.render_blog_post_html(message),
				content_type: 'text/html; charset=utf-8',
			});
		} else {
			respond({
				data: `Message ${id} not found.`,
				content_type: 'text/html; charset=utf-8',
			});
		}
	} else if (request.path == 'atom') {
		let blogs = await blog.get_posts();
		respond({
			data: blog.render_atom(blogs),
			content_type: 'application/atom+xml',
		});
	} else {
		let blogs = await blog.get_posts();
		for (let blog_post of blogs) {
			let title = (blog_post.title || '').replaceAll(/\W/g, '_').toLowerCase();
			if (request.path === title) {
				respond({
					data: await blog.render_blog_post_html(blog_post),
					content_type: 'text/html; charset=utf-8',
				});
				return;
			}
		}
		respond({
			data: blog.render_html(blogs),
			content_type: 'text/html; charset=utf-8',
		});
	}
}

main().catch(function (error) {
	respond({
		data: `<!DOCTYPE html>
	<pre style="color: #f00">${error.message}\n${error.stack}</pre>`,
		content_type: 'text/html',
	});
});
