import * as tfrpc from '/tfrpc.js';

tfrpc.register(function delete_user(user) {
	return core.deleteUser(user);
});

tfrpc.register(function global_settings_set(key, value) {
	return core.globalSettingsSet(key, value);
});

async function main() {
	try {
		let data = {
			users: {},
			granted: await core.allPermissionsGranted(),
			settings: await core.globalSettingsDescriptions(),
		};
		for (let user of await core.users()) {
			data.users[user] = await core.permissionsForUser(user);
		}
		await app.setDocument(
			utf8Decode(getFile('index.html')).replace('$data', JSON.stringify(data))
		);
	} catch {
		await app.setDocument(
			'<span style="color: #f00">Only an administrator can modify these settings.</span>'
		);
	}
}
main();
