import 'package:flutter/material.dart';
import 'package:locale_names/locale_names.dart';

void main() {
  runApp(MyApp());
}

class MyApp extends StatefulWidget {
  @override
  State<StatefulWidget> createState() => MyAppState();
}

class MyAppState extends State<MyApp> {
  static const List<Locale> languages = [
    Locale.fromSubtags(languageCode: "af"),
    Locale.fromSubtags(languageCode: "agq"),
    Locale.fromSubtags(languageCode: "ak"),
    Locale.fromSubtags(languageCode: "am"),
    Locale.fromSubtags(languageCode: "ar"),
    Locale.fromSubtags(languageCode: "as"),
    Locale.fromSubtags(languageCode: "asa"),
    Locale.fromSubtags(languageCode: "ast"),
    Locale.fromSubtags(languageCode: "az"),
    Locale.fromSubtags(languageCode: "bas"),
    Locale.fromSubtags(languageCode: "be"),
    Locale.fromSubtags(languageCode: "bem"),
    Locale.fromSubtags(languageCode: "bez"),
    Locale.fromSubtags(languageCode: "bg"),
    Locale.fromSubtags(languageCode: "bm"),
    Locale.fromSubtags(languageCode: "bn"),
    Locale.fromSubtags(languageCode: "bo"),
    Locale.fromSubtags(languageCode: "br"),
    Locale.fromSubtags(languageCode: "brx"),
    Locale.fromSubtags(languageCode: "bs"),
    Locale.fromSubtags(languageCode: "ca"),
    Locale.fromSubtags(languageCode: "ccp"),
    Locale.fromSubtags(languageCode: "ce"),
    Locale.fromSubtags(languageCode: "ceb"),
    Locale.fromSubtags(languageCode: "cgg"),
    Locale.fromSubtags(languageCode: "chr"),
    Locale.fromSubtags(languageCode: "ckb"),
    Locale.fromSubtags(languageCode: "cs"),
    Locale.fromSubtags(languageCode: "cu"),
    Locale.fromSubtags(languageCode: "cy"),
    Locale.fromSubtags(languageCode: "da"),
    Locale.fromSubtags(languageCode: "dav"),
    Locale.fromSubtags(languageCode: "de"),
    Locale.fromSubtags(languageCode: "dje"),
    Locale.fromSubtags(languageCode: "dsb"),
    Locale.fromSubtags(languageCode: "dua"),
    Locale.fromSubtags(languageCode: "dyo"),
    Locale.fromSubtags(languageCode: "dz"),
    Locale.fromSubtags(languageCode: "ebu"),
    Locale.fromSubtags(languageCode: "ee"),
    Locale.fromSubtags(languageCode: "el"),
    Locale.fromSubtags(languageCode: "en"),
    Locale.fromSubtags(languageCode: "eo"),
    Locale.fromSubtags(languageCode: "es"),
    Locale.fromSubtags(languageCode: "et"),
    Locale.fromSubtags(languageCode: "eu"),
    Locale.fromSubtags(languageCode: "ewo"),
    Locale.fromSubtags(languageCode: "fa"),
    Locale.fromSubtags(languageCode: "ff"),
    Locale.fromSubtags(languageCode: "fi"),
    Locale.fromSubtags(languageCode: "fil"),
    Locale.fromSubtags(languageCode: "fo"),
    Locale.fromSubtags(languageCode: "fr"),
    Locale.fromSubtags(languageCode: "fur"),
    Locale.fromSubtags(languageCode: "fy"),
    Locale.fromSubtags(languageCode: "ga"),
    Locale.fromSubtags(languageCode: "gd"),
    Locale.fromSubtags(languageCode: "gl"),
    Locale.fromSubtags(languageCode: "gsw"),
    Locale.fromSubtags(languageCode: "gu"),
    Locale.fromSubtags(languageCode: "guz"),
    Locale.fromSubtags(languageCode: "gv"),
    Locale.fromSubtags(languageCode: "ha"),
    Locale.fromSubtags(languageCode: "haw"),
    Locale.fromSubtags(languageCode: "he"),
    Locale.fromSubtags(languageCode: "hi"),
    Locale.fromSubtags(languageCode: "hr"),
    Locale.fromSubtags(languageCode: "hsb"),
    Locale.fromSubtags(languageCode: "hu"),
    Locale.fromSubtags(languageCode: "hy"),
    Locale.fromSubtags(languageCode: "ia"),
    Locale.fromSubtags(languageCode: "id"),
    Locale.fromSubtags(languageCode: "ig"),
    Locale.fromSubtags(languageCode: "ii"),
    Locale.fromSubtags(languageCode: "is"),
    Locale.fromSubtags(languageCode: "it"),
    Locale.fromSubtags(languageCode: "ja"),
    Locale.fromSubtags(languageCode: "jgo"),
    Locale.fromSubtags(languageCode: "jmc"),
    Locale.fromSubtags(languageCode: "jv"),
    Locale.fromSubtags(languageCode: "ka"),
    Locale.fromSubtags(languageCode: "kab"),
    Locale.fromSubtags(languageCode: "kam"),
    Locale.fromSubtags(languageCode: "kde"),
    Locale.fromSubtags(languageCode: "kea"),
    Locale.fromSubtags(languageCode: "khq"),
    Locale.fromSubtags(languageCode: "ki"),
    Locale.fromSubtags(languageCode: "kk"),
    Locale.fromSubtags(languageCode: "kkj"),
    Locale.fromSubtags(languageCode: "kl"),
    Locale.fromSubtags(languageCode: "kln"),
    Locale.fromSubtags(languageCode: "km"),
    Locale.fromSubtags(languageCode: "kn"),
    Locale.fromSubtags(languageCode: "ko"),
    Locale.fromSubtags(languageCode: "kok"),
    Locale.fromSubtags(languageCode: "ks"),
    Locale.fromSubtags(languageCode: "ksb"),
    Locale.fromSubtags(languageCode: "ksf"),
    Locale.fromSubtags(languageCode: "ksh"),
    Locale.fromSubtags(languageCode: "ku"),
    Locale.fromSubtags(languageCode: "kw"),
    Locale.fromSubtags(languageCode: "ky"),
    Locale.fromSubtags(languageCode: "lag"),
    Locale.fromSubtags(languageCode: "lb"),
    Locale.fromSubtags(languageCode: "lg"),
    Locale.fromSubtags(languageCode: "lkt"),
    Locale.fromSubtags(languageCode: "ln"),
    Locale.fromSubtags(languageCode: "lo"),
    Locale.fromSubtags(languageCode: "lrc"),
    Locale.fromSubtags(languageCode: "lt"),
    Locale.fromSubtags(languageCode: "lu"),
    Locale.fromSubtags(languageCode: "luo"),
    Locale.fromSubtags(languageCode: "luy"),
    Locale.fromSubtags(languageCode: "lv"),
    Locale.fromSubtags(languageCode: "mai"),
    Locale.fromSubtags(languageCode: "mas"),
    Locale.fromSubtags(languageCode: "mer"),
    Locale.fromSubtags(languageCode: "mfe"),
    Locale.fromSubtags(languageCode: "mg"),
    Locale.fromSubtags(languageCode: "mgh"),
    Locale.fromSubtags(languageCode: "mgo"),
    Locale.fromSubtags(languageCode: "mi"),
    Locale.fromSubtags(languageCode: "mk"),
    Locale.fromSubtags(languageCode: "ml"),
    Locale.fromSubtags(languageCode: "mn"),
    Locale.fromSubtags(languageCode: "mni"),
    Locale.fromSubtags(languageCode: "mr"),
    Locale.fromSubtags(languageCode: "ms"),
    Locale.fromSubtags(languageCode: "mt"),
    Locale.fromSubtags(languageCode: "mua"),
    Locale.fromSubtags(languageCode: "my"),
    Locale.fromSubtags(languageCode: "mzn"),
    Locale.fromSubtags(languageCode: "naq"),
    Locale.fromSubtags(languageCode: "nb"),
    Locale.fromSubtags(languageCode: "nd"),
    Locale.fromSubtags(languageCode: "nds"),
    Locale.fromSubtags(languageCode: "ne"),
    Locale.fromSubtags(languageCode: "nl"),
    Locale.fromSubtags(languageCode: "nmg"),
    Locale.fromSubtags(languageCode: "nn"),
    Locale.fromSubtags(languageCode: "nnh"),
    Locale.fromSubtags(languageCode: "no"),
    Locale.fromSubtags(languageCode: "nus"),
    Locale.fromSubtags(languageCode: "nyn"),
    Locale.fromSubtags(languageCode: "om"),
    Locale.fromSubtags(languageCode: "or"),
    Locale.fromSubtags(languageCode: "os"),
    Locale.fromSubtags(languageCode: "pa"),
    Locale.fromSubtags(languageCode: "pcm"),
    Locale.fromSubtags(languageCode: "pl"),
    Locale.fromSubtags(languageCode: "prg"),
    Locale.fromSubtags(languageCode: "ps"),
    Locale.fromSubtags(languageCode: "pt"),
    Locale.fromSubtags(languageCode: "qu"),
    Locale.fromSubtags(languageCode: "rm"),
    Locale.fromSubtags(languageCode: "rn"),
    Locale.fromSubtags(languageCode: "ro"),
    Locale.fromSubtags(languageCode: "rof"),
    Locale.fromSubtags(languageCode: "ru"),
    Locale.fromSubtags(languageCode: "rw"),
    Locale.fromSubtags(languageCode: "rwk"),
    Locale.fromSubtags(languageCode: "sah"),
    Locale.fromSubtags(languageCode: "saq"),
    Locale.fromSubtags(languageCode: "sat"),
    Locale.fromSubtags(languageCode: "sbp"),
    Locale.fromSubtags(languageCode: "sd"),
    Locale.fromSubtags(languageCode: "se"),
    Locale.fromSubtags(languageCode: "seh"),
    Locale.fromSubtags(languageCode: "ses"),
    Locale.fromSubtags(languageCode: "sg"),
    Locale.fromSubtags(languageCode: "sh"),
    Locale.fromSubtags(languageCode: "shi"),
    Locale.fromSubtags(languageCode: "si"),
    Locale.fromSubtags(languageCode: "sk"),
    Locale.fromSubtags(languageCode: "sl"),
    Locale.fromSubtags(languageCode: "smn"),
    Locale.fromSubtags(languageCode: "sn"),
    Locale.fromSubtags(languageCode: "so"),
    Locale.fromSubtags(languageCode: "sq"),
    Locale.fromSubtags(languageCode: "sr"),
    Locale.fromSubtags(languageCode: "st"),
    Locale.fromSubtags(languageCode: "su"),
    Locale.fromSubtags(languageCode: "sv"),
    Locale.fromSubtags(languageCode: "sw"),
    Locale.fromSubtags(languageCode: "swc"),
    Locale.fromSubtags(languageCode: "ta"),
    Locale.fromSubtags(languageCode: "te"),
    Locale.fromSubtags(languageCode: "teo"),
    Locale.fromSubtags(languageCode: "tg"),
    Locale.fromSubtags(languageCode: "th"),
    Locale.fromSubtags(languageCode: "ti"),
    Locale.fromSubtags(languageCode: "tk"),
    Locale.fromSubtags(languageCode: "tl"),
    Locale.fromSubtags(languageCode: "to"),
    Locale.fromSubtags(languageCode: "tr"),
    Locale.fromSubtags(languageCode: "tt"),
    Locale.fromSubtags(languageCode: "twq"),
    Locale.fromSubtags(languageCode: "tzm"),
    Locale.fromSubtags(languageCode: "ug"),
    Locale.fromSubtags(languageCode: "uk"),
    Locale.fromSubtags(languageCode: "ur"),
    Locale.fromSubtags(languageCode: "uz"),
    Locale.fromSubtags(languageCode: "vai"),
    Locale.fromSubtags(languageCode: "vi"),
    Locale.fromSubtags(languageCode: "vo"),
    Locale.fromSubtags(languageCode: "vun"),
    Locale.fromSubtags(languageCode: "wae"),
    Locale.fromSubtags(languageCode: "wo"),
    Locale.fromSubtags(languageCode: "xh"),
    Locale.fromSubtags(languageCode: "xog"),
    Locale.fromSubtags(languageCode: "yav"),
    Locale.fromSubtags(languageCode: "yi"),
    Locale.fromSubtags(languageCode: "yo"),
    Locale.fromSubtags(languageCode: "yue"),
    Locale.fromSubtags(languageCode: "zgh"),
    Locale.fromSubtags(languageCode: "zh"),
    Locale.fromSubtags(languageCode: "zu")
  ];

  static const List<Locale> scripts = [
    Locale.fromSubtags(languageCode: "az", scriptCode: "Cyrl"),
    Locale.fromSubtags(languageCode: "az", scriptCode: "Latn"),
    Locale.fromSubtags(languageCode: "bm", scriptCode: "Latn"),
    Locale.fromSubtags(languageCode: "bs", scriptCode: "Cyrl"),
    Locale.fromSubtags(languageCode: "bs", scriptCode: "Latn"),
    Locale.fromSubtags(languageCode: "en", scriptCode: "Dsrt"),
    Locale.fromSubtags(languageCode: "ff", scriptCode: "Adlm"),
    Locale.fromSubtags(languageCode: "ha", scriptCode: "Latn"),
    Locale.fromSubtags(languageCode: "kk", scriptCode: "Cyrl"),
    Locale.fromSubtags(languageCode: "ks", scriptCode: "Arab"),
    Locale.fromSubtags(languageCode: "ky", scriptCode: "Cyrl"),
    Locale.fromSubtags(languageCode: "mn", scriptCode: "Cyrl"),
    Locale.fromSubtags(languageCode: "ms", scriptCode: "Latn"),
    Locale.fromSubtags(languageCode: "pa", scriptCode: "Arab"),
    Locale.fromSubtags(languageCode: "pa", scriptCode: "Guru"),
    Locale.fromSubtags(languageCode: "sd", scriptCode: "Deva"),
    Locale.fromSubtags(languageCode: "shi", scriptCode: "Latn"),
    Locale.fromSubtags(languageCode: "shi", scriptCode: "Tfng"),
    Locale.fromSubtags(languageCode: "sr", scriptCode: "Cyrl"),
    Locale.fromSubtags(languageCode: "sr", scriptCode: "Latn"),
    Locale.fromSubtags(languageCode: "ug", scriptCode: "Arab"),
    Locale.fromSubtags(languageCode: "uz", scriptCode: "Arab"),
    Locale.fromSubtags(languageCode: "uz", scriptCode: "Cyrl"),
    Locale.fromSubtags(languageCode: "uz", scriptCode: "Latn"),
    Locale.fromSubtags(languageCode: "vai", scriptCode: "Latn"),
    Locale.fromSubtags(languageCode: "yue", scriptCode: "Hans"),
    Locale.fromSubtags(languageCode: "zh", scriptCode: "Hans"),
    Locale.fromSubtags(languageCode: "zh", scriptCode: "Hant"),
  ];

  static const List<Locale> countries = [
    Locale.fromSubtags(languageCode: "af", countryCode: "NA"),
    Locale.fromSubtags(languageCode: "af", countryCode: "ZA"),
    Locale.fromSubtags(languageCode: "am", countryCode: "ET"),
    Locale.fromSubtags(languageCode: "ar", countryCode: "AE"),
    Locale.fromSubtags(languageCode: "ar", countryCode: "BH"),
    Locale.fromSubtags(languageCode: "ar", countryCode: "DJ"),
    Locale.fromSubtags(languageCode: "ar", countryCode: "DZ"),
    Locale.fromSubtags(languageCode: "ar", countryCode: "EG"),
    Locale.fromSubtags(languageCode: "ar", countryCode: "EH"),
    Locale.fromSubtags(languageCode: "ar", countryCode: "ER"),
    Locale.fromSubtags(languageCode: "ar", countryCode: "IL"),
    Locale.fromSubtags(languageCode: "ar", countryCode: "IQ"),
    Locale.fromSubtags(languageCode: "ar", countryCode: "JO"),
    Locale.fromSubtags(languageCode: "ar", countryCode: "KM"),
    Locale.fromSubtags(languageCode: "ar", countryCode: "KW"),
    Locale.fromSubtags(languageCode: "ar", countryCode: "LB"),
    Locale.fromSubtags(languageCode: "ar", countryCode: "LY"),
    Locale.fromSubtags(languageCode: "ar", countryCode: "MA"),
    Locale.fromSubtags(languageCode: "ar", countryCode: "MR"),
    Locale.fromSubtags(languageCode: "ar", countryCode: "OM"),
    Locale.fromSubtags(languageCode: "ar", countryCode: "PS"),
    Locale.fromSubtags(languageCode: "ar", countryCode: "QA"),
    Locale.fromSubtags(languageCode: "ar", countryCode: "SA"),
    Locale.fromSubtags(languageCode: "ar", countryCode: "SD"),
    Locale.fromSubtags(languageCode: "ar", countryCode: "SO"),
    Locale.fromSubtags(languageCode: "ar", countryCode: "SS"),
    Locale.fromSubtags(languageCode: "ar", countryCode: "SY"),
    Locale.fromSubtags(languageCode: "ar", countryCode: "TD"),
    Locale.fromSubtags(languageCode: "ar", countryCode: "TN"),
    Locale.fromSubtags(languageCode: "ar", countryCode: "YE"),
    Locale.fromSubtags(languageCode: "as", countryCode: "IN"),
    Locale.fromSubtags(languageCode: "az", countryCode: "AZ"),
    Locale.fromSubtags(
        languageCode: "az", scriptCode: "Cyrl", countryCode: "AZ"),
    Locale.fromSubtags(languageCode: "be", countryCode: "BY"),
    Locale.fromSubtags(languageCode: "bg", countryCode: "BG"),
    Locale.fromSubtags(languageCode: "bn", countryCode: "BD"),
    Locale.fromSubtags(languageCode: "bn", countryCode: "IN"),
    Locale.fromSubtags(languageCode: "bo", countryCode: "CN"),
    Locale.fromSubtags(languageCode: "bo", countryCode: "IN"),
    Locale.fromSubtags(languageCode: "br", countryCode: "FR"),
    Locale.fromSubtags(languageCode: "bs", countryCode: "BA"),
    Locale.fromSubtags(
        languageCode: "bs", scriptCode: "Cyrl", countryCode: "BA"),
    Locale.fromSubtags(languageCode: "ca", countryCode: "AD"),
    Locale.fromSubtags(languageCode: "ca", countryCode: "ES"),
    Locale.fromSubtags(languageCode: "ca", countryCode: "FR"),
    Locale.fromSubtags(languageCode: "ca", countryCode: "IT"),
    Locale.fromSubtags(languageCode: "cs", countryCode: "CZ"),
    Locale.fromSubtags(languageCode: "cy", countryCode: "GB"),
    Locale.fromSubtags(languageCode: "da", countryCode: "DK"),
    Locale.fromSubtags(languageCode: "da", countryCode: "GL"),
    Locale.fromSubtags(languageCode: "de", countryCode: "AT"),
    Locale.fromSubtags(languageCode: "de", countryCode: "BE"),
    Locale.fromSubtags(languageCode: "de", countryCode: "CH"),
    Locale.fromSubtags(languageCode: "de", countryCode: "DE"),
    Locale.fromSubtags(languageCode: "de", countryCode: "LI"),
    Locale.fromSubtags(languageCode: "de", countryCode: "LU"),
    Locale.fromSubtags(languageCode: "dz", countryCode: "BT"),
    Locale.fromSubtags(languageCode: "ee", countryCode: "GH"),
    Locale.fromSubtags(languageCode: "ee", countryCode: "TG"),
    Locale.fromSubtags(languageCode: "el", countryCode: "CY"),
    Locale.fromSubtags(languageCode: "el", countryCode: "GR"),
    Locale.fromSubtags(languageCode: "en", countryCode: "150"),
    Locale.fromSubtags(languageCode: "en", countryCode: "AE"),
    Locale.fromSubtags(languageCode: "en", countryCode: "AG"),
    Locale.fromSubtags(languageCode: "en", countryCode: "AI"),
    Locale.fromSubtags(languageCode: "en", countryCode: "AS"),
    Locale.fromSubtags(languageCode: "en", countryCode: "AT"),
    Locale.fromSubtags(languageCode: "en", countryCode: "AU"),
    Locale.fromSubtags(languageCode: "en", countryCode: "BB"),
    Locale.fromSubtags(languageCode: "en", countryCode: "BE"),
    Locale.fromSubtags(languageCode: "en", countryCode: "BI"),
    Locale.fromSubtags(languageCode: "en", countryCode: "BM"),
    Locale.fromSubtags(languageCode: "en", countryCode: "BS"),
    Locale.fromSubtags(languageCode: "en", countryCode: "BW"),
    Locale.fromSubtags(languageCode: "en", countryCode: "BZ"),
    Locale.fromSubtags(languageCode: "en", countryCode: "CA"),
    Locale.fromSubtags(languageCode: "en", countryCode: "CC"),
    Locale.fromSubtags(languageCode: "en", countryCode: "CH"),
    Locale.fromSubtags(languageCode: "en", countryCode: "CK"),
    Locale.fromSubtags(languageCode: "en", countryCode: "CM"),
    Locale.fromSubtags(languageCode: "en", countryCode: "CX"),
    Locale.fromSubtags(languageCode: "en", countryCode: "CY"),
    Locale.fromSubtags(languageCode: "en", countryCode: "DE"),
    Locale.fromSubtags(languageCode: "en", countryCode: "DG"),
    Locale.fromSubtags(languageCode: "en", countryCode: "DK"),
    Locale.fromSubtags(languageCode: "en", countryCode: "DM"),
    Locale.fromSubtags(languageCode: "en", countryCode: "ER"),
    Locale.fromSubtags(languageCode: "en", countryCode: "FI"),
    Locale.fromSubtags(languageCode: "en", countryCode: "FJ"),
    Locale.fromSubtags(languageCode: "en", countryCode: "FK"),
    Locale.fromSubtags(languageCode: "en", countryCode: "FM"),
    Locale.fromSubtags(languageCode: "en", countryCode: "GB"),
    Locale.fromSubtags(languageCode: "en", countryCode: "GD"),
    Locale.fromSubtags(languageCode: "en", countryCode: "GG"),
    Locale.fromSubtags(languageCode: "en", countryCode: "GH"),
    Locale.fromSubtags(languageCode: "en", countryCode: "GI"),
    Locale.fromSubtags(languageCode: "en", countryCode: "GM"),
    Locale.fromSubtags(languageCode: "en", countryCode: "GU"),
    Locale.fromSubtags(languageCode: "en", countryCode: "GY"),
    Locale.fromSubtags(languageCode: "en", countryCode: "HK"),
    Locale.fromSubtags(languageCode: "en", countryCode: "IE"),
    Locale.fromSubtags(languageCode: "en", countryCode: "IL"),
    Locale.fromSubtags(languageCode: "en", countryCode: "IM"),
    Locale.fromSubtags(languageCode: "en", countryCode: "IN"),
    Locale.fromSubtags(languageCode: "en", countryCode: "IO"),
    Locale.fromSubtags(languageCode: "en", countryCode: "JE"),
    Locale.fromSubtags(languageCode: "en", countryCode: "JM"),
    Locale.fromSubtags(languageCode: "en", countryCode: "KE"),
    Locale.fromSubtags(languageCode: "en", countryCode: "KI"),
    Locale.fromSubtags(languageCode: "en", countryCode: "KN"),
    Locale.fromSubtags(languageCode: "en", countryCode: "KY"),
    Locale.fromSubtags(languageCode: "en", countryCode: "LC"),
    Locale.fromSubtags(languageCode: "en", countryCode: "LR"),
    Locale.fromSubtags(languageCode: "en", countryCode: "LS"),
    Locale.fromSubtags(languageCode: "en", countryCode: "MG"),
    Locale.fromSubtags(languageCode: "en", countryCode: "MH"),
    Locale.fromSubtags(languageCode: "en", countryCode: "MO"),
    Locale.fromSubtags(languageCode: "en", countryCode: "MP"),
    Locale.fromSubtags(languageCode: "en", countryCode: "MS"),
    Locale.fromSubtags(languageCode: "en", countryCode: "MT"),
    Locale.fromSubtags(languageCode: "en", countryCode: "MU"),
    Locale.fromSubtags(languageCode: "en", countryCode: "MW"),
    Locale.fromSubtags(languageCode: "en", countryCode: "MY"),
    Locale.fromSubtags(languageCode: "en", countryCode: "NA"),
    Locale.fromSubtags(languageCode: "en", countryCode: "NF"),
    Locale.fromSubtags(languageCode: "en", countryCode: "NG"),
    Locale.fromSubtags(languageCode: "en", countryCode: "NL"),
    Locale.fromSubtags(languageCode: "en", countryCode: "NR"),
    Locale.fromSubtags(languageCode: "en", countryCode: "NU"),
    Locale.fromSubtags(languageCode: "en", countryCode: "NZ"),
    Locale.fromSubtags(languageCode: "en", countryCode: "PG"),
    Locale.fromSubtags(languageCode: "en", countryCode: "PH"),
    Locale.fromSubtags(languageCode: "en", countryCode: "PK"),
    Locale.fromSubtags(languageCode: "en", countryCode: "PN"),
    Locale.fromSubtags(languageCode: "en", countryCode: "PR"),
    Locale.fromSubtags(languageCode: "en", countryCode: "PW"),
    Locale.fromSubtags(languageCode: "en", countryCode: "RW"),
    Locale.fromSubtags(languageCode: "en", countryCode: "SB"),
    Locale.fromSubtags(languageCode: "en", countryCode: "SC"),
    Locale.fromSubtags(languageCode: "en", countryCode: "SD"),
    Locale.fromSubtags(languageCode: "en", countryCode: "SE"),
    Locale.fromSubtags(languageCode: "en", countryCode: "SG"),
    Locale.fromSubtags(languageCode: "en", countryCode: "SH"),
    Locale.fromSubtags(languageCode: "en", countryCode: "SI"),
    Locale.fromSubtags(languageCode: "en", countryCode: "SL"),
    Locale.fromSubtags(languageCode: "en", countryCode: "SS"),
    Locale.fromSubtags(languageCode: "en", countryCode: "SX"),
    Locale.fromSubtags(languageCode: "en", countryCode: "SZ"),
    Locale.fromSubtags(languageCode: "en", countryCode: "TC"),
    Locale.fromSubtags(languageCode: "en", countryCode: "TK"),
    Locale.fromSubtags(languageCode: "en", countryCode: "TO"),
    Locale.fromSubtags(languageCode: "en", countryCode: "TT"),
    Locale.fromSubtags(languageCode: "en", countryCode: "TV"),
    Locale.fromSubtags(languageCode: "en", countryCode: "TZ"),
    Locale.fromSubtags(languageCode: "en", countryCode: "UG"),
    Locale.fromSubtags(languageCode: "en", countryCode: "UM"),
    Locale.fromSubtags(languageCode: "en", countryCode: "US"),
    Locale.fromSubtags(languageCode: "en", countryCode: "VC"),
    Locale.fromSubtags(languageCode: "en", countryCode: "VG"),
    Locale.fromSubtags(languageCode: "en", countryCode: "VI"),
    Locale.fromSubtags(languageCode: "en", countryCode: "VU"),
    Locale.fromSubtags(languageCode: "en", countryCode: "WS"),
    Locale.fromSubtags(languageCode: "en", countryCode: "ZA"),
    Locale.fromSubtags(languageCode: "en", countryCode: "ZM"),
    Locale.fromSubtags(languageCode: "en", countryCode: "ZW"),
    Locale.fromSubtags(languageCode: "es", countryCode: "419"),
    Locale.fromSubtags(languageCode: "es", countryCode: "AR"),
    Locale.fromSubtags(languageCode: "es", countryCode: "BO"),
    Locale.fromSubtags(languageCode: "es", countryCode: "CL"),
    Locale.fromSubtags(languageCode: "es", countryCode: "CO"),
    Locale.fromSubtags(languageCode: "es", countryCode: "CR"),
    Locale.fromSubtags(languageCode: "es", countryCode: "CU"),
    Locale.fromSubtags(languageCode: "es", countryCode: "DO"),
    Locale.fromSubtags(languageCode: "es", countryCode: "EA"),
    Locale.fromSubtags(languageCode: "es", countryCode: "EC"),
    Locale.fromSubtags(languageCode: "es", countryCode: "ES"),
    Locale.fromSubtags(languageCode: "es", countryCode: "GQ"),
    Locale.fromSubtags(languageCode: "es", countryCode: "GT"),
    Locale.fromSubtags(languageCode: "es", countryCode: "HN"),
    Locale.fromSubtags(languageCode: "es", countryCode: "IC"),
    Locale.fromSubtags(languageCode: "es", countryCode: "MX"),
    Locale.fromSubtags(languageCode: "es", countryCode: "NI"),
    Locale.fromSubtags(languageCode: "es", countryCode: "PA"),
    Locale.fromSubtags(languageCode: "es", countryCode: "PE"),
    Locale.fromSubtags(languageCode: "es", countryCode: "PH"),
    Locale.fromSubtags(languageCode: "es", countryCode: "PR"),
    Locale.fromSubtags(languageCode: "es", countryCode: "PY"),
    Locale.fromSubtags(languageCode: "es", countryCode: "SV"),
    Locale.fromSubtags(languageCode: "es", countryCode: "US"),
    Locale.fromSubtags(languageCode: "es", countryCode: "UY"),
    Locale.fromSubtags(languageCode: "es", countryCode: "VE"),
    Locale.fromSubtags(languageCode: "et", countryCode: "EE"),
    Locale.fromSubtags(languageCode: "eu", countryCode: "ES"),
    Locale.fromSubtags(languageCode: "fa", countryCode: "AF"),
    Locale.fromSubtags(languageCode: "fa", countryCode: "IR"),
    Locale.fromSubtags(languageCode: "fi", countryCode: "FI"),
    Locale.fromSubtags(languageCode: "fo", countryCode: "DK"),
    Locale.fromSubtags(languageCode: "fo", countryCode: "FO"),
    Locale.fromSubtags(languageCode: "fr", countryCode: "BE"),
    Locale.fromSubtags(languageCode: "fr", countryCode: "BF"),
    Locale.fromSubtags(languageCode: "fr", countryCode: "BI"),
    Locale.fromSubtags(languageCode: "fr", countryCode: "BJ"),
    Locale.fromSubtags(languageCode: "fr", countryCode: "BL"),
    Locale.fromSubtags(languageCode: "fr", countryCode: "CA"),
    Locale.fromSubtags(languageCode: "fr", countryCode: "CD"),
    Locale.fromSubtags(languageCode: "fr", countryCode: "CF"),
    Locale.fromSubtags(languageCode: "fr", countryCode: "CG"),
    Locale.fromSubtags(languageCode: "fr", countryCode: "CH"),
    Locale.fromSubtags(languageCode: "fr", countryCode: "CI"),
    Locale.fromSubtags(languageCode: "fr", countryCode: "CM"),
    Locale.fromSubtags(languageCode: "fr", countryCode: "DJ"),
    Locale.fromSubtags(languageCode: "fr", countryCode: "DZ"),
    Locale.fromSubtags(languageCode: "fr", countryCode: "FR"),
    Locale.fromSubtags(languageCode: "fr", countryCode: "GA"),
    Locale.fromSubtags(languageCode: "fr", countryCode: "GF"),
    Locale.fromSubtags(languageCode: "fr", countryCode: "GN"),
    Locale.fromSubtags(languageCode: "fr", countryCode: "GP"),
    Locale.fromSubtags(languageCode: "fr", countryCode: "GQ"),
    Locale.fromSubtags(languageCode: "fr", countryCode: "HT"),
    Locale.fromSubtags(languageCode: "fr", countryCode: "KM"),
    Locale.fromSubtags(languageCode: "fr", countryCode: "LU"),
    Locale.fromSubtags(languageCode: "fr", countryCode: "MA"),
    Locale.fromSubtags(languageCode: "fr", countryCode: "MC"),
    Locale.fromSubtags(languageCode: "fr", countryCode: "MF"),
    Locale.fromSubtags(languageCode: "fr", countryCode: "MG"),
    Locale.fromSubtags(languageCode: "fr", countryCode: "ML"),
    Locale.fromSubtags(languageCode: "fr", countryCode: "MQ"),
    Locale.fromSubtags(languageCode: "fr", countryCode: "MR"),
    Locale.fromSubtags(languageCode: "fr", countryCode: "MU"),
    Locale.fromSubtags(languageCode: "fr", countryCode: "NC"),
    Locale.fromSubtags(languageCode: "fr", countryCode: "NE"),
    Locale.fromSubtags(languageCode: "fr", countryCode: "PF"),
    Locale.fromSubtags(languageCode: "fr", countryCode: "PM"),
    Locale.fromSubtags(languageCode: "fr", countryCode: "RE"),
    Locale.fromSubtags(languageCode: "fr", countryCode: "RW"),
    Locale.fromSubtags(languageCode: "fr", countryCode: "SC"),
    Locale.fromSubtags(languageCode: "fr", countryCode: "SN"),
    Locale.fromSubtags(languageCode: "fr", countryCode: "SY"),
    Locale.fromSubtags(languageCode: "fr", countryCode: "TD"),
    Locale.fromSubtags(languageCode: "fr", countryCode: "TG"),
    Locale.fromSubtags(languageCode: "fr", countryCode: "TN"),
    Locale.fromSubtags(languageCode: "fr", countryCode: "VU"),
    Locale.fromSubtags(languageCode: "fr", countryCode: "WF"),
    Locale.fromSubtags(languageCode: "fr", countryCode: "YT"),
    Locale.fromSubtags(languageCode: "ga", countryCode: "IE"),
    Locale.fromSubtags(languageCode: "gd", countryCode: "GB"),
    Locale.fromSubtags(languageCode: "gl", countryCode: "ES"),
    Locale.fromSubtags(languageCode: "gu", countryCode: "IN"),
    Locale.fromSubtags(languageCode: "ha", countryCode: "GH"),
    Locale.fromSubtags(languageCode: "ha", countryCode: "NE"),
    Locale.fromSubtags(languageCode: "ha", countryCode: "NG"),
    Locale.fromSubtags(languageCode: "he", countryCode: "IL"),
    Locale.fromSubtags(languageCode: "hi", countryCode: "IN"),
    Locale.fromSubtags(languageCode: "hr", countryCode: "BA"),
    Locale.fromSubtags(languageCode: "hr", countryCode: "HR"),
    Locale.fromSubtags(languageCode: "hu", countryCode: "HU"),
    Locale.fromSubtags(languageCode: "hy", countryCode: "AM"),
    Locale.fromSubtags(languageCode: "id", countryCode: "ID"),
    Locale.fromSubtags(languageCode: "ig", countryCode: "NG"),
    Locale.fromSubtags(languageCode: "is", countryCode: "IS"),
    Locale.fromSubtags(languageCode: "it", countryCode: "CH"),
    Locale.fromSubtags(languageCode: "it", countryCode: "IT"),
    Locale.fromSubtags(languageCode: "it", countryCode: "SM"),
    Locale.fromSubtags(languageCode: "ja", countryCode: "JP"),
    Locale.fromSubtags(languageCode: "jv", countryCode: "ID"),
    Locale.fromSubtags(languageCode: "ka", countryCode: "GE"),
    Locale.fromSubtags(languageCode: "kk", countryCode: "KZ"),
    Locale.fromSubtags(languageCode: "kl", countryCode: "GL"),
    Locale.fromSubtags(languageCode: "km", countryCode: "KH"),
    Locale.fromSubtags(languageCode: "kn", countryCode: "IN"),
    Locale.fromSubtags(languageCode: "ko", countryCode: "KP"),
    Locale.fromSubtags(languageCode: "ko", countryCode: "KR"),
    Locale.fromSubtags(languageCode: "kw", countryCode: "GB"),
    Locale.fromSubtags(languageCode: "ky", countryCode: "KG"),
    Locale.fromSubtags(languageCode: "lo", countryCode: "LA"),
    Locale.fromSubtags(languageCode: "lt", countryCode: "LT"),
    Locale.fromSubtags(languageCode: "lu", countryCode: "CD"),
    Locale.fromSubtags(languageCode: "lv", countryCode: "LV"),
    Locale.fromSubtags(languageCode: "mg", countryCode: "MG"),
    Locale.fromSubtags(languageCode: "mk", countryCode: "MK"),
    Locale.fromSubtags(languageCode: "ml", countryCode: "IN"),
    Locale.fromSubtags(languageCode: "mn", countryCode: "MN"),
    Locale.fromSubtags(languageCode: "mr", countryCode: "IN"),
    Locale.fromSubtags(languageCode: "ms", countryCode: "BN"),
    Locale.fromSubtags(languageCode: "ms", countryCode: "MY"),
    Locale.fromSubtags(languageCode: "ms", countryCode: "SG"),
    Locale.fromSubtags(languageCode: "mt", countryCode: "MT"),
    Locale.fromSubtags(languageCode: "my", countryCode: "MM"),
    Locale.fromSubtags(languageCode: "nb", countryCode: "NO"),
    Locale.fromSubtags(languageCode: "nb", countryCode: "SJ"),
    Locale.fromSubtags(languageCode: "ne", countryCode: "IN"),
    Locale.fromSubtags(languageCode: "ne", countryCode: "NP"),
    Locale.fromSubtags(languageCode: "nl", countryCode: "AW"),
    Locale.fromSubtags(languageCode: "nl", countryCode: "BE"),
    Locale.fromSubtags(languageCode: "nl", countryCode: "BQ"),
    Locale.fromSubtags(languageCode: "nl", countryCode: "CW"),
    Locale.fromSubtags(languageCode: "nl", countryCode: "NL"),
    Locale.fromSubtags(languageCode: "nl", countryCode: "SR"),
    Locale.fromSubtags(languageCode: "nl", countryCode: "SX"),
    Locale.fromSubtags(languageCode: "nn", countryCode: "NO"),
    Locale.fromSubtags(languageCode: "or", countryCode: "IN"),
    Locale.fromSubtags(languageCode: "os", countryCode: "GE"),
    Locale.fromSubtags(languageCode: "os", countryCode: "RU"),
    Locale.fromSubtags(languageCode: "pa", countryCode: "IN"),
    Locale.fromSubtags(languageCode: "pa", countryCode: "PK"),
    Locale.fromSubtags(languageCode: "ps", countryCode: "AF"),
    Locale.fromSubtags(languageCode: "ps", countryCode: "PK"),
    Locale.fromSubtags(languageCode: "pt", countryCode: "AO"),
    Locale.fromSubtags(languageCode: "pt", countryCode: "BR"),
    Locale.fromSubtags(languageCode: "pt", countryCode: "CV"),
    Locale.fromSubtags(languageCode: "pt", countryCode: "GW"),
    Locale.fromSubtags(languageCode: "pt", countryCode: "MO"),
    Locale.fromSubtags(languageCode: "pt", countryCode: "MZ"),
    Locale.fromSubtags(languageCode: "pt", countryCode: "PT"),
    Locale.fromSubtags(languageCode: "pt", countryCode: "ST"),
    Locale.fromSubtags(languageCode: "pt", countryCode: "TL"),
    Locale.fromSubtags(languageCode: "qu", countryCode: "BO"),
    Locale.fromSubtags(languageCode: "qu", countryCode: "EC"),
    Locale.fromSubtags(languageCode: "qu", countryCode: "PE"),
    Locale.fromSubtags(languageCode: "rm", countryCode: "CH"),
    Locale.fromSubtags(languageCode: "ro", countryCode: "MD"),
    Locale.fromSubtags(languageCode: "ro", countryCode: "RO"),
    Locale.fromSubtags(languageCode: "ru", countryCode: "BY"),
    Locale.fromSubtags(languageCode: "ru", countryCode: "KG"),
    Locale.fromSubtags(languageCode: "ru", countryCode: "KZ"),
    Locale.fromSubtags(languageCode: "ru", countryCode: "MD"),
    Locale.fromSubtags(languageCode: "ru", countryCode: "RU"),
    Locale.fromSubtags(languageCode: "ru", countryCode: "UA"),
    Locale.fromSubtags(languageCode: "se", countryCode: "FI"),
    Locale.fromSubtags(languageCode: "se", countryCode: "NO"),
    Locale.fromSubtags(languageCode: "se", countryCode: "SE"),
    Locale.fromSubtags(languageCode: "sg", countryCode: "CF"),
    Locale.fromSubtags(languageCode: "sh", countryCode: "BA"),
    Locale.fromSubtags(languageCode: "si", countryCode: "LK"),
    Locale.fromSubtags(languageCode: "sl", countryCode: "SI"),
    Locale.fromSubtags(languageCode: "sn", countryCode: "ZW"),
    Locale.fromSubtags(languageCode: "so", countryCode: "DJ"),
    Locale.fromSubtags(languageCode: "so", countryCode: "ET"),
    Locale.fromSubtags(languageCode: "so", countryCode: "KE"),
    Locale.fromSubtags(languageCode: "so", countryCode: "SO"),
    Locale.fromSubtags(languageCode: "sq", countryCode: "AL"),
    Locale.fromSubtags(languageCode: "sq", countryCode: "MK"),
    Locale.fromSubtags(languageCode: "sq", countryCode: "XK"),
    Locale.fromSubtags(languageCode: "sr", countryCode: "BA"),
    Locale.fromSubtags(languageCode: "sr", countryCode: "ME"),
    Locale.fromSubtags(languageCode: "sr", countryCode: "RS"),
    Locale.fromSubtags(languageCode: "sr", countryCode: "XK"),
    Locale.fromSubtags(
        languageCode: "sr", scriptCode: "Cyrl", countryCode: "BA"),
    Locale.fromSubtags(
        languageCode: "sr", scriptCode: "Cyrl", countryCode: "ME"),
    Locale.fromSubtags(
        languageCode: "sr", scriptCode: "Cyrl", countryCode: "XK"),
    Locale.fromSubtags(
        languageCode: "sr", scriptCode: "Latn", countryCode: "BA"),
    Locale.fromSubtags(
        languageCode: "sr", scriptCode: "Latn", countryCode: "ME"),
    Locale.fromSubtags(
        languageCode: "sr", scriptCode: "Latn", countryCode: "RS"),
    Locale.fromSubtags(
        languageCode: "sr", scriptCode: "Latn", countryCode: "XK"),
    Locale.fromSubtags(languageCode: "sv", countryCode: "AX"),
    Locale.fromSubtags(languageCode: "sv", countryCode: "FI"),
    Locale.fromSubtags(languageCode: "sv", countryCode: "SE"),
    Locale.fromSubtags(languageCode: "sw", countryCode: "CD"),
    Locale.fromSubtags(languageCode: "sw", countryCode: "KE"),
    Locale.fromSubtags(languageCode: "sw", countryCode: "TZ"),
    Locale.fromSubtags(languageCode: "sw", countryCode: "UG"),
    Locale.fromSubtags(languageCode: "ta", countryCode: "IN"),
    Locale.fromSubtags(languageCode: "ta", countryCode: "LK"),
    Locale.fromSubtags(languageCode: "ta", countryCode: "MY"),
    Locale.fromSubtags(languageCode: "ta", countryCode: "SG"),
    Locale.fromSubtags(languageCode: "te", countryCode: "IN"),
    Locale.fromSubtags(languageCode: "tg", countryCode: "TJ"),
    Locale.fromSubtags(languageCode: "th", countryCode: "TH"),
    Locale.fromSubtags(languageCode: "ti", countryCode: "ER"),
    Locale.fromSubtags(languageCode: "ti", countryCode: "ET"),
    Locale.fromSubtags(languageCode: "to", countryCode: "TO"),
    Locale.fromSubtags(languageCode: "tr", countryCode: "CY"),
    Locale.fromSubtags(languageCode: "tr", countryCode: "TR"),
    Locale.fromSubtags(languageCode: "tt", countryCode: "RU"),
    Locale.fromSubtags(languageCode: "uk", countryCode: "UA"),
    Locale.fromSubtags(languageCode: "ur", countryCode: "IN"),
    Locale.fromSubtags(languageCode: "ur", countryCode: "PK"),
    Locale.fromSubtags(languageCode: "uz", countryCode: "AF"),
    Locale.fromSubtags(languageCode: "uz", countryCode: "UZ"),
    Locale.fromSubtags(
        languageCode: "uz", scriptCode: "Cyrl", countryCode: "UZ"),
    Locale.fromSubtags(
        languageCode: "uz", scriptCode: "Latn", countryCode: "UZ"),
    Locale.fromSubtags(languageCode: "vi", countryCode: "VN"),
    Locale.fromSubtags(languageCode: "yo", countryCode: "BJ"),
    Locale.fromSubtags(languageCode: "yo", countryCode: "NG"),
    Locale.fromSubtags(languageCode: "zh", countryCode: "CN"),
    Locale.fromSubtags(languageCode: "zh", countryCode: "HK"),
    Locale.fromSubtags(languageCode: "zh", countryCode: "MO"),
    Locale.fromSubtags(languageCode: "zh", countryCode: "SG"),
    Locale.fromSubtags(languageCode: "zh", countryCode: "TW"),
    Locale.fromSubtags(
        languageCode: "zh", scriptCode: "Hans", countryCode: "HK"),
    Locale.fromSubtags(
        languageCode: "zh", scriptCode: "Hans", countryCode: "MO"),
    Locale.fromSubtags(
        languageCode: "zh", scriptCode: "Hans", countryCode: "SG"),
    Locale.fromSubtags(
        languageCode: "zh", scriptCode: "Hant", countryCode: "HK"),
    Locale.fromSubtags(
        languageCode: "zh", scriptCode: "Hant", countryCode: "MO"),
    Locale.fromSubtags(
        languageCode: "zh", scriptCode: "Hant", countryCode: "TW"),
    Locale.fromSubtags(languageCode: "zu", countryCode: "ZA")
  ];

  Locale? _value1 = languages[0];
  Locale? _value2 = scripts[0];
  Locale? _value3 = countries[0];
  Locale? _value4 = languages[0];
  Locale? _value5 = scripts[0];
  Locale? _value6 = countries[0];
  Locale? _value7 = languages[0];
  Locale? _value8 = scripts[0];
  Locale? _value9 = countries[0];
  Locale? _locale1 = languages[0];
  Locale? _locale2 = languages[0];
  Locale? _locale3 = languages[0];

  @override
  Widget build(BuildContext context) {
    return MaterialApp(
      home: Scaffold(
        appBar: AppBar(
          title: Text("Locale names example"),
        ),
        body: Container(
          padding: EdgeInsets.all(20.0),
          child: SingleChildScrollView(
            child: Column(
              crossAxisAlignment: CrossAxisAlignment.start,
              children: [
                Text(
                    "Display Language Names in English (defaultDisplayLanguage)"),
                DropdownButton(
                  value: _value1,
                  items: [
                    ...languages.map(
                      (language) => DropdownMenuItem(
                        child: Text(language.defaultDisplayLanguage ?? ''),
                        value: language,
                      ),
                    ),
                  ],
                  onChanged: (value) {
                    setState(() {
                      _value1 = value;
                    });
                  },
                ),
                SizedBox(height: 30),
                Text(
                    "Display Language Script Names in English (defaultDisplayLanguageScript)"),
                DropdownButton(
                  value: _value2,
                  items: [
                    ...scripts.map(
                      (script) => DropdownMenuItem(
                        child: Text(script.defaultDisplayLanguageScript ?? ''),
                        value: script,
                      ),
                    ),
                  ],
                  onChanged: (value) {
                    setState(() {
                      _value2 = value;
                    });
                  },
                ),
                SizedBox(height: 30),
                Text(
                    "Display Country Names in English (defaultDisplayCountry)"),
                DropdownButton(
                  value: _value3,
                  items: [
                    ...countries.map(
                      (country) => DropdownMenuItem(
                        child: Text(country.defaultDisplayCountry ?? ''),
                        value: country,
                      ),
                    ),
                  ],
                  onChanged: (value) {
                    setState(() {
                      _value3 = value;
                    });
                  },
                ),
                SizedBox(height: 30),
                Text(
                    "Display Language Names in Native Languages (nativeDisplayLanguage)"),
                DropdownButton(
                  value: _value4,
                  items: [
                    ...languages.map(
                      (language) => DropdownMenuItem(
                        child: Text(language.nativeDisplayLanguage ?? ''),
                        value: language,
                      ),
                    ),
                  ],
                  onChanged: (value) {
                    setState(() {
                      _value4 = value;
                    });
                  },
                ),
                SizedBox(height: 30),
                Text(
                    "Display Language Script Names in Native Languages (nativeDisplayLanguageScript)"),
                DropdownButton(
                  value: _value5,
                  items: [
                    ...scripts.map(
                      (script) => DropdownMenuItem(
                        child: Text(script.nativeDisplayLanguageScript ?? ''),
                        value: script,
                      ),
                    ),
                  ],
                  onChanged: (value) {
                    setState(() {
                      _value5 = value;
                    });
                  },
                ),
                SizedBox(height: 30),
                Text(
                    "Display Country Names in Native Languages (nativeDisplayCountry)"),
                DropdownButton(
                  value: _value6,
                  items: [
                    ...countries.map(
                      (country) => DropdownMenuItem(
                        child: Text(country.nativeDisplayCountry ?? ''),
                        value: country,
                      ),
                    ),
                  ],
                  onChanged: (value) {
                    setState(() {
                      _value6 = value;
                    });
                  },
                ),
                SizedBox(height: 30),
                Row(
                  children: [
                    Text("Display Language Names in "),
                    DropdownButton(
                      value: _locale1,
                      items: [
                        ...languages.map(
                          (language) => DropdownMenuItem(
                            child: Text(language.toString()),
                            value: language,
                          ),
                        ),
                      ],
                      onChanged: (value) {
                        setState(() {
                          _locale1 = value;
                        });
                      },
                    ),
                  ],
                ),
                DropdownButton(
                  value: _value7,
                  items: [
                    ...languages.map(
                      (language) => DropdownMenuItem(
                        child: Text(language.displayLanguageIn(_locale1!) ?? ''),
                        value: language,
                      ),
                    ),
                  ],
                  onChanged: (value) {
                    setState(() {
                      _value7 = value;
                    });
                  },
                ),
                SizedBox(height: 30),
                Row(
                  children: [
                    Text("Display Language Script Names in "),
                    DropdownButton(
                      value: _locale2,
                      items: [
                        ...languages.map(
                          (language) => DropdownMenuItem(
                            child: Text(language.toString()),
                            value: language,
                          ),
                        ),
                      ],
                      onChanged: (value) {
                        setState(() {
                          _locale2 = value;
                        });
                      },
                    ),
                  ],
                ),
                DropdownButton(
                  value: _value8,
                  items: [
                    ...scripts.map(
                      (script) => DropdownMenuItem(
                        child: Text(script.displayLanguageScriptIn(_locale2!) ?? ''),
                        value: script,
                      ),
                    ),
                  ],
                  onChanged: (value) {
                    setState(() {
                      _value8 = value;
                    });
                  },
                ),
                SizedBox(height: 30),
                Row(
                  children: [
                    Text("Display Country Names in "),
                    DropdownButton(
                      value: _locale3,
                      items: [
                        ...languages.map(
                          (language) => DropdownMenuItem(
                            child: Text(language.toString()),
                            value: language,
                          ),
                        ),
                      ],
                      onChanged: (value) {
                        setState(() {
                          _locale3 = value;
                        });
                      },
                    ),
                  ],
                ),
                DropdownButton(
                  value: _value9,
                  items: [
                    ...countries.map(
                      (country) => DropdownMenuItem(
                        child: Text(country.displayCountryIn(_locale3!) ?? ''),
                        value: country,
                      ),
                    ),
                  ],
                  onChanged: (value) {
                    setState(() {
                      _value9 = value;
                    });
                  },
                ),
              ],
            ),
          ),
        ),
      ),
    );
  }
}
