package com.ulicae.cinelog.room.dto.utils.from;

import com.ulicae.cinelog.room.dao.ReviewTagCrossRefDao;
import com.ulicae.cinelog.room.dto.KinoDto;
import com.ulicae.cinelog.room.dto.SerieDto;
import com.ulicae.cinelog.room.dto.TagDto;
import com.ulicae.cinelog.room.entities.ReviewTagCrossRef;

/**
 * CineLog Copyright 2024 Pierre Rognon
 * <p>
 * <p>
 * This file is part of CineLog.
 * CineLog is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * <p>
 * CineLog is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * <p>
 * You should have received a copy of the GNU General Public License
 * along with CineLog. If not, see <https://www.gnu.org/licenses/>.
 */
public class TagReviewCrossRefFromDtoCreator extends AsyncEntityFromDtoCreator<ReviewTagCrossRef, ReviewTagCrossRefDao, TagDto> {
    private final KinoDto kinoDto;

    private final int biggestMovieReviewId;

    public TagReviewCrossRefFromDtoCreator(ReviewTagCrossRefDao reviewTagCrossRefDao, KinoDto kinoDto, int biggestMovieReviewId) {
        super(reviewTagCrossRefDao);
        this.kinoDto = kinoDto;
        this.biggestMovieReviewId = biggestMovieReviewId;
    }

    // TODO not public
    @Override
    public ReviewTagCrossRef createRoomInstanceFromDto(TagDto itemDto) {
        return new ReviewTagCrossRef(
                Math.toIntExact(kinoDto instanceof SerieDto ? biggestMovieReviewId + kinoDto.getId() : kinoDto.getId()),
                Math.toIntExact(itemDto.getId())
        );
    }
}
