package com.ulicae.cinelog.room.converters;

import androidx.room.TypeConverter;

import com.ulicae.cinelog.room.entities.ItemEntityType;

import java.util.Date;

/**
 * CineLog Copyright 2024 Pierre Rognon
 * <p>
 * <p>
 * This file is part of CineLog.
 * CineLog is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * <p>
 * CineLog is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * <p>
 * You should have received a copy of the GNU General Public License
 * along with CineLog. If not, see <https://www.gnu.org/licenses/>.
 */
public class Converters {
    @TypeConverter
    public static Date fromTimestamp(Long value) {
        return value == null ? null : new Date(value);
    }

    @TypeConverter
    public static Long dateToTimestamp(Date date) {
        return date == null ? null : date.getTime();
    }

    @TypeConverter
    public static String reviewEntityTypeToString(ItemEntityType itemEntityType) {
        return itemEntityType.toString();
    }

    @TypeConverter
    public static ItemEntityType reviewEntityTypeFromString(String reviewEntityType) {
        return ItemEntityType.valueOf(reviewEntityType);
    }
}
