package com.ulicae.cinelog.io.exportdb.exporter;

import com.ulicae.cinelog.room.dto.ItemDto;
import com.ulicae.cinelog.room.services.AsyncDataService;
import com.ulicae.cinelog.io.exportdb.writer.CsvExportWriter;

import java.util.List;

import io.reactivex.rxjava3.core.Flowable;

/**
 * CineLog Copyright 2024 Pierre Rognon
 * <p>
 * <p>
 * This file is part of CineLog.
 * CineLog is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * <p>
 * CineLog is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * <p>
 * You should have received a copy of the GNU General Public License
 * along with CineLog. If not, see <https://www.gnu.org/licenses/>.
 */
public class AsyncCsvExporter<T extends ItemDto> implements CsvExporter<T> {
    private final AsyncDataService<T> service;
    private final CsvExportWriter<T> csvExportWriter;

    AsyncCsvExporter(AsyncDataService<T> service, CsvExportWriter<T> csvExportWriter) {
        this.service = service;
        this.csvExportWriter = csvExportWriter;
    }

    public Flowable<List<T>> export() {
        return service
                .findAll()
                .doOnNext(
                        dtos -> {
                            for (T dto : dtos) {
                                csvExportWriter.write(dto);
                            }

                            csvExportWriter.endWriting();
                        }
                );
    }
}
