package com.ulicae.cinelog.android.v2.fragments.review.edit;

import static org.mockito.Mockito.doReturn;
import static org.mockito.Mockito.verify;

import com.ulicae.cinelog.room.dto.data.WishlistDataDto;
import com.ulicae.cinelog.room.services.WishlistAsyncService;

import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.junit.MockitoJUnitRunner;

import io.reactivex.rxjava3.core.Flowable;

/**
 * CineLog Copyright 2019 Pierre Rognon
 *
 *
 * This file is part of CineLog.
 * CineLog is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * CineLog is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with CineLog. If not, see <https://www.gnu.org/licenses/>.
 *
 */
@RunWith(MockitoJUnitRunner.class)
public class WishlistItemDeleterTest {

    @Mock
    private WishlistAsyncService wishlistAsyncService;

    @Mock
    private WishlistDataDto wishlistDataDto;


    @Test
    public void deleteWishlistItem() {
        doReturn(Flowable.just(wishlistDataDto)).when(wishlistAsyncService).findById(1564L);

        new WishlistItemDeleter(wishlistAsyncService).deleteWishlistItem(1564L);

        verify(wishlistAsyncService).delete(wishlistDataDto);
    }

}